#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

void WindowBoxIn( HDC hDC, RECT * pRect );

// JAVIER ALCAZAR Y JOSE LUIS HORTAL

//----------------------------------------------------------------------------//

CLIPPER MeterPaint()         //  hWnd, hDC, nActual, nTotal, porcentage, Texto, lporcentage, 4 colores, font
{
   HWND hWnd = _parni( 1 );
   HDC  hDC  = _parni( 2 );
   RECT rc, rcClient;
   WORD wCol, wRow, wRight;
   BYTE cChars[ 81 ] = { ' ' } ;
   WORD wPercent = _parni(  5 );
   char * cText  = _parc(   6 );
   int iPorcent  = _parl(   7 );
   DWORD dwPane  = _parnl(  8 );
   DWORD dwText  = _parnl(  9 );
   DWORD dwBar   = _parnl( 10 );
   DWORD dwBText = _parnl( 11 );
   HFONT hFont   = _parni( 12 );
   HFONT hOldFont;
   int nLenght  = 0;
   SIZE nSizes;

   if( hFont )
      hOldFont = SelectObject( hDC, hFont );

   if( cText[ 0 ] )
   {
      strcpy( cChars, cText );
      nLenght = strlen( cChars );
      cChars[ nLenght++ ] = ' ';

   }
   if( iPorcent )
   {
      if( wPercent == 100 )
      {
          cChars[ nLenght     ] = '1';
          cChars[ nLenght + 1 ] = '0';
      }
      else
      {
          cChars[ nLenght     ] = ' ';
          cChars[ nLenght + 1 ] = ( wPercent < 10 ? ' ' : ( BYTE ) ( wPercent / 10 )   + '0' );
      }
      cChars[ nLenght + 2 ] = ( BYTE ) ( wPercent % 10 )   + '0';
      cChars[ nLenght + 3 ] = '%';
      nLenght += 4;
   }

   GetClientRect( hWnd, &rc );

   rcClient.top    = rc.top;
   rcClient.left   = rc.left;
   rcClient.bottom = rc.bottom - 1;
   rcClient.right  = rc.right  - 1;

   GetTextExtentPoint( hDC, cChars, nLenght, &nSizes );

   wCol   = ( ( rc.right - rc.left ) / 2 ) - ( nSizes.cx / 2 );
   wRow   = ( ( rc.bottom - rc.top ) / 2 ) - ( nSizes.cy / 2 );
   wRight = rc.right;
   rc.top++;
   rc.left++;
   rc.bottom--;
   rc.right = ( WORD ) --rc.right * wPercent / 100;

   SetBkColor( hDC, dwBar );
   SetTextColor( hDC, dwBText );

   ExtTextOut( hDC, wCol, wRow, ETO_CLIPPED | ETO_OPAQUE, &rc, cChars, nLenght, 0 );

   WindowBoxIn( hDC, &rcClient );

   SetBkColor( hDC, dwPane );
   SetTextColor( hDC, dwText );

   rc.left  = rc.right + 1;
   rc.right = wRight - 1;

   if( wPercent < 100 )
       ExtTextOut( hDC, wCol, wRow, ETO_CLIPPED | ETO_OPAQUE, &rc, cChars, nLenght, 0 );

   if( hFont )
      SelectObject( hDC, hOldFont );

   _retni( 0 );
}

//----------------------------------------------------------------------------//
