#ifndef _MENU_CH
#define _MENU_CH

//----------------------------------------------------------------------------//
// Creating PullDown Menus from source code

#xcommand MENU [ <oMenu> ] ;
             [ <popup: POPUP> ] ;
       => ;
          [ <oMenu> := ] MenuBegin( <.popup.> )

#xcommand MENUITEM [ <oMenuItem> PROMPT ] [<cPrompt>] ;
             [ MESSAGE <cMsg> ] ;
             [ <checked: CHECK, CHECKED, MARK> ] ;
             [ <enable: ENABLED, DISABLED> ] ;
             [ <file: FILE, FILENAME, DISK> <cBmpFile> ] ;
             [ <resource: RESOURCE, RESNAME, NAME> <cResName> ] ;
             [ ACTION <uAction> ] ;
             [ BLOCK <bAction> ] ;
             [ <of: OF, MENU, SYSMENU> <oMenu> ] ;
             [ ACCELERATOR <nState>, <nVirtKey> ] ;
             [ <help: HELP> ] ;
       => ;
          [ <oMenuItem> := ] MenuAddItem( <cPrompt>, <cMsg>,;
             <.checked.>, [ Upper(<(enable)>) == "ENABLED" ], <{uAction}>,;
             <cBmpFile>, <cResName>, <oMenu>, <bAction>, <nState>, <nVirtKey>,;
             <.help.> )

#xcommand SEPARATOR => MenuAddItem()

#xcommand ENDMENU => MenuEnd()

//----------------------------------------------------------------------------//
// Creating PullDown Menus from resources

#xcommand DEFINE MENU <oMenu> ;
             [ <res: RESOURCE, NAME, RESNAME> <cResName> ] ;
             [ <popup: POPUP> ] ;
       => ;
          <oMenu> := TMenu():ReDefine( <cResName>, <.popup.> )

#xcommand REDEFINE MENUITEM [ <oMenuItem> PROMPT <cPrompt> ] ;
             [ ID <nId> <of: OF, MENU> <oMenu> ] ;
             [ ACTION <uAction> ] ;
             [ BLOCK  <bAction> ] ;
             [ MESSAGE <cMsg> ] ;
             [ <checked: CHECK, CHECKED, MARK> ] ;
             [ <enable: ENABLED, DISABLED> ] ;
             [ <file: FILE, FILENAME, DISK> <cBmpFile> ] ;
             [ <resource: RESOURCE, RESNAME, NAME> <cResName> ] ;
             [ ACCELERATOR <nState>, <nVirtKey> ] ;
       => ;
          [ <oMenuItem> := ] TMenuItem():ReDefine( <cPrompt>, <cMsg>,;
             <.checked.>, [ Upper(<(enable)>) == "ENABLED" ], <{uAction}>,;
             <cBmpFile>, <cResName>, <oMenu>, <bAction>, <nId>,;
             <nState>, <nVirtKey>  )

//----------------------------------------------------------------------------//

#xcommand DEFINE MENU <oMenu> OF <oWnd> ;
       => ;
          <oMenu> := TMenu():New( .f., <oWnd> )

#xcommand SET MENU OF <oWnd> TO <oMenu> => <oWnd>:SetMenu( <oMenu> )

//----------------------------------------------------------------------------//
// PopUps Management

#xcommand ACTIVATE <menu:POPUP,MENU> <oMenu> ;
             [ AT <nRow>, <nCol> ] ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
       => ;
          <oMenu>:Activate( <nRow>, <nCol>, <oWnd> )

//----------------------------------------------------------------------------//
// Using Window System Menu

#xcommand REDEFINE SYSMENU <oMenu> ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
       => ;
          <oMenu> := MenuBegin( .f., .t., <oWnd> )

#xcommand ENDSYSMENU => MenuEnd()

#endif
