#include "FiveWin.ch"
#include "Constant.ch"

#define SC_RESTORE     61728
#define SC_MINIMIZE    61472
#define SC_CLOSE       61536
#define SC_NEXT        61504

#define SIZE_MAXIMIZED     2
#define CW_USEDEFAULT  32768

#define WM_GETFONT      49  // 0x0031

static lRegistered := .f.

static oWndMain

//----------------------------------------------------------------------------//

CLASS TMdiFrame FROM TWindow

   DATA   oWndClient, oWndActive
   DATA   oMenuStart
   DATA   nMenuInfo

   METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
               oBrush, oIcon, nClrFore, nClrBack, lVScroll,;
               lHScroll, nMenuInfo, cBorder, oWnd ) CONSTRUCTOR

   METHOD ChildNew( nTop, nLeft, nBottom, nRight, cTitle, nStyle ) INLINE ;
          ::oWndClient:ChildNew( nTop, nLeft, nBottom, nRight, cTitle, nStyle )

   METHOD Cascade()      INLINE ::oWndClient:Cascade()
   METHOD CloseAll()     INLINE ::oWndClient:lCloseAll()
   METHOD IconizeAll()   INLINE ::oWndClient:IconizeAll()

   METHOD Tile( lHor )   INLINE ::oWndClient:Tile( lHor )
   METHOD ArrangeIcons() INLINE ::oWndClient:ArrangeIcons()
   METHOD NextWindow()   INLINE ::oWndClient:NextWindow()

   METHOD ReSize( nSizeType, nWidth, nHeight )

   METHOD Command( nWParam, nLParam )

   METHOD End()

   METHOD GotFocus() INLINE Super:GotFocus(), ::oWndClient:SetFocus(), 0

   METHOD Select( nWindow ) INLINE ::oWndClient:Select( nWindow )

   METHOD SetMenu( oMenu, nMenuInfo )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu, oBrush,;
            oIcon, nClrFore, nClrBack, lVScroll, lHScroll, nMenuInfo,;
            cBorder, oWnd ) CLASS TMdiFrame

   DEFAULT nStyle    := nOR( WS_OVERLAPPEDWINDOW, WS_CLIPCHILDREN ),;
           lVScroll  := .f., lHScroll := .f.,;
           nMenuInfo := If( oMenu != nil, Len( oMenu:aItems ), 2 ),;
           nClrFore  := CLR_BLACK, nClrBack := CLR_GRAY

   ::nTop        = If( nTop    != nil, nTop    * MDIF_CHARPIX_H, CW_USEDEFAULT )			//16
   ::nLeft       = If( nLeft   != nil, nLeft   * MDIF_CHARPIX_W, CW_USEDEFAULT )			// 8
   ::nBottom     = If( nBottom != nil, nBottom * MDIF_CHARPIX_H, CW_USEDEFAULT )		//16
   ::nRight      = If( nRight  != nil, nRight  * MDIF_CHARPIX_W, CW_USEDEFAULT )		//  8
   ::nStyle      = nStyle
   ::cCaption    = cTitle
   ::nId         = 0
   ::oIcon       = oIcon
   ::lValidating = .f.
   ::lVisible    = .t.
   ::oWnd        = oWnd
   ::oMenu       = oMenu
   ::nMenuInfo   = nMenuInfo

   if oMenu == nil
      MENU oMenu
         MENUITEM "&Childs"
         MENU
            MENUITEM "New..." ACTION ::ChildNew()
            SEPARATOR
            MENUITEM "E&xit"  ACTION ::End()
         ENDMENU
         MENUITEM "&Window"
         MENU
            MENUITEM "&Tile Vertical"   ACTION ::Tile()
            MENUITEM "&Tile Horizontal" ACTION ::Tile( .t. )
            MENUITEM "&Cascade"         ACTION ::Cascade()
            MENUITEM "&Next Window"     ACTION ::NextWindow()
            MENUITEM "&Arrange Icons"   ACTION ::ArrangeIcons()
            MENUITEM "&Iconize All"     ACTION ::IconizeAll()
            MENUITEM "&Close All"       ACTION ::CloseAll()
         ENDMENU
      ENDMENU
      ::oMenu = oMenu
   endif

   if ! lRegistered
      RegisterClass( ::ClassName(),;
                     nOR( CS_VREDRAW, CS_HREDRAW ),;
                     0, 0, 0, 0, 0, "", GetFrameProc() )
      lRegistered = .t.
   endif

   ::Create()
   ::SetColor( nClrFore, nClrBack, oBrush )
                                        // SubMenu, nChild
   ::oWndClient = TMdiClient():New( Self, nMenuInfo, 1,, lVScroll,;
                                    lHScroll )
   ::oWndClient:SetColor( nClrFore, nClrBack, oBrush )

   ::SetMenu( oMenu )

   if ::oFont == nil
      ::oFont = TFont()
      ::oFont:hFont = ::SendMsg( WM_GETFONT )
   endif

   oWndMain = Self
   SetWndDefault( Self )

return nil

//----------------------------------------------------------------------------//

METHOD ReSize( nSizeType, nWidth, nHeight ) CLASS TMdiFrame

   local nTop  := If( ::oBar != nil .and. ::oBar:nMode == 1,;
                      ::oBar:nBtnHeight + 1, 0 )
   local nLeft := If( ::oBar != nil .and. ::oBar:nMode == 2,;
                      ::oBar:nBtnWidth, 0 )

   nWidth  = If( ::oBar != nil .and. ;
                 ( ::oBar:nMode == 2 .or. ::oBar:nMode == 3 ),;
                 nWidth - ::oBar:nBtnWidth, nWidth )
   nHeight = If( ::oBar != nil .and. ::oBar:nMode == 1,;
                 nHeight - ::oBar:nBtnHeight, nHeight ) - ;
                 If( ::oMsgBar != nil, 26, 0 )

   Super:ReSize( nSizeType, nWidth, nHeight )

   if ::oWndClient != nil
      ::oWndClient:Move( nTop, nLeft, nWidth, nHeight, .t. )
   endif

return 0

//----------------------------------------------------------------------------//

METHOD Command( nWParam, nLParam ) CLASS TMdiFrame

   local oWnd := ::oWndClient:GetActive()

   do case
      case nWParam < 100   // MdiChild Menu Selection
           return nil

      otherwise
         Super:Command( nWParam, nLParam )
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD End() CLASS TMdiFrame

   if ::bValid != nil
      if ! Eval( ::bValid )
         return .f.
      endif
   endif

   if ::oWndClient:lCloseAll()
      ::PostMsg( WM_CLOSE )
   else
      return .f.
   endif

return .t.

//----------------------------------------------------------------------------//

METHOD SetMenu( oMenu, nMenuInfo ) CLASS TMdiFrame

  DEFAULT nMenuInfo := Len( oMenu:aItems )

  ::nMenuInfo = nMenuInfo

  if ::oMenuStart == nil
     ::oMenuStart = oMenu
     Super:SetMenu( oMenu )
  else
     ::oMenu = oMenu
     ::oWndClient:SetMenu( oMenu, nMenuInfo )
  endif

return nil

//----------------------------------------------------------------------------//

function GetWndFrame() ; return oWndMain      // Default Frame Window

//----------------------------------------------------------------------------//
