#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Indexes( cAlias )

  local oWndIdx, oBar, oBrw, oIco, oFont, oCbx
  local nOrder   := 1
  local hBmpThis := LoadBitmap( GetResources(), "This" )

  DEFAULT cAlias := Alias()

  DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

  DEFINE ICON oIco RESOURCE "Indexes"

  DEFINE WINDOW oWndIdx FROM 2, 1 TO 22, 78 ;
     TITLE "Indexes: " + cAlias ICON oIco MDICHILD

  DEFINE BUTTONBAR oBar OF oWndIdx

  DEFINE BUTTON RESOURCE "SelFile" OF oBar ;
     MESSAGE "Open an index" ACTION IdxBuilder()

  DEFINE BUTTON RESOURCE "Exit" OF oBar ;
     MESSAGE "Close an index"

  @ 6, 127 SAY "WorkAreas:" PIXEL SIZE 120, 20 OF oBar ;
     FONT oFont COLOR "W+/N*"

  @ 3, 200 COMBOBOX oCbx VAR cAlias ITEMS aGetWorkAreas() ;
     SIZE 100, 120 PIXEL OF oBar ;
     COLOR "N/W" FONT oFont ;
     ON CHANGE ( oWndIdx:cTitle := "Indexes: " + cAlias,;
                 oBrw:Refresh(), oBrw:SetFocus() )

  oCbx:Set3DLook()

  @ 0, 0 LISTBOX oBrw FIELDS "" ;
     FIELDSIZES 25, 90, 250, 180, 140 ;
     HEADERS "Ord", "Index Name", "Index Key", "Index For Scope", "BagName" ;
     OF oWndIdx FONT oFont ;
     ON DBLCLICK ( ( cAlias )->( DbSetOrder( nOrder ) ), oBrw:DrawSelect() ) ;
     SIZE 500, 500

  oBrw:bLine = { || If( Select( cAlias ) != 0,;
                   { If( ( cAlias )->( IndexOrd() ) == nOrder,;
                         hBmpThis, xPadL( cValToChar( nOrder ), 20 ) ),;
                     ( cAlias )->( OrdName( nOrder ) ),;
                     ( cAlias )->( OrdKey(  nOrder ) ),;
                     ( cAlias )->( OrdFor(  nOrder ) ),;
                     ( cAlias )->( OrdBagName( nOrder ) ) },;
                   { "", "", "", "", "" } ) }
  oBrw:bGoTop    = { || nOrder :=  1 }
  oBrw:bGoBottom = { || nOrder := 15 }
  oBrw:bLogicLen = { || 15 }
  oBrw:bSkip     = { | nSkip, nDo | nDo := nOrder, nOrder += nSkip,;
                       nOrder := Max( 1, Min( nOrder, 15 ) ),;
                       nOrder - nDo }

  oWndIdx:SetControl( oBrw )

  ACTIVATE WINDOW oWndIdx ;
     VALID ( DeleteObject( hBmpThis ), .t. )

return nil

//----------------------------------------------------------------------------//
