#include "FiveWin.ch"

#define ID_NAME     110
#define ID_FIND     120
#define ID_EXPR     130
#define ID_BUILD    140
#define ID_WORKAREA 150
#define ID_METER    160
#define ID_START    180

#define ID_EXPTYPE  240
#define ID_LSTEXPR  250

#define TAB      Chr(9)

//----------------------------------------------------------------------------//

function IdxBuilder()

   local oDlg, oIndex, oExpr
   local cIndex  := PadR( "*.ntx", 50 )
   local cExpr   := Space( 100 )
   local cArea   := Alias()
   local nPos, oMeter

   DEFINE DIALOG oDlg RESOURCE "IdxBuilder"

   REDEFINE GET oIndex VAR cIndex ID ID_NAME OF oDlg

   REDEFINE GET oExpr  VAR cExpr  ID ID_EXPR OF oDlg

   REDEFINE BUTTON ID ID_FIND OF oDlg ;
      ACTION ( cIndex := PadR( cGetFile( "*.ntx",;
               "Select Index file" ), 50 ),;
               If( ! Empty( cIndex ) .and. File( cIndex ),;
               oExpr:VarPut( cNtxKey( cIndex ) ),),;
               oExpr:Refresh(), oIndex:Refresh() )

   REDEFINE BUTTON ID ID_BUILD OF oDlg ;
      ACTION ( cExpr := cGetExpression( cExpr ), oExpr:Refresh() )

   REDEFINE COMBOBOX cArea ITEMS aGetWorkAreas() ID ID_WORKAREA OF oDlg

   REDEFINE METER oMeter VAR nPos ID ID_METER OF oDlg ;
      PROMPT "This is a meter" ;
      COLORS CLR_HGRAY, CLR_GRAY ;
      BARCOLOR CLR_HBLUE, CLR_YELLOW

   REDEFINE BUTTON ID ID_START OF oDlg ;
      ACTION If( ! Empty( cArea ) .and. ! Empty( cExpr ),;
                 ( cArea )->( BuildIndex( cIndex, cExpr, oMeter ) ),)

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

static function ExprSelect( cType, aSymbols )

   local oDlg
   local cExpr := ""

   DEFINE DIALOG oDlg RESOURCE "Functions"

   REDEFINE SAY PROMPT cType ID ID_EXPTYPE OF oDlg

   REDEFINE LISTBOX cExpr ITEMS aSymbols ID ID_LSTEXPR OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

static function BuildIndex( cFile, cExpr, oMeter )

   local bExpr  := &( "{||" + cExpr + "}" )
   local bIndex := { || oMeter:VarPut( RecNo() ),;
                        oMeter:Refresh( .f. ), SysRefresh(), Eval( bExpr ) }

   oMeter:nTotal = RecCount()

   DbCreateIndex( cFile, cExpr, bIndex, If( .f., .t.,) )

   MsgInfo( "Index successfully created" )

return nil

//----------------------------------------------------------------------------//
