#include "FiveWin.ch"
#include "Constant.ch"

//----------------------------------------------------------------------------//

CLASS TGroup FROM TControl

   METHOD New( nTop, nLeft, nBottom, nRight, cLabel, oWnd, nClrText,;
               nClrPane, lPixel ) CONSTRUCTOR

   METHOD ReDefine( nId, cLabel, oWnd, nClrText, nClrPane ) CONSTRUCTOR

   METHOD cToChar() INLINE  Super:cToChar( "BUTTON" )

   METHOD Init( hDlg )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cLabel, oWnd, nClrText, nClrPane,;
            lPixel ) CLASS TGroup

   DEFAULT nClrText := oWnd:nClrText, nClrPane := oWnd:nClrPane, lPixel := .f.

   ::nTop     = nTop    * If( lPixel, 1, GRP_CHARPIX_H ) // 14
   ::nLeft    = nLeft   * If( lPixel, 1, GRP_CHARPIX_W ) //  7
   ::nBottom  = nBottom * If( lPixel, 1, GRP_CHARPIX_H ) // 14
   ::nRight   = nRight  * If( lPixel, 1, GRP_CHARPIX_W ) //  7
   ::cCaption = cLabel
   ::oWnd     = oWnd
   ::nStyle   = nOR( WS_CHILD, WS_VISIBLE, BS_GROUPBOX )
   ::nId      = ::GetNewId()
   ::lUpdate  = .f.

   ::SetColor( nClrText, nClrPane )

   if ! Empty( oWnd:hWnd )
      ::Create( "BUTTON" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, cLabel, oWnd, nClrText, nClrPane ) CLASS TGroup

   DEFAULT nId      := ::GetNewId(),;
           nClrText := oWnd:nClrText, nClrPane := oWnd:nClrPane

   ::nId      = nId
   ::cCaption = cLabel
   ::hWnd     = 0
   ::oWnd     = oWnd
   ::lUpdate  = .f.

   ::SetColor( nClrText, nClrPane )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TGroup

   Super:Init( hDlg )

   if Empty( ::cCaption )
      ::cCaption = GetWindowText( ::hWnd )
   endif

return nil

//----------------------------------------------------------------------------//
