// This sample shows how to create a simple Database Management.

#include "FiveWin.ch"
#include "c:\clipper5\include\InKey.ch"

static oWnd, oBmp

//----------------------------------------------------------------------------//

function Main()

   local oBrush, oBar

   SET RESOURCES TO "BORDLGS.DLL", "BWCC.DLL"

   SET 3DLOOK ON

   // don't use VK_F5 because VK_F5 and 't' have the same code !
   // for VK_F5 use Clipper's K_F5
   SetKey( K_F5, { || MsgInfo( "Testing SetKey feature..." ) } )

   DEFINE BRUSH oBrush STYLE BORLAND

   DEFINE WINDOW oWnd FROM 1, 5 TO 20, 75 ;
      TITLE "Using Dialogs from DLLs and Borland's Dialog Boxes!" ;
      BRUSH oBrush ;
      MENU  BuildMenu()

   DEFINE BUTTONBAR oBar OF oWnd

   DEFINE BUTTON FILE "..\bitmaps\Select.bmp" OF oBar ACTION TestSelect() ;
      MESSAGE "Testing a sample selection dialog"

   DEFINE BUTTON FILE "..\bitmaps\Edit.bmp"   OF oBar ;
      ACTION ( TestClient(), oBmp:SetFore() ) ;
      MESSAGE "Testing a typical bussiness dialog"

   DEFINE BUTTON FILE "..\bitmaps\Browse.bmp"   OF oBar ;
      ACTION TestBrowse() MESSAGE "Easy and powerfull Browsers"

   DEFINE BUTTON FILE "..\bitmaps\Exit.bmp"   OF oBar ;
      ACTION Exit() MESSAGE "When you want to end"    // UDF

   DEFINE BUTTON FILE "..\bitmaps\Colors.bmp" OF oBar ACTION ChooseColor() GROUP ;
      MESSAGE "Calling Windows standard color selection dialog"

   DEFINE BUTTON FILE "..\bitmaps\Dlg.bmp"    OF oBar ;
      ACTION cGetFile( "*.dbf", "Select a DBF" ) ;
      MESSAGE "Calling Windows standard Get a File dialog"

   DEFINE BUTTON FILE "..\bitmaps\Fonts.bmp"  OF oBar ACTION ChooseFont() ;
      MESSAGE "Calling Windows standard font selection dialog"

   DEFINE BUTTON FILE "..\bitmaps\Blocks.bmp" OF oBar ACTION About() GROUP ;
      MESSAGE "About FiveWin designers"

   DEFINE BUTTON FILE "..\bitmaps\Printer.bmp" OF oBar ;
      ACTION WinHelp( "Order.hlp" ) MESSAGE "Please read this info"

   @ 6, 18 BITMAP oBmp FILENAME "..\bitmaps\Luck.bmp" OF oWnd

   SET MESSAGE OF oWnd ;
      TO "FiveWin - Storing Dialogs inside DLLs - pure Data-Driven power!" ;
      CENTERED

   ACTIVATE WINDOW oWnd MAXIMIZED

return nil

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "Some &Dialogs"
      MENU
         MENUITEM "Make a selection..." ;
            MESSAGE "It's time to start building Windows applications easily!" ;
            ACTION TestSelect()

         MENUITEM "Now you have a real chance..." ;
            MESSAGE "Quick and easy Windows applications using your Clipper!!!" ;
            ACTION ( TestClient(), oBmp:SetFore() )

         SEPARATOR

         MENUITEM "End..." MESSAGE "Exit this demo" ACTION Exit()     // UDF
      ENDMENU

      MENUITEM "Some &Standards..."
      MENU
         MENUITEM "Choose A &Color..." ;
            MESSAGE "Calling standard Windows dialogs" ACTION ChooseColor()

         MENUITEM "Getting a &file..." ;
            MESSAGE "Hey, see how easy this is" ;
            ACTION cGetFile( "*.dbf", "Select a DBF" )

         MENUITEM "Selecting a f&ont..." ;
            MESSAGE "Any Windows facility is ready for you" ;
            ACTION ChooseFont()
      ENDMENU

      MENUITEM "About..." ;
         MESSAGE "Come on... we would like to see your name here soon!" ;
         ACTION About()

   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function TestSelect()

   local oDlg, oBtnOk
   local cItem  := "Using a Dialog"
   local aItems := { "Using a Dialog",;
                     "stored inside a DLL",;
                     "is extremely easy!", "",;
                     "You can start using",;
                     "Borland's Resource WorkShop",;
                     "to 'draw' your screens!", "",;
                     "Welcome to the power of",;
                     "Clipper, Windows, xBase and OOPS!", "",;
                     "As we promised you:",;
                     "You don't have to know a word",;
                     "of Windows to build",;
                     "incredible Windows applications...",;
                     "You are an xBase Programmer!!!" }


   DEFINE DIALOG oDlg RESOURCE "Select" COLOR "W+/R"

   // Not necessary now
   // REDEFINE SAY ID 10 OF oDlg

   REDEFINE LISTBOX cItem ITEMS aItems ID 110 OF oDlg

   REDEFINE BUTTON oBtnOk ID 1 OF oDlg ;
      ACTION MsgInfo( "You selected..." + cItem )

   REDEFINE BUTTON ID 2 OF oDlg ACTION oDlg:End()

   REDEFINE BUTTON ID 140 OF oDlg ;
      ACTION ( MsgInfo( "You can execute any action from here...", "Info" ),;
               oDlg:Circle( 100, 260, 30 ) )

   ACTIVATE DIALOG oDlg CENTERED NOWAIT

return nil

//----------------------------------------------------------------------------//

function TestClient()

   local oDlg,  oRecNo,  oPhoto, oExit
   local oName, oAdress, oCountry, oActive, oNotes
   local cName, cAdress, cCountry, cNotes, cPhoto
   local aCountries := { "SPAIN", "USA", "CANADA", "GERMANY", "JAPAN", "..." }
   local lActive

   USE Clients SHARED     // Testing Windows for WorkGroups

   cName    := Clients->Name
   cAdress  := Clients->Adress
   cCountry := Clients->Country
   lActive  := Clients->Active
   cNotes   := StrTran( Clients->Notes, Chr( 141 ) + Chr( 10 ), "" )
   cPhoto   := Clients->Photo

   DEFINE DIALOG oDlg RESOURCE "Client"

   REDEFINE SAY oRecNo PROMPT Str( RecNo(), 5 ) ;  // Here we trap a reference
      ID 60 OF oDlg                                // to the SAY Object

   REDEFINE GET oName VAR cName ID 110 OF oDlg ; // PICTURE "@!A" ;
      COLOR "W+*/B" ON CHANGE ( MsgBeep(), .t. )

   REDEFINE GET oAdress VAR cAdress COLOR "GR+/RB" ID 120 OF oDlg

   REDEFINE COMBOBOX oCountry VAR cCountry ITEMS aCountries ;
      ID 130 OF oDlg

   REDEFINE CHECKBOX oActive  VAR lActive ID 140 OF oDlg

   REDEFINE GET oNotes VAR cNotes MEMO ID 150 OF oDlg ;
      COLOR "w+/g"    // READONLY

   REDEFINE BITMAP oPhoto FILENAME cPhoto ID 230 OF oDlg

   REDEFINE SCROLLBAR ID 220 OF oDlg RANGE 1, RecCount() ;
      ON DOWN ( DbSkip(),;
                If( EoF(), DbGoBottom(),),;
                oPhoto:LoadBMP( Clients->Photo ),;
                cName    := Clients->Name,    oName:Refresh(),;
                cAdress  := Clients->Adress,  oAdress:Refresh(),;
                cCountry := Clients->Country, oCountry:Refresh(),;
                lActive  := Clients->Active,  oActive:Refresh(),;
                cNotes   := StrTran( Clients->Notes, Chr( 141 ) + Chr( 10 ), "" ),;
                            oNotes:Refresh(),;
                oRecNo:SetText( Str( RecNo(), 5 ) ) ) ;
      ON UP   ( DbSkip( -1 ),;
                oPhoto:LoadBMP( Clients->Photo ),;
                cName    := Clients->Name,    oName:Refresh(),;
                cAdress  := Clients->Adress,  oAdress:Refresh(),;
                cCountry := Clients->Country, oCountry:Refresh(),;
                lActive  := Clients->Active,  oActive:Refresh(),;
                cNotes   := StrTran( Clients->Notes, Chr( 141 ) + Chr( 10 ), "" ),;
                           oNotes:Refresh(),;
                oRecNo:SetText( Str( RecNo(), 5 ) ) )

   REDEFINE BUTTON ID 170 OF oDlg ;
      ACTION ( oPhoto:Save( "Test.bmp" ), MsgInfo( "Look at Test.bmp on disk" ) )

   REDEFINE BUTTON ID 180 OF oDlg ;
      ACTION ( oDlg:Copy( .t. ),;
               MsgInfo( "A copy of this Dialog have been placed at the Clipboard!" ) )

   REDEFINE BUTTON ID 190 OF oDlg ;
      ACTION oDlg:HardCopy( 2 )

   REDEFINE BUTTON ID 200 OF oDlg ACTION ;
      BrowseClients( @cName, @cAdress, @cCountry, @lActive, @cNotes,;
              oPhoto, oName, oAdress, oCountry, oActive, oNotes, oRecNo )

   REDEFINE BUTTON ID 210 OF oDlg ACTION oDlg:HardCopy( 2 )  // nScale factor

   REDEFINE BUTTON oExit ID 240 OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED
      // ON INIT MsgInfo( "Init Dialog clause testing" )

   USE

return nil

//----------------------------------------------------------------------------//

function BrowseClients( cName, cAdress, cCountry, lActive, cNotes,;
                 oPhoto, oName, oAdress, oCountry, oActive, oNotes, oRecNo )

   local oDlg
   local nOldRecNo := RecNo()

   DEFINE DIALOG oDlg RESOURCE "Clients"

   REDEFINE LISTBOX FIELDS ID 110 OF oDlg

   ACTIVATE DIALOG oDlg

   if oDlg:nResult == 1           // ID_OK
      cName    = Clients->Name
      cAdress  = Clients->Adress
      cCountry = Clients->Country
      lActive  = Clients->Active
      cNotes   = Clients->Notes

      oPhoto:LoadBmp( Clients->Photo )
      oName:Refresh()
      oAdress:Refresh()
      oCountry:Refresh()
      oActive:Refresh()
      oNotes:Refresh()
      oRecNo:SetText( Str( RecNo(), 5 ) )
   else
      GOTO nOldRecNo
   endif

return nil

//----------------------------------------------------------------------------//

function About()

   local oDlg

   ShellAbout( FWVERSION, FWCOPYRIGHT, 0 )

   DEFINE DIALOG oDlg RESOURCE "About"

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function Exit()

   local oDlg
   local lEnd := .f.

   DEFINE DIALOG oDlg RESOURCE "Exit"

   REDEFINE BITMAP ID 110 OF oDlg RESOURCE "Question"

   REDEFINE BUTTON ID 6 OF oDlg ACTION ( lEnd := .t., oDlg:End() )
   REDEFINE BUTTON ID 7 OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

   if lEnd
      oWnd:End()
   endif

return nil

//----------------------------------------------------------------------------//

function Stop()

   local oDlg

   DEFINE DIALOG oDlg RESOURCE "Stop"

   REDEFINE SAY PROMPT "Only available in commercial version" ID 10 OF oDlg
   REDEFINE BITMAP ID 110 OF oDlg RESOURCE "Hand"

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function TestBrowse()

   local oDlg

   USE Dialog

   DEFINE DIALOG oDlg RESOURCE "Clients"

   REDEFINE LISTBOX FIELDS ID 110 OF oDlg

   REDEFINE BUTTON ID 998 OF oDlg ;
      ACTION MsgInfo( "Hey man! This is really powerfull" )

   ACTIVATE DIALOG oDlg CENTERED

   USE

return nil

//----------------------------------------------------------------------------//
