#include "FiveWin.ch"

#define COLOR_WINDOW         5
#define COLOR_WINDOWTEXT     8

#define FD_BORDER            8
#define FD_HEIGHT           22

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TFolder FROM TControl

   DATA   aPrompts, aActions, aSizes
   DATA   nOption

   METHOD New() CONSTRUCTOR
   METHOD ReDefine( nId, aPrompts, aActions, oWnd, nOption, nClrFore, nClrBack ) CONSTRUCTOR
   METHOD Display() INLINE ::BeginPaint(), ::Paint(), ::EndPaint()
   METHOD Paint()
   METHOD Init( hDlg )
   METHOD LButtonDown( nRow, nCol, nFlags )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New() CLASS TFolder

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, aPrompts, aActions, oWnd, nOption, ;
                 nClrFore, nClrBack ) CLASS TFolder

   DEFAULT nOption  := 1,;
           nClrFore := oWnd:nClrText,;
           nClrBack := oWnd:nClrPane,;
           aActions := Array( Len( aPrompts ) )

   ::nId      = nId
   ::oWnd     = oWnd
   ::aPrompts = aPrompts
   ::aActions = aActions
   ::aSizes   = Array( Len( aPrompts ) )
   ::nOption  = nOption

   if ! lRegistered
      ::Register()
      lRegistered = .t.
   endif

   ::SetColor( nClrFore, nClrBack )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TFolder

   local nHeight  := ::nBottom - ::nTop
   local hDC      := ::GetDC()
   local nLeft    := 0, n
   local hDarkPen := CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) )

   SetBlackPen( hDC )
   MoveTo( hDC, 0, nHeight )
   LineTo( hDC, 0, 3 )
   SetWhitePen( hDC )
   MoveTo( hDC, 1, nHeight - 1 )
   LineTo( hDC, 1, 4 )

   for n = 1 to Len( ::aPrompts )
      SetBlackPen( hDC )
      MoveTo( hDC, nLeft, FD_HEIGHT - 1 )
      LineTo( hDC, nLeft, 3 )
      LineTo( hDC, nLeft + 3, 0 )
      LineTo( hDC, nLeft + ::aSizes[ n ] - 2, 0 )
      LineTo( hDC, nLeft + ::aSizes[ n ] + 1, 3 )
      LineTo( hDC, nLeft + ::aSizes[ n ] + 1, FD_HEIGHT )
      SetWhitePen( hDC )
      MoveTo( hDC, nLeft + 1, FD_HEIGHT - 1 )
      LineTo( hDC, nLeft + 1, 3 )
      LineTo( hDC, nLeft + 3, 1 )
      LineTo( hDC, nLeft + ::aSizes[ n ] - 2, 1 )
      SelectObject( hDC, hDarkPen )
      LineTo( hDC, nLeft + ::aSizes[ n ], 3 )
      LineTo( hDC, nLeft + ::aSizes[ n ], FD_HEIGHT - 1 )
      SetBlackPen( hDC )
      SetBkColor( hDC, ::nClrPane )
      TextOut( hDC, 4, nLeft + FD_BORDER, ::aPrompts[ n ] )
      if n != ::nOption
         MoveTo( hDC, nLeft, FD_HEIGHT - 1 )
         LineTo( hDC, nLeft + ::aSizes[ n ], FD_HEIGHT - 1 )
      endif
      nLeft += ::aSizes[ n ] + 1
   next

   ::ReleaseDC()
   DeleteObject( hDarkPen )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TFolder

   Super:Init( hDlg )

   AEval( ::aPrompts,;
          { | cPrompt, n | ::aSizes[ n ] := ;
            GetTextWidth( ::hDC, cPrompt ) + FD_BORDER + FD_BORDER } )

return nil

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol, nFlags ) CLASS TFolder

   local n, nPos := 0

   if nRow <= FD_HEIGHT
      for n = 1 to Len( ::aSizes )
         if nCol < nPos + ::aSizes[ n ] .and. n != ::nOption
            ::nOption = n
            ::Refresh()
            if n <= Len( ::aActions ) .and. ::aActions[ n ] != nil
               Eval( ::aActions[ n ] )
            endif
            exit
         endif
         nPos += ::aSizes[ n ]
      next
   endif

return nil

//----------------------------------------------------------------------------//
