// (c) FiveWin - Documentation Tools

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function DocNew()

   local cDocName := cGetNewFileName( "docs\doc", "doc" )

   DbCreate( cDocName, { { "PAGE",     "N",  3, 0 },;
                         { "ITEM",     "N",  4, 0 },;
                         { "DESCRIPT", "C", 50, 0 },;
                         { "NOTES",    "M", 10, 0 },;
                         { "TITLE",    "C", 50, 0 },;
                         { "KEYWORD",  "C", 50, 0 },;
                         { "TOPIC",    "C", 50, 0 },;
                         { "JUMPTO",   "N",  3, 0 },;
                         { "POPUP",    "L",  1, 0 },;
                         { "BITMAP",   "C", 50, 0 } } )
   DocOpen( cDocName )

return nil

//----------------------------------------------------------------------------//

function DocOpen( cDocName )

   local oWndDoc, oBar, oBrw, oIco
   local oWnd := GetWndMain(), oWndAreas := GetWndAreas()
   local cAlias, nPage := 1

   field Page, Item, Descript, Notes

   DEFAULT cDocName := cGetFile( "FiveWin Documentation (*.doc) | docs\*.doc",;
                                 "Select a Documentation file" )

   if ! Empty( cDocName )

      USE ( cDocName ) NEW SHARED

      if RecCount() == 0
         APPEND BLANK
         Page     := 1
         Item     := 1
         Descript := "New item"
      endif

      INDEX ON StrZero( Page, 3 ) + StrZero( Item, 4 ) ;
         TO ( cNoExt( cDocName ) )
      SET INDEX TO ( cNoExt( cDocName ) )
      GO TOP

      cAlias = Alias()

      DEFINE ICON oIco RESOURCE "Doc"

      DEFINE WINDOW oWndDoc FROM 1, 1 TO 23, 33 ;
         TITLE "Documentation: " + cNoExt( cNoPath( cDocName ) ) ;
         ICON  oIco MDICHILD OF oWnd

      DEFINE BUTTONBAR oBar OF oWndDoc

      DEFINE BUTTON RESOURCE "New" OF oBar ;
         MESSAGE "Add a new page" ;
         ACTION nPage := nPageNew( oBrw, nPage )

      DEFINE BUTTON RESOURCE "NewItem" OF oBar ;
         MESSAGE "Add a new item" ;
         ACTION ItemNew( oBrw, nPage )

      DEFINE BUTTON RESOURCE "Edit" OF oBar ;
         MESSAGE "Edit this item page" ;
         ACTION  ItemEdit( oBrw )

      DEFINE BUTTON RESOURCE "PrevPage" OF oBar ;
         MESSAGE "Go previous page" ACTION nPage := nPagePrev( oBrw, nPage )

      DEFINE BUTTON RESOURCE "NextPage" OF oBar ;
         MESSAGE "Go next page" ACTION nPage := nPageNext( oBrw, nPage )

      DEFINE BUTTON RESOURCE "NG" GROUP OF oBar ;
         MESSAGE "Create Norton Guide documentation"

      DEFINE BUTTON RESOURCE "HLP" OF oBar ;
         MESSAGE "Create Windows Help documentation" ;
         ACTION GenRTF( oBrw, cNoExt( cDocName ) )

      DEFINE BUTTON RESOURCE "Exec" OF oBar ;
         MESSAGE "Test documentation" ;
         ACTION If( File( cNoPath( cNoExt( cDocName ) ) + ".hlp" ),;
                WinHelp( cNoPath( cNoExt( cDocName ) ) + ".hlp" ),)

      @ 0, 0 LISTBOX oBrw FIELDS Str( ( Alias() )->Page, 3 ),;
                                 xPadL( Str( ( Alias() )->Item, 4 ), 25 ),;
                                 ( Alias() )->Descript ;
                          FIELDSIZES 30, 35, 300 ;
                          HEADERS "Pag", "Item", "Description" ;
         OF oWndDoc ;
         ON CHANGE If( oWndAreas != nil, oWndAreas:oControl:Refresh(),) ;
         ON DBLCLICK ItemEdit( oBrw ) ;
         SELECT StrZero( Page, 3 ) + StrZero(  1, 4 ) ;
         FOR StrZero( nPage, 3 ) + StrZero(    1, 4 ) ;
         TO  StrZero( nPage, 3 ) + StrZero( 9999, 4 ) ;
         SIZE 400, 400
         // Indexed filter !!!

      oWndDoc:SetControl( oBrw )

      ACTIVATE WINDOW oWndDoc ;
         VALID oBrw:lCloseArea()

      if oWndAreas != nil
         oWndAreas:oControl:Refresh()  // We updates the info on the WorkAreas
      endif                            // Inspector

   endif

return nil

//----------------------------------------------------------------------------//

static function ItemNew( oBrw, nPage )

   local nItem

   oBrw:GoBottom()
   nItem = ( oBrw:cAlias )->Item

   ( oBrw:cAlias )->( DbAppend() )

   if ( oBrw:cAlias )->( RLock() )
      ( oBrw:cAlias )->Page = nPage
      ( oBrw:cAlias )->Item = nItem + 1
      ( oBrw:cAlias )->Descript = "New Item"
      UNLOCK
      oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                      StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                      StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
      oBrw:GoTop()
      oBrw:Refresh()
   else
      MsgAlert( "DataBase in use, please try again" )
   endif

return nil

//----------------------------------------------------------------------------//

static function nPageNew( oBrw, nPage )

   nPage++

   ( oBrw:cAlias )->( DbAppend() )

   if ( oBrw:cAlias )->( RLock() )
      ( oBrw:cAlias )->Page = nPage
      ( oBrw:cAlias )->Item = 1
      ( oBrw:cAlias )->Descript = "New Item"
      UNLOCK
      oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                      StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                      StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
      oBrw:GoTop()
      oBrw:Refresh()
   else
      MsgAlert( "DataBase in use, please try again" )
   endif

return nPage

//----------------------------------------------------------------------------//

static function nPagePrev( oBrw, nPage )

   if nPage > 1
      nPage--
      oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                      StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                      StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
      oBrw:GoTop()
      oBrw:Refresh()
   endif

return nPage

//----------------------------------------------------------------------------//

static function nPageNext( oBrw, nPage )

   local nRecNo := RecNo()

   GO BOTTOM
   if ! ( oBrw:cAlias )->Page >= nPage + 1
      GO nRecNo
      return nPage
   endif
   GO nRecNo

   nPage++
   oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                   StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                   StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
   oBrw:GoTop()
   oBrw:Refresh()

return nPage

//----------------------------------------------------------------------------//

static function ItemEdit( oBrw )

   local oDlg, oBmp
   local cAlias    := oBrw:cAlias
   local nPage     := ( cAlias )->Page
   local nItem     := ( cAlias )->Item
   local cDescript := ( cAlias )->Descript
   local nJumpTo   := ( cAlias )->JumpTo
   local lPopup    := ( cAlias )->Popup
   local cBitmap   := ( cAlias )->Bitmap
   local cNotes    := ( cAlias )->Notes

   DEFINE DIALOG oDlg RESOURCE "DocItem"

   REDEFINE GET nPage ID 110 OF oDlg

   REDEFINE GET nItem ID 120 OF oDlg

   REDEFINE GET nJumpTo ID 130 OF oDlg

   REDEFINE GET cDescript ID 150 OF oDlg

   REDEFINE GET oBmp VAR cBitmap ID 180 OF oDlg

   REDEFINE BUTTON ID 190 OF oDlg ;
      ACTION ( cBitmap := cGetFile( "Windows Bitmap (*.bmp) |" + cBitmap,;
               "Select a bitmap" ), oBmp:Refresh() )

   REDEFINE CHECKBOX lPopup ID 210 OF oDlg

   REDEFINE GET cNotes MULTILINE ID 200 OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

   if oDlg:nResult == IDOK
      if ( cAlias )->( RLock() )
         ( cAlias )->Page     := nPage
         ( cAlias )->Item     := nItem
         ( cAlias )->JumpTo   := nJumpTo
         ( cAlias )->Descript := cDescript
         ( cAlias )->Bitmap   := cBitmap
         ( cAlias )->Popup    := lPopup
         ( cAlias )->Notes    := cNotes
         ( cAlias )->( DbUnLock() )
         oBrw:Refresh()
      endif
   endif

   oBrw:SetFocus()

return nil

//----------------------------------------------------------------------------//

static function GenRTF( oBrw, cDocName )

   local cAlias    := oBrw:cAlias
   local nRecNo    := ( cAlias )->( RecNo() )
   local nPage     := 1
   local oRTF

   oRTF = TRtfFile():New( cDocName + ".rtf" )

   ( cAlias )->( DbGoTop() )

   oRTF:WriteId( StrZero( ( cAlias )->Page, 4 ) + ;
                 StrZero( ( cAlias )->Item, 4 ) )

   while ! ( cAlias )->( EoF() )
      if ( cAlias )->Page != nPage
         nPage = ( cAlias )->Page
         oRTF:NewPage()
         oRTF:WriteId( StrZero( ( cAlias )->Page, 4 ) + ;
                       StrZero( ( cAlias )->Item, 4 ) )
      endif
      oRtf:WriteShort( ( cAlias )->Descript,;
                       If( ! Empty( ( cAlias )->Notes ),;
                       StrZero( ( cAlias )->Page, 4 ) + ;
                       StrZero( ( cAlias )->Item, 4 ) + "L",;
                       If( ! Empty( ( cAlias )->JumpTo ),;
                       StrZero( ( cAlias )->JumpTo, 4 ) + "0001", "" ) ),;
                       ( cAlias )->Popup, ( cAlias )->Bitmap )
      ( cAlias )->( DbSkip() )
   end

   ( cAlias )->( DbGoTop() )

   while ! ( cAlias )->( EoF() )
      if ( cAlias )->Page != nPage
         nPage = ( cAlias )->Page
         oRTF:NewPage()
      endif
      if ! Empty( ( cAlias )->Notes )
         oRtf:WriteId( StrZero( ( cAlias )->Page, 4 ) + ;
                       StrZero( ( cAlias )->Item, 4 ) + "L" )
         oRtf:WriteLong( ( cAlias )->Notes )
         oRTF:NewPage()
      endif
      ( cAlias )->( DbSkip() )
   end

   ( cAlias )->( DbGoTo( nRecNo ) )
   oRtf:End()

   MsgInfo( "RTF file " + cDocName + ".rtf successfully generated!" )
   WinExec( "pifs\hc.pif " + cDocName + ".hpj" )

   oBrw:SetFocus()

return nil

//----------------------------------------------------------------------------//
