// A DBF DataBase builder written with FiveWin

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()

   local oDlg, oGet, oType, oLen, oDec, oLbx, oBtnAdd, oBtnEdit
   local cName    := Space( 10 )
   local cType    := "C"
   local nLen     := 10
   local nDec     :=  0
   local cField   := Space( 20 )
   local cTypes   := "CNLDM"
   local aLens    := { 10, 10, 1, 8, 8 }
   local cDbfName := Space( 12 )
   local lEditing := .f.

   SET 3DLOOK ON

   DEFINE DIALOG oDlg RESOURCE "DbfBuild" TITLE "FiveWin - DbfBuilder"

   REDEFINE GET oGet VAR cName ID 110 OF oDlg

   REDEFINE COMBOBOX oType VAR cType  ITEMS { "C", "N", "L", "D", "M" } ;
      ON CHANGE ( nLen := aLens[ At( cType, cTypes ) ], oLen:Refresh() );
      ID 120 OF oDlg

   REDEFINE GET oLen VAR nLen PICTURE "9999" ID 130 OF oDlg

   REDEFINE GET oDec VAR nDec PICTURE "9"    ID 140 OF oDlg

   REDEFINE BUTTON oBtnAdd ID 150 OF oDlg ;
      ACTION AddField( oLbx, oGet, oBtnAdd, oBtnEdit,;
                       @cName, cType, nLen, nDec, @lEditing )

   REDEFINE BUTTON ID 160 OF oDlg ACTION oDlg:End()

   REDEFINE LISTBOX oLbx VAR cField ID 170 OF oDlg

   REDEFINE BUTTON oBtnEdit ID 180 OF oDlg ;
      ACTION EditField( oBtnAdd, oBtnEdit,;
                        cField, @cName, @cType, @nLen, @nDec, @lEditing,;
                        oGet, oType, oLen, oDec )

   REDEFINE BUTTON ID 190 OF oDlg ACTION oLbx:Del()

   REDEFINE GET cDbfName ID 210 OF oDlg

   REDEFINE BUTTON ID 220 OF oDlg ;
      ACTION BuildDbf( cDbfName, oLbx )

   REDEFINE BUTTON ID 230 OF oDlg ;
      ACTION ( WinHelp( "Order.hlp" ), WinExec( "Write.exe FiveWin.doc" ) )

   ACTIVATE DIALOG oDlg CENTERED

   SET 3DLOOK OFF

return nil

//----------------------------------------------------------------------------//

static function AddField( oLbx, oGet, oBtnAdd, oBtnEdit,;
                          cName, cType, nLen, nDec, lEditing )

   if Empty( cName )
      MsgInfo( "I need a field name", "Sorry" )
   else
      if ! lEditing
         oLbx:Add( xPadR( cName, 100 ) + Chr( 9 ) + cType + ;
                   xPadL( Str( nLen, 3 ), 50 ) + xPadL( Str( nDec, 1 ), 20 ),;
                   oLbx:GetPos() )
			else
         oLbx:Modify( xPadR( cName, 100 ) + Chr( 9 ) + cType + ;
                      xPadL( Str( nLen, 3 ), 50 ) + xPadL( Str( nDec, 1 ), 20 ) )
         oBtnAdd:SetText( "&Add" )
         oBtnEdit:Enable()
         lEditing = .f.
      endif
      cName = Space( 10 )
      oGet:Refresh()
      oGet:SetFocus( .t. )
   endif

return nil

//----------------------------------------------------------------------------//

static function BuildDbf( cDbfName, oLbx )

   local aFields := {}
   local n

   if Empty( cDbfName )
      MsgAlert( "I need a DBF name", "Sorry" )
      return nil
   endif

   if Len( oLbx:aItems ) == 0
      MsgAlert( "No fields defined", "Sorry" )
      return nil
   endif

   if At( ".", cDbfName ) == 0
      cDbfName += ".dbf"
   endif

   if File( cDbfName )
      if ! MsgYesNo( "Create it again?", "That DBF already exists" )
         return nil
      endif
   endif

   for n = 1 to Len( oLbx:aItems )
      AAdd( aFields, FieldInfo( AllTrim( oLbx:aItems[ n ] ) ) )
   next

   DbCreate( cDbfName, aFields )
   MsgInfo( "DBF created!", "AllRight" )

return nil

//----------------------------------------------------------------------------//

static function FieldInfo( cItem )

return { StrToken( cItem, 1 ),;
         StrToken( cItem, 2 ),;
         Val( StrToken( cItem, 3 ) ),;
         Val( StrToken( cItem, 4 ) ) }

//----------------------------------------------------------------------------//

static function EditField( oBtnAdd, oBtnEdit, cField,;
                           cName, cType, nLen, nDec, lEditing,;
                           oName, oType, oLen, oDec )

   if ! Empty( cField )
      oBtnAdd:SetText( "&Replace" )
      oBtnEdit:Disable()
      lEditing = .t.

      cName = StrToken( cField, 1 )
      cType = StrToken( cField, 2 )
      nLen  = Val( StrToken( cField, 3 ) )
      nDec  = Val( StrToken( cField, 4 ) )

      oName:Refresh()
      oType:Refresh()
      oLen:Refresh()
      oDec:Refresh()
   else
      MsgInfo( "Select a field to edit", "Please" )
   endif

return nil

//----------------------------------------------------------------------------//
