// FiveWin - RC from DBF generator !!! Use it for quickly developing Dialogs

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()

   local oDlg, oGet
   local cDbfName := Space( 40 )
   local cTemp

   SET 3DLOOK ON

   DEFINE DIALOG oDlg RESOURCE "Dbf2RC"

   REDEFINE GET oGet VAR cDbfName ID 110 OF oDlg

   REDEFINE BUTTON ID 120 OF oDlg ;
      ACTION ( cTemp := cGetFile( "*.dbf", "Select a DBF" ),;
      If( ! Empty( cTemp ), ( cDbfName := cTemp, oGet:Refresh() ),))

   REDEFINE BUTTON ID 130 OF oDlg ;
      ACTION ( CursorWait(), GenRC( cDbfName ), CursorArrow() )

   REDEFINE BUTTON ID 140 OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function GenRC( cDbfName )

   local n, nId := 110
   local cRC := "", cCH := ""
   local aFields
   local cRCFile := ""

   if Empty( cDbfName ) .or. ! File( cDbfName )
      MsgAlert( "Please select a DBF file first!" )
      return nil
   endif

   CursorWait()

   USE ( cDbfName )
   aFields = DbStruct()

   cRC += '#include "..\include\WinApi.ch"' + CRLF
   cRC += '#include "' + Alias() + '.ch"' + CRLF + CRLF
   cRC += Alias() + " DIALOG 32, 18, 236," + ;
      Str( ( Len( aFields ) * 14) + 20, 4 ) + CRLF
   cRC += "STYLE DS_MODALFRAME | WS_POPUP | WS_CAPTION | WS_SYSMENU" + CRLF
   cRC += 'CAPTION "' + Alias() + '"' + CRLF
   cRC += 'FONT 8, "Arial"' + CRLF
   cRC += "BEGIN" + CRLF

   for n = 1 to Len( aFields )
      cCH += "#define ID_" + PadR( aFields[ n ][ 1 ], 11 ) + ;
         Str( nId, 4 ) + CRLF

      do case

         case aFields[ n ][ 2 ] $ "CND"
            cRC += '   LTEXT "' + aFields[ n ][ 1 ] + '"' + ;
               Space( 10 - Len( aFields[ n ][ 1 ] ) ) + ", -1, 3," + ;
               Str( 5 + 14 * ( n - 1 ), 4 ) + ", 41, 8" + CRLF

            cRC += "   EDITTEXT ID_" + aFields[ n ][ 1 ] + ;
               ", 45," + Str( 3 + 14 * ( n - 1 ), 4 ) + ", " + ;
               Str( aFields[ n ][ 3 ] * 7, 4 ) + ", 12" + CRLF

         case aFields[ n ][ 2 ] == "L"
            cRC += '   CONTROL "' + aFields[ n ][ 1 ] + ;
               '", ID_' + aFields[ n ][ 1 ] + ;
               ', "BUTTON", BS_AUTOCHECKBOX | WS_CHILD | WS_VISIBLE | WS_TABSTOP, ' + ;
               "45, " + Str( 3 + 14 * ( n - 1 ), 4 ) + ;
               ", 50, 12" + CRLF

         case aFields[ n ][ 2 ] == "M"
            cRC += '   LTEXT "' + aFields[ n ][ 1 ] + '"' + ;
               Space( 10 - Len( aFields[ n ][ 1 ] ) ) + ", -1, 100," + ;
               Str( 5 + 14 * ( n - 1 ), 4 ) + ", 41, 8" + CRLF

            //            cRC += '   CONTROL "' + aFields[ n ][ 1 ] + ;
               cRC += '   CONTROL "' + "" + ;
               '", ID_' + aFields[ n ][ 1 ] + ;
               ', "EDIT", ES_LEFT | ES_MULTILINE | ES_WANTRETURN | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_VSCROLL | WS_TABSTOP , ' + ;
               "145, " + Str( 3 + 14 * ( n - 1 ), 4 ) + ", "  + "77, 63" + CRLF
            //^^^ gotta put out to the right somewhere so you can see it
            //    and not sit under a bunch of other controls
      endcase

      nId += 10

   next

   cRC += "END" + CRLF
   MemoWrit( Alias() + ".ch", cCH )

   cRCFile := alias() + ".rc"

   cursorarrow()

   IF !file(Alias() + ".rc")
      cursorwait()
      MemoWrit( alias() + ".rc", cRC )
   ELSEIF MsgYesno("That Resource Already Exists - Overwrite it?", "OOPS")
      cursorwait()
      MemoWrit( alias() + ".rc", cRC )
   ELSE
      msgstop("Rename the existing " + cRCFile + " and try again")
   ENDIF

   cursorarrow()
   WinExec( "workshop" + " " + cRCFile )

   USE

return nil

//----------------------------------------------------------------------------//
