#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TDataBase FROM TWorkArea

   DATA   cAlias, cFile, cDriver AS Character
   DATA   lShared, lReadOnly     AS Logic
   DATA   bBoF, bEoF             AS CodeBlock

   METHOD New( cAlias, cFile, cDriver, lShared, lReadOnly ) CONSTRUCTOR
   METHOD Skip( nRecords )
   METHOD Activate()
   METHOD Deactivate()        INLINE DbCloseArea(), ::nArea:= 0
   METHOD DbCreate( aStruct ) INLINE DbCreate( ::cFile, aStruct, ::cDriver )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cAlias, cFile, cDriver, lShared, lReadOnly ) CLASS TDataBase

   ::Super:New( Select( cAlias ) )

   BYNAME cAlias    DEFAULT Alias()
   BYNAME cFile     DEFAULT Alias()
   BYNAME cDriver   DEFAULT DbSetDriver()
   BYNAME lShared   DEFAULT .f.
   BYNAME lReadOnly DEFAULT .f.

   ::bBoF = { || MsgInfo( "Beginning of file" ) }
   ::bEoF = { || MsgInfo( "End of file" ) }

return Self

//----------------------------------------------------------------------------//

METHOD Activate() CLASS TDataBase

   local nOldArea:= Select()    

   Select ( ::nArea )
   if !Used()
      DbUseArea( .f., ::cDriver, ::cFile, ::cAlias, ::lShared, ::lReadOnly )
   endif

   Select ( nOldArea )

Return nil

//----------------------------------------------------------------------------//

METHOD Skip( n ) CLASS TDataBase

   Super:Skip( n )

   if ::Eof()
      ::GoBottom()
      if ::bEoF != nil
         Eval( ::bEoF )
      endif
   endif

   if ::BoF()
      ::GoTop()
      if ::bBoF != nil
         Eval( ::bBoF )
      endif
   endif

return nil

//----------------------------------------------------------------------------//
