/*
 * File......:
 * Author....: Adapted by A.L.
 * Date......: $Date:   16 Oct 1994 24:00:00  $
 * Revision..: $Revision:   1.0  $
 * Log file..: $Logfile:   $
 * 
 * Modification history:
 * ---------------------
 *
 *    Rev 1.0   Is is also supported now in FiveWin as MsgAbout()
 *              We recommend to use MsgAbout() instead of ShellAbout()
 *              for compatibility reasons with FiveOS2 and FiveDos.
 */


/*  $DOC$
 *  $FUNCNAME$
 *    ShellAbout()
 *  $CATEGORY$
 *    User Interface
 *  $ONELINER$
 *    Displays the typicall Program Manager About dialog box
 *  $SYNTAX$
 *
 *    ShellAbout( <cMsg>, [<cTitle>] , [<hIcon>] ) --> nil
 *
 *  $ARGUMENTS$
 *
 *    <cMsg>     Is the description text for the About Dialog Box.
 *    <cTitle>   Is the title of the About Dialog Box. By default
 *               it shows "About".
 *    <hIcon>    It is the handle of the icon to show. By default it
 *               uses the first icon included inside the EXE as resource.
 *               It shows the typicall Windows icon if no icon is found.
 *  $RETURNS$
 *
 *    nil
 *
 *  $DESCRIPTION$
 *
 *    This function is also included now inside FiveWin as MsgAbout().
 *    We plan to remove this in next versions and just keep MsgAbout().
 *
 *    ShellAbout() it is an undocumented Windows function, so it is not
 *    sure that it will be supported in the future by Windows, but
 *    actually it is extensively used in Windows 3.1 and 3.11.
 *
 *    It is very usefull because it also shows the availabe memory and
 *    resources.
 *
 *  $EXAMPLES$
 *
 *     local oIco
 *
 *     DEFINE ICON oIco RESOURCE "MyApp"
 *
 *     MsgAbout( "My application", "My name", oIco:hIcon )
 *
 *  $SEEALSO$
 *    MsgAbout() MsgInfo() MsgAlert() MsgYesNo() MsgBeep() MsgGet()
 *  $END$
 */

#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

void pascal ShellAbout( HWND hWnd, LPSTR szText, LPSTR szTitle, HICON hIcon );

//----------------------------------------------------------------------------//

CLIPPER SHELLABOUT()
{
   ShellAbout( GetActiveWindow(), _parc( 1 ), _parc( 2 ), _parni( 3 ) );
}

//----------------------------------------------------------------------------//
