#include "FiveWin.ch"

#define SW_MINIMIZE            6

#define WM_MENUSELECT        287
#define WM_SYSCOMMAND        274    // 0x112
#define WM_LBUTTONDBLCLK     515    // 0x203
#define WM_SETFONT            48    // 0x30
#define WM_QUERYDRAGICON      55    // 0x37
#define WM_CTLCOLOR           25    // 0x19
#define WM_ERASEBKGND         20    // 0x14
#define WM_CHILDACTIVATE      34    // 0x22
#define WM_ICONERASEBKGND     39    // 0x27
#define WM_MEASUREITEM        44    // 0x2C
#define WM_DRAWITEM           43    // 0x2B

#define WS_EX_DLGMODALFRAME    1

#define CBN_SELCHANGE          1

#define IDC_ARROW          32512

#define SIZE_MINIMIZED         1

#define SC_RESTORE         61728
#define SC_CLOSE           61536   // 0xF060
#define SC_MINIMIZE        61472
#define SC_NEXT            61504
#define SC_MAXIMIZE        61488   // 0xF030

#define SW_HIDE                0
#define SW_SHOWNA              8

static aWindows    := {}
static lRegistered := .f.
static oWndDefault                 // Defaulf DEFINEd Window

//----------------------------------------------------------------------------//

function nWindows() ; return Len( aWindows )

//----------------------------------------------------------------------------//

CLASS TWindow

   DATA   hWnd, nOldProc
   DATA   bInit, bMoved, bLClicked, bKeyDown, bPainted, bRClicked
   DATA   bResized, bLDblClick, bWhen, bValid, bKeyChar
   DATA   cCaption, cPS, nPaintCount
   DATA   Cargo                              // Ok here you have it <g>
   DATA   hDC, nId
   DATA   lActive, lVisible, lFocused
   DATA   nStyle, nChrHeight, nChrWidth
   DATA   nTop, nLeft, nBottom, nRight
   DATA   nClrPane, nClrText
   DATA   nResult, lValidating
   DATA   aControls
   DATA   oBar, oBrush, oCursor, oFont, oIcon, oMenu
   DATA   oSysMenu, oPopup, oMsgBar, oWnd, oVScroll, oHScroll

   METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
               oBrush, oIcon, oParent, lVScroll, lHScroll,;
               nClrFore, nClrBack, oCursor,;
               cBorder, lSysMenu, lCaption, lMin, lMax ) CONSTRUCTOR

   METHOD Activate( cShow, bLClicked, bRClicked, bMoved, bResized, bPainted,;
                    bKeyDown, bInit,;
                    bUp, bDown, bPgUp, bPgDn,;
                    bLeft, bRight, bPgLeft, bPgRight, bValid )

   METHOD AddControl( oControl ) INLINE ;
                        If( ::aControls == nil, ::aControls := {},),;
                        AAdd( ::aControls, oControl ), ::lValidating := .f.

   METHOD BeginPaint() BLOCK ;      // it has to be BLOCK
          { | Self, cPS | ::nPaintCount := 1,;
                          ::hDC := BeginPaint( ::hWnd, @cPS ), ::cPS := cPS }

   METHOD Box( nTop, nLeft, nBottom, nRight )

   METHOD Capture() INLINE  SetCapture( ::hWnd )

   METHOD Center( oWnd ) INLINE  WndCenter( ::hWnd, oWnd:hWnd )

   METHOD Command( nWParam, nLParam )
   METHOD Circle( nRow, nCol, nWidth )

   METHOD CoorsUpdate()

   METHOD Create( cClsName )

   METHOD cTitle( cNewTitle ) SETGET
   
   METHOD Disable()  INLINE ::lActive := .f.,;
                            If( ::hWnd != nil, EnableWindow( ::hWnd, .f. ),)

   METHOD Enable()   INLINE ::lActive := .t.,;
                            If( ::hWnd != nil, EnableWindow( ::hWnd, .t. ),)

   METHOD End() BLOCK ;   // It has to be Block
      { | Self, lEnd | If( lEnd := ::lValid(), ::PostMsg( WM_CLOSE ),), lEnd }

   METHOD EndPaint() INLINE ::nPaintCount--,;
                     EndPaint( ::hWnd, ::cPS ), ::cPS := nil, ::hDC := nil

   METHOD cGenPrg()

   METHOD GetCliRect()

   METHOD GetRect()

   METHOD GetDC() INLINE ;
       If( ::hDC == nil, ::hDC := GetDC( ::hWnd ),),;
       If( ::nPaintCount == nil, ::nPaintCount := 1, ::nPaintCount++ ), ::hDC

   METHOD GetDlgCode() VIRTUAL

   METHOD GotFocus() INLINE ::lFocused := .t.

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD HardCopy( nScale )

   METHOD Hide() INLINE ShowWindow( ::hWnd, SW_HIDE )

   METHOD HScroll( nWParam, nLParam )

   METHOD KeyDown( nKey ) INLINE  If( ::bKeyDown != nil, Eval( ::bKeyDown, nKey ),)

   METHOD KeyChar( nKey ) INLINE ;
                          If( ::bKeyChar != nil, Eval( ::bKeyChar, nKey ),)

   METHOD LButtonDown( nRow, nCol, nKeyFlags )
   METHOD Line( nTop, nLeft, nBottom, nRight )
   METHOD Link( lSubClass )
   
   METHOD LostFocus() INLINE ::lFocused := .f.

   METHOD lWhen() INLINE  If( ::bWhen != nil, Eval( ::bWhen ), .t. )

   METHOD Minimize() INLINE  ShowWindow( ::hWnd, SW_MINIMIZE )

   METHOD MouseMove( nRow, nCol, nKeyFlags ) INLINE ;
                    If( ::oCursor != nil, SetCursor( ::oCursor:hCursor ),;
                        CursorArrow() ), 0

   METHOD Move( nTop, nLeft, nWidth, nHeight, lRepaint )
   
   METHOD Paint()

   METHOD PostMsg( nMsg, nWParam, nLParam ) INLINE ;
               PostMessage( ::hWnd, nMsg, nWParam, nLParam )

   METHOD Print( oTarget, nRow, nCol, nScale ) INLINE ;
                      WndPrint( ::hWnd, oTarget:hDC, nRow, nCol, nScale )

   METHOD RButtonDown( nRow, nCol, nKeyFlags )
   METHOD Release()

   METHOD ReleaseDC() INLINE  If( --::nPaintCount == 0,;
                              If( ReleaseDC( ::hWnd, ::hDC ), ::hDC := nil,),)

   
   METHOD Refresh( lErase ) INLINE InvalidateRect( ::hWnd,;
                                   If( lErase != nil, lErase, .t. ) )

   METHOD Register( nClsStyle )
          

   METHOD ReSize( nSizeType, nWidth, nHeight )
   METHOD Say( nRow, nCol, cText, nClrFore, nClrBack, oFont, lPixel )

   METHOD SayBitmap( nRow, nCol, coBitmap, nWidth, nHeight )

   METHOD SayRect( nRow, nCol, cText, nClrFore, nClrBack, nWidth )

   METHOD SelColor( lFore )  INLINE ;
          lFore := If( lFore == nil, lFore := .f., lFore ),;
          ::SetColor( If( lFore, ChooseColor( ::nClrText ), ::nClrText ),;
                      If( lFore, ::nClrPane, ChooseColor( ::nClrPane ) ) ),;
          ::Refresh()

   METHOD SendMsg( nMsg, nWParam, nLParam ) INLINE ;
                           SendMessage( ::hWnd, nMsg, nWParam, nLParam )
   
   METHOD SetBrush( oBrush ) INLINE If( ::oBrush != nil, ::oBrush:Release(),),;
                                    ::oBrush := oBrush, ::Refresh()

   METHOD SetColor( nClrFore, nClrBack, oBrush )

   METHOD SetCoors( oRect )

   METHOD SetFocus() INLINE  If( ::lWhen(), SetFocus( ::hWnd ),)

   METHOD SelFont() BLOCK { | Self, nClr | nClr := ::nClrText,;
                            ::SetFont( If( ::oFont == nil,;
                            TFont():New( ,,,.t. ),;
                            ::oFont:Choose( @nClr ) ) ), ::nClrText := nClr }

   METHOD SetFont( oFont ) INLINE ::oFont := oFont,;
                                  ::SendMsg( WM_SETFONT, oFont:hFont ),;
                                  ::Refresh( .t. )

   METHOD SetMenu( oMenu ) INLINE  SetMenu( ::hWnd, oMenu:hMenu ),;
                                   ::oMenu := oMenu, oMenu:oWnd := Self
   
   METHOD SetMsg( cText )

   METHOD SetPixel( nX, nY, nColor ) INLINE ;
                               SetPixel( ::GetDC(), nX, nY, nColor ),;
                               ::ReleaseDC()

   METHOD SetText( cText ) INLINE ;
                          ::cCaption := cText, SetWindowText( ::hWnd, cText )

   METHOD Show() INLINE  ShowWindow( ::hWnd, SW_SHOWNA )

   METHOD SysCommand( nWParam, nLParam )
   METHOD UnLink()

   METHOD lValid() INLINE If( ::bValid != nil, Eval( ::bValid ), .t. )

   METHOD VScroll( nWParam, nLParam )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD Register( nClsStyle )  CLASS TWindow

   DEFAULT nClsStyle  := nOR( CS_VREDRAW, CS_HREDRAW ),;
           ::nClrPane := CLR_GRAY, ::oBrush := TBrush():New( ,::nClrPane )

   RegisterClass( ::ClassName(), nClsStyle,,,, 0,;
                  ::oBrush:hBrush )

Return nil

//----------------------------------------------------------------------------//

METHOD Create( cClsName )  CLASS TWindow

   DEFAULT cClsName := ::ClassName(), ::cCaption := "",;
           ::nStyle := WS_OVERLAPPEDWINDOW,;
           ::nTop   := 0, ::nLeft := 0, ::nBottom := 10, ::nRight := 10,;
           ::nId    := 0

   if ::oWnd != nil
      ::nStyle = nOR( ::nStyle, WS_CHILD )
   endif

   ::hWnd = CreateWindow( cClsName, ::cCaption, ::nStyle, ;
                          ::nLeft, ::nTop, ::nRight - ::nLeft + 1, ;
                          ::nBottom - ::nTop + 1, ;
                          If( ::oWnd != nil, ::oWnd:hWnd, 0 ), ;
                          ::nId )

   ::Link()

   if ::oFont != nil
      ::SetFont( ::oFont )
   endif
   
return nil

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
            oBrush, oIcon, oWnd, lVScroll, lHScroll, nClrFore, nClrBack,;
            oCursor, cBorder, lSysMenu, lCaption, lMin, lMax ) ;
                                                               CLASS TWindow

   DEFAULT nTop     := 2, nLeft := 2, nBottom := 20, nRight := 70,;
           lVScroll := .f., lHScroll := .f.,;
           nClrFore := CLR_WHITE, nClrBack := CLR_GRAY,;
           nStyle   := 0,;
           cBorder  := "SINGLE", lSysMenu := .f., lCaption := .t.,;
           lMin     := .t., lMax := .t.

   if nStyle == 0
      nStyle = nOr( If( cBorder == "NONE",   WS_POPUP, 0 ),;
                    If( cBorder == "SINGLE", WS_THICKFRAME, 0 ),;
                    If( lCaption, WS_CAPTION, 0 ),;
                    If( lSysMenu .and. lCaption, WS_SYSMENU, 0 ),;
                    If( lMin .and. lCaption, WS_MINIMIZEBOX, 0 ),;
                    If( lMax .and. lCaption, WS_MAXIMIZEBOX, 0 ),;
                    If( lVScroll, WS_VSCROLL, 0 ),;
                    If( lHScroll, WS_HSCROLL, 0 ) )
   endif

   ::nTop      = nTop    * 16
   ::nLeft     = nLeft   *  8
   ::nBottom   = nBottom * 16
   ::nRight    = nRight  *  8
   ::nStyle    = nStyle
   ::cCaption  = cTitle
   ::oCursor   = oCursor
   ::oMenu     = oMenu
   ::oWnd      = oWnd
   ::oIcon     = oIcon
   ::lVisible  = .t.               // As soon as we create it, it exists!
   ::aControls = {}

   ::SetColor( nClrFore, nClrBack, oBrush )

   if ! lRegistered               // Windows API conexion
      ::Register()
   endif
   
   ::Create()

   if oMenu != nil
      SetMenu( ::hWnd, oMenu:hMenu )
      oMenu:oWnd = Self
   endif

   if lVScroll
      DEFINE SCROLLBAR ::oVScroll VERTICAL OF Self
   endif
   if lHScroll
      DEFINE SCROLLBAR ::oHScroll HORIZONTAL OF Self
   endif

   SetWndDefault( Self )                   // Set Default DEFINEd Window

return nil

//----------------------------------------------------------------------------//

METHOD Activate( cShow, bLClicked, bRClicked, bMoved, bResized, bPainted,;
                 bKeyDown, bInit,;
                 bUp, bDown, bPgUp, bPgDown,;
                 bLeft, bRight, bPgLeft, bPgRight, bValid ) CLASS TWindow

   local oVScroll, oHScroll

   DEFAULT cShow := "NORMAL"

   ::nResult     = nil
   ::lValidating = .f.
   ::bValid      = bValid

   if bPainted != nil
      if ::ClassName() == "TMDIFRAME"
         ::oWndClient:bPainted  = bPainted
      else
         ::bPainted  = bPainted
      endif
   endif

   if bRClicked != nil
      if ::ClassName() == "TMDIFRAME"
         ::oWndClient:bRClicked = bRClicked
      else
         ::bRClicked = bRClicked
      endif
   endif

   if ::oFont != nil
      ::SetFont( ::oFont )
   endif


   // For WS_VSCROLL and WS_HSCROLL styles

   if ::ClassName() == "TMDIFRAME"
      oVScroll = ::oWndClient:oVScroll
      oHScroll = ::oWndClient:oHScroll
   else
      oVScroll = ::oVScroll
      oHScroll = ::oHScroll
   endif

   if oVScroll != nil       // When using VSCROLL clause
      if bUp != nil
         oVScroll:bGoUp = bUp
      endif
      if bDown != nil
         oVScroll:bGoDown = bDown
      endif
      if bPgUp != nil
         oVScroll:bPageUp = bPgUp
      endif
      if bPgDown != nil
         oVScroll:bPageDown = bPgDown
      endif
   endif

   if oHScroll != nil       // When using HSCROLL clause
      if bLeft != nil
         oHScroll:bGoUp = bLeft
      endif
      if bRight != nil
         oHScroll:bGoDown = bRight
      endif
      if bPgLeft != nil
         oHScroll:bPageUp = bPgLeft
      endif
      if bPgRight != nil
         oHScroll:bPageDown = bPgRight
      endif
   endif

   ShowWindow( ::hWnd, AScan( { "NORMAL", "ICONIZED", "MAXIMIZED" }, cShow ) )
   UpdateWindow( ::hWnd )

   ::lVisible = .t.

   if ::bInit != nil
      Eval( ::bInit, Self )
   endif

   if ::oWnd == nil
      if ! lWRunning()
         WinRun( Self:hWnd )
      endif
   endif

   ::lVisible = .f.

return nil

//----------------------------------------------------------------------------//

METHOD Circle( nRow, nCol, nWidth ) CLASS TWindow

   ::GetDC()
   Ellipse( ::hDC, nCol, nRow, nCol + nWidth - 1, nRow + nWidth - 1 )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD Command( nWParam, nLParam ) CLASS TWindow

   do case
      case ::oPopup != nil
           ::oPopup:Command( nWParam )
           ::oPopup = nil

      case nLoWord( nLParam ) == 0 .and. ::oMenu != nil
           ::oMenu:Command( nWParam )

      case nWParam > 0
           do case
              case nHiWord( nLParam ) == BN_CLICKED
                   SendMessage( nLoWord( nLParam ), WM_CLICK, 0, 0 )

              case nHiWord( nLParam ) == CBN_SELCHANGE
                   SendMessage( nLoWord( nLParam ), WM_CHANGE, 0, 0 )
           endcase
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD CoorsUpdate() CLASS TWindow

   local aRect := GetWndRect( ::hWnd )

   ::nTop    = aRect[ 1 ]
   ::nLeft   = aRect[ 2 ]
   ::nBottom = aRect[ 3 ]
   ::nRight  = aRect[ 4 ]

return nil

//----------------------------------------------------------------------------//

METHOD cTitle( cNewTitle ) CLASS TWindow

   if cNewTitle != nil
      SetWindowText( ::hWnd, cNewTitle )
   endif

return GetWindowText( ::hWnd )

//----------------------------------------------------------------------------//

METHOD cGenPRG( cFileName ) CLASS TWindow

   local cPrg := ""

   ::CoorsUpdate()

   cPrg += '#include "FiveWin.ch"' + CRLF + CRLF
   cPrg += "static oWnd" + CRLF + CRLF
   cPrg += "//" + Replicate( "-", 76 ) + "//" + CRLF + CRLF
   cPrg += "function Main()" + CRLF + CRLF

   if ::oBar != nil
      cPrg += "   local oBar" + CRLF
   endif

   if ::oBrush != nil
      cPrg += "   local oBrush" + CRLF
   endif

   if ::oBrush != nil
      cPrg += ::oBrush:cGenPRG()
   endif

   cPrg += CRLF + ;
           '   DEFINE WINDOW oWnd TITLE "' + ::cTitle + '" ;' + CRLF + ;
           "      FROM " + ;
           Str( ::nTop / 16, 3 ) + ", " + Str( ::nLeft / 8, 3 ) + " TO " + ;
           Str( ::nBottom / 16, 3 ) + ", " + Str( ::nRight / 8, 3 )

   if ::oMenu != nil
      cPrg += " ;" + CRLF + "      MENU BuildMenu()"
   endif

   if ::oBrush != nil
      cPrg += " ;" + CRLF + "      BRUSH oBrush" + CRLF
   endif

   if ::oBar != nil
      cPrg += ::oBar:cGenPRG()
   endif

   if ::oMsgBar != nil
      cPrg += CRLF + CRLF + '   SET MESSAGE OF oWnd TO "' + ;
              ::oMsgBar:cMsgDef + '"'
   endif

   AEval( ::aControls, { | oCtrl | cPrg += oCtrl:cGenPRG() } )

   cPrg += CRLF + "   ACTIVATE WINDOW oWnd" + CRLF + CRLF
   cPrg += "return nil" + CRLF + CRLF
   cPrg += "//" + Replicate( "-", 76 ) + "//" + CRLF

   if ! Empty( cFileName )
      MemoWrit( cFileName, cPrg )
   endif

return cPrg

//----------------------------------------------------------------------------//

METHOD GetCliRect() CLASS TWindow

   local aRect := GetClientRect( ::hWnd )

return TRect():New( aRect[ 1 ], aRect[ 2 ], aRect[ 3 ], aRect[ 4 ] )

//----------------------------------------------------------------------------//

METHOD GetRect() CLASS TWindow

   local aRect := GetWndRect( ::hWnd )

return TRect():New( aRect[ 1 ], aRect[ 2 ], aRect[ 3 ], aRect[ 4 ] )

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TWindow

   local oItem
   local nAt

   do case
      case nMsg == WM_COMMAND
           return ::Command( nWParam, nLParam )

      case nMsg == WM_ERASEBKGND
           if IsIconic( ::hWnd )
              if ::oWnd != nil
                 FillRect( nWParam, GetClientRect( ::hWnd ), ::oWnd:oBrush:hBrush )
                 return 1
              endif
              return 0
           endif

           if ::oBrush != nil
              FillRect( nWParam, GetClientRect( ::hWnd ), ::oBrush:hBrush )
              return 1
           endif

      case nMsg == WM_MENUSELECT .and. ( ::oMenu != nil .or. ::oPopup != nil )
                                  // wParam ItemID  hPopUp
                                  // HIword lParam hMenu
                                  // LOword lParam MenuFlags : MF_...

           if ::oPopup != nil
              oItem = ::oPopup:GetMenuItem( nWParam )
           else
              oItem = ::oMenu:GetMenuItem( nWParam )
           endif
           ::SetMsg( If( oItem != nil, oItem:cMsg,) )

      case nMsg == WM_CTLCOLOR
           return SendMessage( nLoWord( nLParam ),;   // Handle Child
                               WM_COLOR,;             // FiveWin Message
                               nWParam )              // Child hDC

      case nMsg == WM_PALETTECHANGED
           return PalChgEvent( nWParam )

      case nMsg == WM_QUERYNEWPALETTE
           return QryNewPalEvent()

      case nMsg == WM_DDE_ACK
           DdeAck( nWParam, nLParam )

      case nMsg == WM_DESTROY
           ::Release()

      case nMsg == WM_GETDLGCODE
           return ::GetDlgCode()

      case nMsg == WM_PAINT
           ::BeginPaint()
           ::Paint()
           ::EndPaint()
           return 0

      case nMsg == WM_LBUTTONDOWN
           return ::LButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_QUERYDRAGICON
           return If( ::oIcon != nil, ::oIcon:hIcon,;
                      ExtractIcon( "user.exe" ) )

      case nMsg == WM_RBUTTONDOWN
           return ::RButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_CHAR
           return ::KeyChar( nWParam )

      case nMsg == WM_KEYDOWN
           return ::KeyDown( nWParam )

      case nMsg == WM_SIZE
           return ::ReSize( nWParam, nLoWord( nLParam ), nHiWord( nLParam ) )

      case nMsg == WM_SYSCOMMAND
           return ::SysCommand( nWParam, nLParam )

      case nMsg == WM_TIMER
           return TimerEvent( nWParam )

      case nMsg == WM_VSCROLL
           return ::VScroll( nWParam, nLParam )

      case nMsg == WM_HSCROLL
           return ::HScroll( nWParam, nLParam )

      case nMsg == WM_DRAWITEM
           return SendMessage( GetDlgItem( ::hWnd, nWParam ),;
                               FW_DRAW, 0, nLParam )

      case nMsg == WM_MEASUREITEM

           // Warning: On this message the Controls still are not initialized
           // because WM_MEASUREITEM is sent before of WM_INITDIALOG

           if ( nAt := AScan( ::aControls, { | oCtrl | oCtrl:nId == nWParam } ) ) != 0
              return ::aControls[ nAt ]:FillMeasure( nLParam )
           endif

       case nMsg == WM_SETFOCUS
            ::GotFocus()

       case nMsg == WM_MOUSEMOVE
            return ::MouseMove( nLoWord( nLParam ), nHiWord( nLParam ),;
                                nWParam )
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD Say( nRow, nCol, cText, nClrFore, nClrBack, oFont, lPixel ) CLASS TWindow

   DEFAULT nClrFore := ::nClrText,;
           nClrBack := ::nClrPane,;
           oFont    := ::oFont,;
           lPixel   := .f.

   if ValType( nClrFore ) == "C"      //  xBase Color string
      nClrBack = nClrFore
      nClrFore = nGetForeRGB( nClrFore )
      nClrBack = nGetBackRGB( nClrBack )
   endif

   ::GetDC()
   WSay( ::hWnd, ::hDC, nRow, nCol, cValToChar( cText ), nClrFore, nClrBack,;
         If( oFont != nil, oFont:hFont, 0 ), lPixel )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD SayBitmap( nRow, nCol, coBitmap, nWidth, nHeight ) CLASS TWindow

   local hDib, hPal
   local cType := ValType( coBitmap )

   if cType == "C"
      if File( coBitmap )
         hDib = DibRead( coBitmap )
         hPal = DibPalette( hDib )
      endif
   endif

   if cType == "O"
      hDib = If( coBitmap:hGlobal != 0, coBitmap:hGlobal, coBitmap:hResource )
      hPal = DibPalette( hDib )
   endif

   ::GetDC()
   DibDraw( ::hDC, hDib, hPal, nRow, nCol, nWidth, nHeight )
   ::ReleaseDC()

   if cType == "C"
      GlobalFree( hDib )
      DeleteObject( hPal )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD SayRect( nRow, nCol, cText, nClrFore, nClrBack, nWidth ) CLASS TWindow

   DEFAULT nClrFore := CLR_BLACK, nClrBack := CLR_WHITE

   ::GetDC()
   WSayRect( ::hWnd, ::hDC, nRow, nCol, cText, nClrFore, nClrBack, nWidth )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol, nKeyFlags ) CLASS TWindow

   if ::bLClicked != nil
      Eval( ::bLClicked, nRow, nCol, nKeyFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Line( nTop, nLeft, nBottom, nRight ) CLASS TWindow

   ::GetDC()
   MoveTo( ::hDC, nLeft, nTop )
   LineTo( ::hDC, nRight, nBottom )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD RButtonDown( nRow, nCol, nKeyFlags ) CLASS TWindow

   if ::bRClicked != nil
      Eval( ::bRClicked, nRow, nCol, nKeyFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD SetMsg( cText ) CLASS TWindow

   if ::oMsgBar != nil
      ::oMsgBar:SetMsg( cText )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Box( nTop, nLeft, nBottom, nRight ) CLASS TWindow

   ::GetDC()
   WndBox( ::hDC, nTop, nLeft, nBottom, nRight )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD Link( lSubClass ) CLASS TWindow

   local nAt := AScan( aWindows, 0 )

   DEFAULT lSubClass := .t.

   if nAt != 0
      aWindows[ nAt ] = Self
      SetProp( ::hWnd, "WP", nAt )
   else
      AAdd( aWindows, Self )
      SetProp( ::hWnd, "WP", Len( aWindows ) )
   endif

   if Len( aWindows ) == 1
      WindowsFix()
   endif

   if lSubClass
      ::nOldProc = ChangeProc( ::hWnd )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Release() CLASS TWindow

   if ::oBrush != nil
      ::oBrush:Release()
   endif
   if ::oCursor != nil
      ::oCursor:Release()
   endif
   if ::oIcon != nil
      ::oIcon:Release()
   endif
   if ::oFont != nil
      ::oFont:Release()
   endif
   if ::oMenu != nil
      ::oMenu:Release()
   endif
   if ::oSysMenu != nil
      ::oSysMenu:Release()
   endif

   ::UnLink()

   if GetProp( ::hWnd, "WP" ) == 1   .and. ; // We have here a TWindow,
      ::ChildLevel( TWindow() ) != 0 .and. ; // or inherited Class but NOT
      ::ChildLevel( TDialog() ) == 0         // a TDialog
      PostQuitMessage( 0 )
   endif

   if ::ChildLevel( TDialog() ) != 0   // TDialog Class or inherited Class
      DeRegDialog( ::hWnd )
      SetProp( ::hWnd, "WP", 0 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReSize( nSizeType, nWidth, nHeight ) CLASS TWindow

   ::CoorsUpdate()

   if ::oMsgBar != nil
      ::oMsgBar:Adjust()
   endif

   if ::oBar != nil
      ::oBar:Adjust()
   endif

   if ::bResized != nil
      Eval( ::bResized, nWidth, nHeight )
   endif

return 0

//----------------------------------------------------------------------------//

METHOD SetCoors( oRect ) CLASS TWindow

   SetWindowPos( ::hWnd, 0, oRect:nTop, oRect:nLeft,;
                 oRect:nRight - oRect:nLeft + 1,;
                 oRect:nBottom - oRect:nTop + 1, 0 )

   ::nTop    = oRect:nTop
   ::nLeft   = oRect:nLeft
   ::nBottom = oRect:nBottom
   ::nRight  = oRect:nRight

return nil

//----------------------------------------------------------------------------//

METHOD UnLink() CLASS TWindow

   local nAt := If( ::hWnd != 0, GetProp( ::hWnd, "WP" ), 0 )

   if ::nOldProc != nil .and. ::hWnd != 0
      RestProc( ::hWnd, ::nOldProc )
      ::nOldProc = nil
   endif

   if nAt > 0
      aWindows[ nAt ] = 0
   endif

return nil

//----------------------------------------------------------------------------//

METHOD VScroll( nWParam, nLParam ) CLASS TWindow

   local nScrHandle := nHiWord( nLParam )

   if nScrHandle == 0                   // Window ScrollBar
      do case
         case nWParam == SB_LINEUP
              ::oVScroll:GoUp()

         case nWParam == SB_LINEDOWN
              ::oVScroll:GoDown()

         case nWParam == SB_PAGEUP
              ::oVScroll:PageUp()

         case nWParam == SB_PAGEDOWN
              ::oVScroll:PageDown()

         case nWParam == SB_THUMBPOSITION
              ::oVScroll:ThumbPos( nLoWord( nLParam ) )

         case nWParam == SB_ENDSCROLL
              return 0
      endcase
   else                                 // Control ScrollBar
      do case
         case nWParam == SB_LINEUP
              SendMessage( nScrHandle, WM_SCROLLUP )

         case nWParam == SB_LINEDOWN
              SendMessage( nScrHandle, WM_SCROLLDOWN )

         case nWParam == SB_PAGEUP
              SendMessage( nScrHandle, WM_SCROLLPGUP )

         case nWParam == SB_PAGEDOWN
              SendMessage( nScrHandle, WM_SCROLLPGDN )

         case nWParam == SB_THUMBPOSITION
              SendMessage( nScrHandle, FW_THUMBPOS, nLoWord( nLParam ) )
      endcase
   endif

return 0

//----------------------------------------------------------------------------//

METHOD HScroll( nWParam, nLParam ) CLASS TWindow

   local nScrHandle := nHiWord( nLParam )

   if nScrHandle == 0                   // Window ScrollBar
      do case
         case nWParam == SB_LINEUP
              ::oHScroll:GoUp()

         case nWParam == SB_LINEDOWN
              ::oHScroll:GoDown()

         case nWParam == SB_PAGEUP
              ::oHScroll:PageUp()

         case nWParam == SB_PAGEDOWN
              ::oHScroll:PageDown()

         case nWParam == SB_THUMBPOSITION
              ::oHScroll:ThumbPos( nLoWord( nLParam ) )

         case nWParam == SB_ENDSCROLL
              return 0
      endcase
   else                                 // Control ScrollBar
      do case
         case nWParam == SB_LINEUP
              SendMessage( nScrHandle, WM_SCROLLUP )

         case nWParam == SB_LINEDOWN
              SendMessage( nScrHandle, WM_SCROLLDOWN )

         case nWParam == SB_PAGEUP
              SendMessage( nScrHandle, WM_SCROLLPGUP )

         case nWParam == SB_PAGEDOWN
              SendMessage( nScrHandle, WM_SCROLLPGDN )

         case nWParam == SB_THUMBPOSITION
              SendMessage( nScrHandle, FW_THUMBPOS, nLoWord( nLParam ) )
      endcase
   endif

return 0

//----------------------------------------------------------------------------//

METHOD SysCommand( nWParam, nLParam ) CLASS TWindow

   if ::oSysMenu != nil .and. nWParam < 61440           // 0xF000
      ::oSysMenu:Command( nWParam )
   else
      do case
         case nWParam == SC_CLOSE
              return ::End()
      endcase
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TWindow

   if IsIconic( ::hWnd )
      ::SendMsg( WM_ERASEBKGND, ::hDC, 0 )
      DrawIcon( ::hDC, 0, 0,;
      If( ::oIcon != nil, ::oIcon:hIcon, ExtractIcon( "user.exe" ) ) )
   else
      if ValType( ::bPainted ) == "B"
         Eval( ::bPainted, Self )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HardCopy( nScale ) CLASS TWindow

   local oPrn

   PRINT oPrn NAME ::cTitle
      PAGE
         ::Refresh()
         SysRefresh()                      // Let Windows process
         ::Print( oPrn, 0, 0, nScale )
      ENDPAGE
   ENDPRINT

return nil

//----------------------------------------------------------------------------//

METHOD Move( nTop, nLeft, nBottom, nRight, lRepaint ) CLASS TWindow

   MoveWindow( ::hWnd, nTop, nLeft, nBottom, nRight, lRepaint )

   ::nBottom = nTop + ( ::nBottom - ::nTop )
   ::nRight  = nLeft + ( ::nRight - ::nLeft )
   ::nTop    = nTop
   ::nLeft   = nLeft

return nil

//----------------------------------------------------------------------------//

METHOD SetColor( nClrFore, nClrBack, oBrush ) CLASS TWindow

   // DEFAULT colors get assigned at :Colors() method
   // because there we _do_ have a hDC already created

   if ValType( nClrFore ) == "C"
      nClrBack = nClrFore                   // It is a dBase Color string
      nClrFore = nGetForeRGB( nClrFore )
      nClrBack = nGetBackRGB( nClrBack )
   endif

   ::nClrText = nClrFore
   ::nClrPane = nClrBack

   if ::oBrush != nil
      ::oBrush:Release()
   endif
   if oBrush != nil
      ::oBrush = oBrush
   else
      ::oBrush = TBrush():New(,nClrBack,)
   endif

return nil

//----------------------------------------------------------------------------//
// Some friends functions

function SetWndDefault( oWnd ) ; oWndDefault := oWnd ; return nil

function GetWndDefault() ; return oWndDefault

//----------------------------------------------------------------------------//
