#include "FiveWin.ch"

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TVideo FROM TControl

   DATA   oMci

   METHOD New( nRow, nCol, nWidth, nHeight, cFileName, oWnd ) CONSTRUCTOR

   METHOD Play( nFrom, nTo ) INLINE  ::oMci:Play( nFrom, nTo, ::hWnd )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, nWidth, nHeight, cFileName, oWnd ) CLASS TVideo

   DEFAULT nWidth := 200, nHeight := 200, cFileName := ""

   ::nTop      = nRow *  8
   ::nLeft     = nCol * 14
   ::nBottom   = ::nTop  + nHeight - 1
   ::nRight    = ::nLeft + nWidth + 1
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE, WS_TABSTOP, WS_BORDER )
   ::nId       = ::GetNewId()
   ::oWnd      = oWnd
   ::oMci      = TMci():New( "avivideo", cFileName )
   ::lDrag     = .f.
   ::lCaptured = .f.

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   if oWnd:lVisible
      ::Create()
      ::oMci:lOpen()
      ::oMci:SetWindow( Self )
   else
      oWnd:DefControl( Self )
   endif

return

//----------------------------------------------------------------------------//
