//----------------------------------------------------------------------------//
//  FiveWin 1.5 - Ejemplos
//  (c) A.Linares, F.Pulpn 1993
//
//  Construir con BUILD TestMGet
//
//----------------------------------------------------------------------------//

// Ejemplos de 'multiples' tipos de controles,
// uso de ficheros INI y gestin de la impresin.

#include "FiveWin.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   DEFINE WINDOW oWnd FROM 1, 1 TO 30, 70;
      TITLE OemToAnsi( "Construccin de Dilogos, ficheros INI e Impresin" ) ;
      MENU BuildMenu()

   SET MESSAGE OF oWnd TO "FiveWin 1.5 - Ejemplos varios"

   ACTIVATE WINDOW oWnd MAXIMIZED
   
return

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu
   
   MENU oMenu
      MENUITEM OemtoAnsi( "&Caja de Dilogo" )
      MENU
         MENUITEM OemToAnsi( "Probar Caja de Dilogo" ) ACTION BuildDialog()
         SEPARATOR
         MENUITEM "Hemos terminado" ACTION oWnd:End()
      ENDMENU
      
      MENUITEM "Ficheros &INI"
      MENU
         MENUITEM "Leyendo desde WIN.INI" ;
            ACTION MsgInfo( GetProfString( "windows", "device" ) )
            
         MENUITEM "Leyendo desde un fichero INI privado" ;
            ACTION MsgInfo( GetPvProfString( "Hello", "world", "FiveWin", "test" ) )
      ENDMENU
      
      MENUITEM "&Imprimir..." ACTION PrintTest()
   ENDMENU   
   
return oMenu

//----------------------------------------------------------------------------//

function BuildDialog()

   local oDlg, oArial
   local cName    := "FiveWin 1.0        "
   local cListBox := "Cuatro"
   local cCombo   := "Que"

   DEFINE DIALOG oDlg FROM 5, 5 TO 20, 60 TITLE "Hello World!"
   
   DEFINE FONT oArial SIZE 20, 20

   @  1,  1 SAY "Hola" FONT oArial OF oDlg
   @  5,  8 GET cName  OF oDlg
   @  7,  4 BUTTON "&Hello" OF oDlg ACTION nMsgBox( "Hello" )
   @  7, 15 BUTTON "&Bye"   OF oDlg ACTION oDlg:Circle( 70, 10, 80 )
   @  1, 10 LISTBOX cListBox ITEMS ;
      { "Uno", "Dos", "Tres", "Cuatro", "Cinco", "Seis", "Siete" } OF oDlg

   @  1, 18 COMBOBOX cCombo ITEMS { "Hola", "Que", "Tal", "y tal..." } ;
      OF oDlg ON CHANGE MsgInfo( cCombo )

   ACTIVATE DIALOG oDlg CENTERED ;
      ON LEFT CLICK nMsgBox( OemToAnsi( " Increible !" ) )
   
   RELEASE FONT oArial

return

//----------------------------------------------------------------------------//

function PrintTest()

   local oPrn := TPrinter():New( "Test" )  // "Test" es el nombre del
                                           // trabajo de impresin a crear
   local fntArial

   DEFINE FONT fntArial NAME "Arial" SIZE 150, 80

   oPrn:StartPage()                        // Comienza una nueva pgina
   oPrn:Say( 10, 10, " Hola a todos. Esto es FiveWin !", fntArial )
   oPrn:EndPage()                          // Termina esa pgina

   RELEASE FONT fntArial

   oPrn:End()

return

//----------------------------------------------------------------------------//
