//----------------------------------------------------------------------------//
//  FiveWin 1.0 - Ejemplos
//  (c) A.Linares, F.Pulpn 1993
//
// Construir con BUILD TestClip
//----------------------------------------------------------------------------//

// Ejemplos de utilizacin del ClipBoard de Windows.
// Para FiveWin el ClipBoard de Windows es tambien un Objeto!

#include "FiveWin.ch"

static oWnd, oClp

//----------------------------------------------------------------------------//

function Main()

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 70 ;
      TITLE "Usando el PortaPapeles de Windows" ;
      MENU BuildMenu()

   DEFINE CLIPBOARD oClp OF oWnd

   SET MESSAGE OF oWnd ;
      TO OemToAnsi( "FiveWin 1.0 - (C) A.Linares, F.Pulpn 1993" )

   ACTIVATE WINDOW oWnd

return

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Manejo del PortaPapeles"
      MENU
         MENUITEM OemToAnsi( "&Poner algn texto..." ) ;
            ACTION PlaceSomeText()

         MENUITEM "&Coger el texto que haya..." ;
            ACTION GetSomeText()

         SEPARATOR

         MENUITEM "&Limpiar el PortaPapeles"  ACTION oClp:Clear()
         SEPARATOR
         MENUITEM "Bye, bye..."               ACTION oWnd:End()
      ENDMENU

      MENUITEM "Llamar al &PortaPapeles"      ACTION WinExec( "ClipBrd" )
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function PlaceSomeText()

   local cText := Space( 30 )

   if MsgGet( "De acuerdo...", OemToAnsi( " Escribe algo !" ), @cText )
      oClp:SetText( cText )
   endif

return

//----------------------------------------------------------------------------//

function GetSomeText()

   local cText := oClp:GetText()

   if Empty( cText )
      nMsgBox( OemToAnsi( "Ah no hay nada..." ), "Lo siento" )
   else
      nMsgBox( cText, OemToAnsi( " Tachannn !!!" ) )
   endif

return

//----------------------------------------------------------------------------//
