// FiveWin Report Tools

#include "FiveWin.ch"

static aRptBmps

//----------------------------------------------------------------------------//

function ReportNew()

   local cRptName
   local nStart := 1

   while File( cRptName := ( "REPORT" + SubStr( Str( nStart + 100, 3 ), 2 ) ;
                             + ".rpt" ) )
      nStart++
   end

   if ! File( cRptName )
      DbCreate( cRptName, { { "TYPE",     "N",  1, 0 },;
                            { "DESCRIPT", "C", 50, 0 } } )
   endif

   ReportOpen( cRptName )

return nil

//----------------------------------------------------------------------------//

function ReportOpen( cRptName )

   local oWndRpt, oIco, oBrw, oBar
   local cAlias
   field Type, Descript

   DEFAULT cRptName := cGetFile( "FiveWin IDE Report ( *.rpt ) | *.rpt",;
                                 "Select a Report" ),;
           aRptBmps := GetRptBmps()

   if ! Empty( cRptName )
      USE ( cRptName ) NEW SHARED
      cAlias = Alias()
      If RecCount() == 0
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 1 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 1 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 1 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 1 ; UNLOCK

         APPEND BLANK ; RLock() ; ( cAlias )->Type := 2 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 2 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 2 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 2 ; UNLOCK

         APPEND BLANK ; RLock() ; ( cAlias )->Type := 3 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 3 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 3 ; UNLOCK
         APPEND BLANK ; RLock() ; ( cAlias )->Type := 3 ; UNLOCK
      endif
      INDEX ON Field->Type TO ( cAlias )
      SET INDEX TO ( cAlias )
   else
      return nil
   endif

   DEFINE ICON oIco RESOURCE "Report"

   DEFINE WINDOW oWndRpt FROM 1, 1 TO 23, 33 ;
      TITLE "Report: " + cNoPath( cNoExt( cRptName ) ) MDICHILD ;
      ICON oIco

   DEFINE BUTTONBAR oBar OF oWndRpt

   DEFINE BUTTON RESOURCE "Exec" OF oBar ;
      MESSAGE "Execute this report"

   @  0, 0 LISTBOX oBrw ;
      FIELDS aRptBmps[ ( cAlias )->( Type ) ], ( cAlias )->( Descript ) ;
      HEADERS "", "Description" ;
      COLSIZES 16, 200 ;
      SIZE 400, 400

   oWndRpt:SetControl( oBrw )

   ACTIVATE WINDOW oWndRpt ;
      VALID oBrw:lCloseArea()

return nil

//----------------------------------------------------------------------------//
