#include "FiveWin.ch"

#define HORZSIZE            4
#define VERTSIZE            6
#define HORZRES             8
#define VERTRES            10
#define LOGPIXELSX         88
#define LOGPIXELSY         90

#define MM_TEXT             1
#define MM_LOMETRIC         2
#define MM_HIMETRIC         3
#define MM_LOENGLISH        4
#define MM_HIENGLISH        5
#define MM_TWIPS            6
#define MM_ISOTROPIC        7
#define MM_ANISOTROPIC      8

static oPrinter

//----------------------------------------------------------------------------//

CLASS TPrinter

   DATA   hDC

   METHOD New( cDocument, oWnd ) CONSTRUCTOR

   METHOD StartPage() INLINE  StartPage( ::hDC )

   METHOD EndPage()   INLINE  EndPage( ::hDC )

   METHOD End()       INLINE  EndDoc( ::hDC ), DeleteDC( ::hDC )

   METHOD Say( nRow, nCol, cText, oFont )

   METHOD SetPos( nRow, nCol )  VIRTUAL
   METHOD Line( nRow, nCol )    VIRTUAL

   METHOD Box( nRow, nCol, nBottom, nRight ) INLINE ;
                      Rectangle( ::hDC, nRow, nCol, nBottom, nRight )

   METHOD nVertRes()  INLINE  GetDeviceCaps( ::hDC, VERTRES  )
   METHOD nHorzRes()  INLINE  GetDeviceCaps( ::hDC, HORZRES  )

   METHOD nVertSize() INLINE  GetDeviceCaps( ::hDC, VERTSIZE )
   METHOD nHorzSize() INLINE  GetDeviceCaps( ::hDC, HORZSIZE )

   METHOD nLogPixelsX() INLINE GetDeviceCaps( ::hDC, LOGPIXELSX )
   METHOD nLogPixelsY() INLINE GetDeviceCaps( ::hDC, LOGPIXELSY )

   METHOD SetPixelMode()  INLINE SetMapMode( ::hDC, MM_TEXT )
   METHOD SetTwipsMode()  INLINE SetMapMode( ::hDC, MM_TWIPS )

   METHOD SetLoInchMode() INLINE SetMapMode( ::hDC, MM_LOENGLISH )
   METHOD SetHiInchMode() INLINE SetMapMode( ::hDC, MM_HIENGLISH )

   METHOD SetLoMetricMode() INLINE SetMapMode( ::hDC, MM_LOMETRIC )
   METHOD SetHiMetricMode() INLINE SetMapMode( ::hDC, MM_HIMETRIC )

   METHOD SetIsotropicMode()   INLINE SetMapMode( ::hDC, MM_ISOTROPIC )
   METHOD SetAnisotropicMode() INLINE SetMapMode( ::hDC, MM_ANISOTROPIC )

   METHOD SetWindowExt( nUnitsWidth, nUnitsHeight ) INLINE ;
                        SetWindowExt( ::hDC, nUnitsWidth, nUnitsHeight )

   METHOD SetViewPortExt( nWidth, nHeight ) INLINE ;
                          SetViewPortExt( ::hDC, nWidth, nHeight )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cDocument, oWnd ) CLASS TPrinter

   ::hDC = GetPrintDC( If( oWnd == nil, GetActiveWindow(), oWnd:hWnd ) )

   StartDoc( ::hDC, cDocument )

return nil

//----------------------------------------------------------------------------//

METHOD Say( nRow, nCol, cText, oFont ) CLASS TPrinter

   if oFont != nil
      oFont:Activate( ::hDC )
   endif

   TextOut( ::hDC, nRow, nCol, cText )

   if oFont != nil
      oFont:DeActivate( ::hDC )
   endif

return nil

//----------------------------------------------------------------------------//
// Friend functions

function PrintBegin( cDocName )

return ( oPrinter := TPrinter():New( cDocName ) )

//----------------------------------------------------------------------------//

function PageBegin() ; oPrinter:StartPage() ; return nil

function PageEnd() ; oPrinter:EndPage(); return nil

function PrintEnd() ; oPrinter:End() ; oPrinter := nil; return nil

//----------------------------------------------------------------------------//
