#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

#include "c:\FiveWin.15\source\internal\SQL.h"
#include "c:\FiveWin.15\source\internal\SQLExt.h"

static HSTMT hStmt;

//----------------------------------------------------------------------------//

CLIPPER SQLALLOCEN() //  V()    @ hEnv  --> nRetCode
{
   HENV hEnv;
   RETCODE ret = SQLAllocEnv( &hEnv );

   _stornl( ( LONG ) hEnv, 1 );
   _retni( ret );
}

//----------------------------------------------------------------------------//

CLIPPER SQLALLOCCO() // NNECT()   hEnv, @ hDbc   --> nRetCode
{
   HDBC hDbc;
   RETCODE ret = SQLAllocConnect( ( HENV ) _parnl( 1 ), &hDbc );

   _stornl( ( LONG ) hDbc, 2 );
   _retni( ret );
}

//----------------------------------------------------------------------------//

CLIPPER SQLEXECDIR()  // ECT()   hStmt, cStatement  --> nRetCode
{
   _retni( SQLExecDirect( ( HSTMT ) _parnl( 1 ), _parc( 2 ), SQL_NTS ) );
}

//----------------------------------------------------------------------------//

CLIPPER SQLDRIVERC() // ONNECT()  hDbc, @ cConnectString, lPrompt  --> nRetCode
{
   BYTE  bBuffer1[ 300 ];
   WORD  wLen;
   BOOL  bPrompt = _parl( 3 );

   _retni( SQLDriverConnect( ( HDBC ) _parnl( 1 ),
                             GetActiveWindow(),
                             _parc( 2 ), _parclen( 2 ),
                             bBuffer1, 300, &wLen,
                        bPrompt ? SQL_DRIVER_PROMPT: SQL_DRIVER_NOPROMPT ) );

   _storc( bBuffer1, 2 );
}

//----------------------------------------------------------------------------//

CLIPPER SQLCONNECT() // hDbc, cDSN, cUser, cPassword
{
   _retni( SQLConnect( ( HDBC ) _parnl( 1 ),
                       _parc( 2 ), _parclen( 2 ),
                       _parc( 3 ), _parclen( 3 ),
                       _parc( 4 ), _parclen( 4 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER SQLALLOCST()  // MT()   hDbc, @ hStmt  --> nRetCode
{
   HSTMT hStmt;

   _retni( SQLAllocStmt( ( HDBC ) _parnl( 1 ), &hStmt ) );
   _stornl( ( LONG ) hStmt, 2 );
}

//----------------------------------------------------------------------------//

CLIPPER SQLDESCRIB() // ECOL() hStmt, nField, @ cColName, @nType, @nLen, @nDec,
                     //        @lNull
{
   BYTE   szName[ 20 ];
   SWORD  wNameLen, wType, wDec, wNull;
   UDWORD lLen;

   _retni( SQLDescribeCol( ( HSTMT ) _parnl( 1 ), _parni( 2 ),
                           szName, 20, &wNameLen, &wType,
                           &lLen, &wDec, &wNull ) );
   _storc( szName, 3 );
   _storni( wType, 4 );
   _stornl( lLen,  5 );
   _storni( wDec,  6 );
   _storni( wNull, 7 );
}

//----------------------------------------------------------------------------//

CLIPPER SQLERROR() //  hEnv, hDbc, hStmt, @ cErrorClass, @ nType, @ cErrorMsg
{
   BYTE bBuffer1[ 256 ], szErrorMsg[ 256 ];
   UDWORD lError;
   SWORD wLen;

   _retni( SQLError( ( HENV ) _parnl( 1 ), ( HDBC ) _parnl( 2 ),
                     ( HSTMT ) _parnl( 3 ), bBuffer1, &lError,
                     szErrorMsg, 256, &wLen ) );

   _storc( bBuffer1, 4 );
   _stornl( lError, 5 );
   _storc( szErrorMsg, 6 );
}

//----------------------------------------------------------------------------//

CLIPPER SQLPREPARE() // hStmt, cCommand
{
   _retni( SQLPrepare( ( HSTMT ) _parnl( 1 ), _parc( 2 ), SQL_NTS ) );
}

//----------------------------------------------------------------------------//

CLIPPER SQLFREESTM() // T()  hStmt, nType   --> nRetCode
{
   _retni( SQLFreeStmt( ( HSTMT ) _parnl( 1 ), _parni( 2 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER SQLDISCONN()  // ECT()  hDbc  --> nRetCode
{
   _retni( SQLDisconnect( ( HDBC ) _parnl( 1 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER SQLFREECON()  // NECT()  hDbc  --> nRetCode
{
   _retni( SQLFreeConnect( ( HDBC ) _parnl( 1 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER SQLFREEENV()  // hEnv  --> nRetCode
{
   _retni( SQLFreeEnv( ( HENV ) _parnl( 1 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER SQLNUMRESU() // LTCOLS()  hStmt, @ nRows  --> nRetCode
{
   SWORD wRows;

   _retni( SQLNumResultCols( ( HSTMT ) _parnl( 1 ), &wRows ) );
   _storni( wRows, 2 );
}

//----------------------------------------------------------------------------//

CLIPPER SQLGETDATA() //  hStmt, nField, nType, nLen, @ cBuffer   --> nRetCode
{
   LONG lLen    = _parnl( 4 );
   PTR  bBuffer = _xgrab( lLen );
   WORD wType   = _parni( 3 ) ? _parni( 3 ): SQL_BINARY;

   _retni( SQLGetData( ( HSTMT ) _parnl( 1 ), _parni( 2 ),
                       wType, ( PTR ) bBuffer, lLen, &lLen ) );

   _storclen( ( LPSTR ) bBuffer, ( WORD ) lLen, 5 );
   _xfree( ( PTR ) bBuffer );
}

//----------------------------------------------------------------------------//

CLIPPER SQLFETCH()   //  hStmt  --> nRetCode
{
   _retni( SQLFetch( ( HSTMT ) _parnl( 1 ) ) );
}

//----------------------------------------------------------------------------//
