#include "FiveWin.ch"

#define MF_BYCOMMAND 0
#define MF_ENABLED   0
#define MF_UNCHECKED 0
#define MF_GRAYED    1
#define MF_DISABLED  2
#define MF_CHECKED   8

static nId := 100    // To avoid conflicts with MDI automatic MenuItems

//----------------------------------------------------------------------------//

CLASS TMenuItem

   DATA   cPrompt, cMsg
   DATA   nId
   DATA   bAction
   DATA   lChecked, lActive
   DATA   oMenu
   DATA   hBitmap

   METHOD New( cPrompt, cMsg, lChecked, lActive, bAction, cBmpFile,;
               cResName, nVKState, nVirtKey ) CONSTRUCTOR

   METHOD ReDefine( cPrompt, cMsg, lChecked, lActive, bAction, cBmpFile,;
                    cResName, oMenu, bBlockAction, nId, nVKState,;
                    nVirtKey ) CONSTRUCTOR

   METHOD SetCheck( lOnOff ) BLOCK ;
      { | Self, lOnOff | ::lChecked := lOnOff, CheckMenuItem( ::oMenu:hMenu,;
      ::nId, nOR( MF_BYCOMMAND, If( lOnOff, MF_CHECKED, MF_UNCHECKED ) ) ) }

   METHOD Enable() BLOCK ;
      { | Self | ::lActive := .t.,;
                 EnableMenuItem( ::oMenu:hMenu, ::nId, MF_ENABLED ) }

   METHOD Disable() INLINE ::lActive := .f.,;
      EnableMenuItem( ::oMenu:hMenu, ::nId, nOR( MF_DISABLED, MF_GRAYED ) )

   METHOD Release() INLINE If( ::hBitmap != 0, DeleteObject( ::hBitmap ),)

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cPrompt, cMsg, lChecked, lActive, bAction, cBmpFile, cResName,;
            nVKState, nVirtKey ) CLASS TMenuItem

   DEFAULT lChecked := .f., lActive := .t., cBmpFile := ""

   ::bAction  = bAction
   ::cPrompt  = cPrompt
   ::cMsg     = cMsg
   ::nId      = nId++
   ::lChecked = lChecked
   ::lActive  = lActive
   ::hBitmap  = 0

   if ! Empty( cBmpFile )
      ::hBitmap = ReadBitmap( 0, cBmpFile )
   endif
   if ! Empty( cResName )
      ::hBitmap = LoadBitmap( GetResources(), cResName )
   endif

   if nVirtKey != nil
      __AddAccel( nVKState, nVirtKey, ::nId )
   endif

return

//----------------------------------------------------------------------------//

METHOD ReDefine( cPrompt, cMsg, lChecked, lActive, bAction, cBmpFile,;
                 cResName, oMenu, bBlockAction, nId, nVKState,;
                 nVirtKey ) CLASS TMenuItem

   DEFAULT oMenu := ::oMenu

   if oMenu != nil
      Self = oMenu:GetMenuItem( nId )
   endif

   if lChecked != nil
      if lChecked != ::lChecked
         ::lChecked = lChecked
         if oMenu != nil .and. nId != nil
            CheckMenuItem( oMenu:hMenu, nId, nOr( MF_BYCOMMAND,;
                           If( lChecked, MF_CHECKED, MF_UNCHECKED ) ) )
         endif
      endif
   endif

   if lActive != nil
      if lActive != ::lActive
         ::lActive = lActive
         if oMenu != nil .and. nId != nil
            EnableMenuItem( oMenu:hMenu, nId, nOr( MF_BYCOMMAND,;
                            If( lActive, MF_ENABLED, MF_DISABLED ) ) )
         endif
      endif
   endif

   ::cMsg     = cMsg
   ::bAction  = bAction
   ::oMenu    = oMenu
   ::hBitmap  = 0

   if bBlockAction != nil
      ::bAction = bBlockAction
   endif

   if ! Empty( cBmpFile )
      ::hBitmap = ReadBitmap( 0, cBmpFile )
   endif
   if ! Empty( cResName )
      ::hBitmap = LoadBitmap( GetResources(), cResName )
   endif

   if nVirtKey != nil
      __AddAccel( nVKState, nVirtKey, ::nId )
   endif

return

//----------------------------------------------------------------------------//
