#include "FiveWin.ch"

#define SC_RESTORE  61728
#define SC_MINIMIZE 61472
#define SC_CLOSE    61536
#define SC_NEXT     61504

#define SIZE_MAXIMIZED  2

static lRegistered := .f.

static oWndMain

//----------------------------------------------------------------------------//

CLASS TMdiFrame FROM TWindow

   DATA   oWndClient, oWndActive

   METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
               oBrush, oIcon, nClrFore, nClrBack, lVScroll,;
               lHScroll, nMenuInfo, cBorder ) CONSTRUCTOR

   METHOD ChildNew( nTop, nLeft, nBottom, nRight, cTitle, nStyle ) INLINE ;
          ::oWndClient:ChildNew( nTop, nLeft, nBottom, nRight, cTitle, nStyle )

   METHOD Cascade()      INLINE ::oWndClient:Cascade()
   METHOD CloseAll()     INLINE ::oWndClient:lCloseAll()

   METHOD Tile( lHor )   INLINE ::oWndClient:Tile( lHor )
   METHOD ArrangeIcons() INLINE ::oWndClient:ArrangeIcons()
   METHOD NextWindow()   INLINE ::oWndClient:NextWindow()

   METHOD ReSize( nSizeType, nWidth, nHeight )

   METHOD Command( nWParam, nLParam )

   METHOD End()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu, oBrush,;
            oIcon, nClrFore, nClrBack, lVScroll, lHScroll, nMenuInfo,;
            cBorder ) CLASS TMdiFrame

   DEFAULT nStyle    := nOR( WS_OVERLAPPEDWINDOW, WS_CLIPCHILDREN ),;
           lVScroll  := .f., lHScroll := .f.,;
           nMenuInfo := 2,;
           nClrFore  := CLR_BLACK, nClrBack := CLR_GRAY

   ::nTop        = nTop    * 16
   ::nLeft       = nLeft   *  8
   ::nBottom     = nBottom * 16
   ::nRight      = nRight  *  8
   ::nStyle      = nStyle
   ::cCaption    = cTitle
   ::nId         = 0
   ::oIcon       = oIcon
   ::lValidating = .f.

   if oMenu == nil
      MENU oMenu
         MENUITEM "&Childs"
         MENU
            MENUITEM "New..." ACTION ::ChildNew( 2, 2, 10, 40 )
            SEPARATOR
            MENUITEM "E&xit"  ACTION ::End()
         ENDMENU
         MENUITEM "&Window"
         MENU
            MENUITEM "&Tile Vertical"   ACTION ::Tile()
            MENUITEM "&Tile Horizontal" ACTION ::Tile( .t. )
            MENUITEM "&Cascade"         ACTION ::Cascade()
            MENUITEM "&Next Window"     ACTION ::NextWindow()
            MENUITEM "&Arrange Icons"   ACTION ::ArrangeIcons()
            MENUITEM "&Close All"       ACTION ::CloseAll()
         ENDMENU
      ENDMENU
   endif

   if ! lRegistered
      RegisterClass( ::ClassName(),;
                     nOR( CS_VREDRAW, CS_HREDRAW ),;
                     0, 0, 0, 0, 0, "", GetFrameProc() )
      lRegistered = .t.
   endif

   ::Create()
   ::SetColor( nClrFore, nClrBack, oBrush )
   ::SetMenu( oMenu )
                                        // SubMenu, nChild
   ::oWndClient = TMdiClient():New( Self, nMenuInfo, 1,, lVScroll,;
                                    lHScroll )
   ::oWndClient:SetColor( nClrFore, nClrBack, oBrush )

   oWndMain = Self

return nil

//----------------------------------------------------------------------------//

METHOD ReSize( nSizeType, nWidth, nHeight ) CLASS TMdiFrame

   local nPos := If( ::oBar != nil, ::oBar:nBtnHeight - 1, 0 )
   local oWnd

   Super:ReSize( nSizeType, nWidth, nHeight )

   if ::oWndClient != nil
      ::oWndClient:Move( nPos + If( nPos != 0, 2, 0 ),;
                         0, nWidth, nHeight - nPos - ;
                         If( ::oMsgBar != nil, 26, 2 ), .t. )
   endif

return 0

//----------------------------------------------------------------------------//

METHOD Command( nWParam, nLParam ) CLASS TMdiFrame

   local oWnd := ::oWndClient:GetActive()

   do case
      case nWParam < 100
           ::oWndClient:ChildActivate( ::oWndClient:aWnd[ nWParam ] )

      case nWParam == SC_RESTORE .or. nWParam == SC_MINIMIZE .or. ;
           nWParam == SC_CLOSE .or. nWParam == SC_NEXT
           if oWnd != nil
              oWnd:SendMsg( WM_COMMAND, nWParam, nLParam )
           endif

      otherwise
         Super:Command( nWParam, nLParam )
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD End() CLASS TMdiFrame

   if ::bValid != nil
      if ! Eval( ::bValid )
         return .f.
      endif
   endif

   if ::oWndClient:lCloseAll()
      ::PostMsg( WM_CLOSE )
   else
      return .f.
   endif

return .t.

//----------------------------------------------------------------------------//

function GetWndFrame() ; return oWndMain      // Default Frame Window

//----------------------------------------------------------------------------//
