#include "FiveWin.ch"

#define WM_MDICREATE        544   // 0x0220
#define WM_MDIDESTROY       545   // 0x0221
#define WM_MDIACTIVATE      546   // 0x0222
#define WM_MDIRESTORE       547   // 0x0223
#define WM_MDINEXT          548   // 0x0224
#define WM_MDIMAXIMIZE      549   // 0x0225
#define WM_MDITILE          550   // 0x0226
#define WM_MDICASCADE       551   // 0x0227
#define WM_MDIICONARRANGE   552   // 0x0228
#define WM_MDIGETACTIVE     553   // 0x0229
#define WM_MDISETMENU       554   // 0x0230

#define WM_CHILDACTIVATE     34   // 0x22

#define SC_RESTORE        61728
#define SC_CLOSE          61536   // 0xF060
#define SC_MINIMIZE       61472
#define SC_NEXT           61504
#define SC_MAXIMIZE       61488   // 0xF030

#define IDC_ARROW         32512

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TMdiChild FROM TWindow

   DATA   oWndClient, oControl

   METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
               oWnd, oIcon, lVScroll, nClrText, nClrBack, oCursor,;
               oBrush, lPixel ) CONSTRUCTOR

   METHOD Maximize() INLINE ::oWndClient:ChildMaximize( Self )

   METHOD Restore()  INLINE ::oWndClient:ChildRestore( Self )

   METHOD Activate( cShow, bLClicked, bRClicked, bMoved, bResized, bPainted,;
                    bKeyDown, bInit,;
                    bUp, bDown, bPgUp, bPgDn,;
                    bLeft, bRight, bPgLeft, bPgRight, bValid ) INLINE ;
                    ;
                    ::oWndClient:ChildActivate( Self ),;
                    Super:Activate( cShow, bLClicked, bRClicked, bMoved,;
                    bResized, bPainted, bKeyDown, bInit,;
                    bUp, bDown, bPgUp, bPgDn,;
                    bLeft, bRight, bPgLeft, bPgRight, bValid ),;
                    ::lVisible := .t.,;
                    If( ::oControl != nil, ::oControl:SetFocus(),)

   METHOD End()

   METHOD GotFocus() INLINE If( ::oControl != nil, ::oControl:SetFocus(),)

   METHOD Next() INLINE ::oWndClient:ChildNext( Self )
   METHOD Prev() INLINE ::oWndClient:ChildNext( Self, .t. )

   METHOD ReSize() BLOCK { | Self, oRect | ;     // It has to be BLOCK
                   Super:ReSize(),;
                   oRect := ::GetCliRect(),;
                   oRect:nTop += If( ::oBar != nil, ::oBar:nBtnHeight, 0 ),;
                   oRect:nLeft--,;
                   If( ::oControl != nil, ::oControl:SetCoors( oRect ),), nil }

   METHOD Command( nWParam, nLParam )

   METHOD SysCommand( nWParam, nLParam )

   METHOD SetControl( oCtrl ) INLINE ::oControl := oCtrl, ::ReSize()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu, oWnd,;
            oIcon, lVScroll, nClrFore, nClrBack, oCursor, oBrush,;
            lPixel ) CLASS TMdiChild

   DEFAULT cTitle   := "MDI Child", lVScroll := .f.,;
           oWnd     := GetWndFrame(),;
           nClrFore := oWnd:oWndClient:nClrText,;
           nClrBack := oWnd:oWndClient:nClrPane,;
           lPixel   := .f.

   ::nTop       = nTop    * If( ! lPixel, 16, 1 )
   ::nLeft      = nLeft   * If( ! lPixel,  8, 1 )
   ::nBottom    = nBottom * If( ! lPixel, 16, 1 )
   ::nRight     = nRight  * If( ! lPixel,  8, 1 )
   ::oWndClient = oWnd:oWndClient
   ::oWnd       = oWnd
   ::nStyle     = nStyle
   ::oIcon      = oIcon
   ::lVisible   = .t.
   ::aControls  = {}

   ::oCursor    = oCursor

   ::SetColor( nClrFore, nClrBack, oBrush )

   if ! lRegistered
      RegisterClass( "TMDICHILD",;
                     nOR( CS_VREDRAW, CS_HREDRAW ),;
                     0, 0, 0, 0, 0, "", GetMDIChlProc() )
      lRegistered = .t.
   endif

   ::hWnd = ::oWndClient:SendMsg( WM_MDICREATE, 0,;
        cMdiStruct( "TMDICHILD", cTitle,;
                    ::nTop, ::nLeft, ::nBottom, ::nRight,;
                    ::nStyle ) )
   ::Link()

   if oMenu != nil
      ::SetMenu( oMenu )
   endif

   if lVScroll
      DEFINE SCROLLBAR ::oVScroll VERTICAL OF Self
   endif

   ::oWndClient:Add( Self )

   SetWndDefault( Self )              // Set Default DEFINEd Window

return nil

//----------------------------------------------------------------------------//

METHOD Command( nWParam, nLParam ) CLASS TMdiChild

   do case
      case nWParam == SC_RESTORE
           ::Restore()

      case nWParam == SC_CLOSE
           return ::End()

      case nWParam == SC_MINIMIZE
           ::Minimize()

      case nWParam == SC_NEXT
           ::Next()

      otherwise
           Super:Command( nWParam, nLParam )
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD SysCommand( nWParam, nLParam ) CLASS TMdiChild

   do case
      case nWParam == SC_RESTORE
           ::Restore()

      case nWParam == SC_CLOSE
           return ::End()

      case nWParam == SC_MINIMIZE
           ::Minimize()

      case nWParam == SC_NEXT
           ::Next()

      otherwise
           Super:SysCommand( nWParam, nLParam )
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD End() CLASS TMdiChild

   local lEnd := .t.

   if ::bValid != nil
      if Eval( ::bValid )
         ::oWndClient:ChildClose( Self )
      else
         lEnd = .f.
      endif
   else
      ::oWndClient:ChildClose( Self )
   endif

return lEnd

//----------------------------------------------------------------------------//
