// FiveWin installation program   ver 1.0

// Please feel free to use it for your own installations,
// and modify it to suit your needs

#include "FiveWin.ch"
#include "Install.ch"

#define MERGEPAINT 12255782    // 0xBB0226
#define SRCAND      8913094

static oWnd, hBmpText1, hBmpText2, oMeter, nPercent := 0
static cTarget := "c:\FiveWin.16                                 "

//----------------------------------------------------------------------------//

function Main()

   SET 3DLOOK ON

   hBmpText1 = LoadBitmap( GetResources(), "Inst1" )
   hBmpText2 = LoadBitmap( GetResources(), "Inst2" )

   DEFINE WINDOW oWnd STYLE nOr( WS_POPUP, WS_VISIBLE ) COLOR "W/N"

   ACTIVATE WINDOW oWnd MAXIMIZED ;
      ON INIT  DlgInstall() ;
      ON PAINT ( FillBlue(), SayBitmaps() )

   DeleteObject( hBmpText1 )
   DeleteObject( hBmpText2 )

return nil

//----------------------------------------------------------------------------//

function DlgInstall()

   local oDlg
   local lLib  := .t., lSamples := .t., lInclude := .t., lManual := .t.,;
         lUtil := .t., lSource := .t., lGroup := .t.
   local nTotal   := 2760000
   local oRequired

   DEFINE DIALOG oDlg RESOURCE "Install" OF oWnd

   REDEFINE CHECKBOX lLib ID ID_LIB  OF oDlg ;
      ON CHANGE ( nTotal += If( lLib, 550000, -550000 ),;
                  oRequired:SetText( nTotal ) )

   REDEFINE CHECKBOX lSamples ID ID_EXAMPLES  OF oDlg ;
      ON CHANGE ( nTotal += If( lSamples, 1150000, -1150000 ),;
                  oRequired:SetText( nTotal ) )

   REDEFINE CHECKBOX lInclude ID ID_HEADERS   OF oDlg ;
      ON CHANGE ( nTotal += If( lInclude, 90000, -90000 ),;
                  oRequired:SetText( nTotal ) )

   REDEFINE CHECKBOX lManual ID ID_MANUALS   OF oDlg ;
      ON CHANGE ( nTotal += If( lManual, 600000, -600000 ),;
                  oRequired:SetText( nTotal ) )

   REDEFINE CHECKBOX lUtil ID ID_UTILITIES OF oDlg ;
      ON CHANGE ( nTotal += If( lUtil, 20000, -20000 ),;
                  oRequired:SetText( nTotal ) )

   REDEFINE CHECKBOX lSource  ID ID_SOURCE OF oDlg ;
      ON CHANGE ( nTotal += If( lSource, 350000, -350000 ),;
                  oRequired:SetText( nTotal ) )

   REDEFINE GET cTarget ID ID_TARGET OF oDlg

   REDEFINE SAY oRequired PROMPT nTotal PICTURE "    999,999,999" ;
      ID ID_REQUIRED OF oDlg

   REDEFINE SAY PROMPT DiskSpace() PICTURE "  999,999,999" ;
      ID ID_AVAILABLE OF oDlg

   REDEFINE CHECKBOX lGroup ID ID_GROUP OF oDlg

   REDEFINE METER oMeter VAR nPercent TOTAL 100 ID ID_METER OF oDlg

   REDEFINE BUTTON ID ID_CONTINUE OF oDlg ;
      ACTION ( CopyFiles( lLib, lSamples, lInclude, lManual,;
                          lUtil, lSource ),;
               If( lGroup, BuildGroup(),),;
               MsgInfo( "FiveWin successfully installed!" ),;
               oDlg:End() )

   REDEFINE BUTTON ID ID_INFO OF oDlg ;
      ACTION ShellAbout( FWVERSION, FWCOPYRIGHT,;
                         LoadIcon( GetInstance(), "FiveWin" ) )

   REDEFINE BUTTON ID 230 OF oDlg ;
      ACTION ( MsgStop( "Installation cancelled" ), oDlg:End() )

   ACTIVATE DIALOG oDlg CENTERED

   oWnd:End()

return nil

//----------------------------------------------------------------------------//

function SayBitmaps()

   local hDC := oWnd:GetDC()

   DrawBitmap( hDC, hBmpText1, 3, 3, 0, 0, SRCAND )
   DrawBitmap( hDC, hBmpText1, 0, 0, 0, 0, MERGEPAINT )

   DrawBitmap( hDC, hBmpText2, 433, 133, 0, 0, SRCAND )
   DrawBitmap( hDC, hBmpText2, 430, 130, 0, 0, MERGEPAINT )

   oWnd:ReleaseDC()

return nil

//----------------------------------------------------------------------------//

function FillBlue()

   local hWnd  := oWnd:hWnd
   local aRect := GetClientRect( hWnd )
   local oBrush
   local nTop    := aRect[ 1 ]
   local nBottom := aRect[ 3 ]
   local nBlue   := 200
   local nSteps  := ( aRect[ 3 ] - aRect[ 1 ] ) / 3
   local n

   oWnd:GetDC()

   aRect[ 3 ] = 0

   for n = 1 to nSteps

      aRect[ 3 ] += 3

      DEFINE BRUSH oBrush COLOR RGB( 0, 0, nBlue )
      FillRect( oWnd:hDC, aRect, oBrush:hBrush )
      RELEASE BRUSH oBrush

      aRect[ 1 ] += 3
      nBlue -= 1
   next

   oWnd:ReleaseDC()

return nil

//----------------------------------------------------------------------------//

function CopyFiles( lLib, lSamples, lInclude, lManual, lUtil, lSource )

   nPercent = 0 ; oMeter:Refresh() ; SysRefresh()
   cTarget = AllTrim( cTarget )

   if ! File( cTarget )
      lMkDir( cTarget )
      lMkDir( cTarget + "\Examples" )
      lMkDir( cTarget + "\Icons" )
      lMkDir( cTarget + "\IDE" )
      lMkDir( cTarget + "\lib" )
      lMkDir( cTarget + "\Manual" )
      lMkDir( cTarget + "\Source" )
   endif

   if lLib
      nPercent = 10 ; oMeter:Refresh() ; SysRefresh()
      LZCopyFile( "d:FiveWin.li_", cTarget + "\lib\FiveWin.lib" )
      nPercent = 20 ; oMeter:Refresh() ; SysRefresh()
      LZCopyFile( "d:WinApi.li_",  cTarget + "\lib\WinApi.lib" )
      nPercent = 30 ; oMeter:Refresh() ; SysRefresh()
      LZCopyFile( "d:501_520.li_", cTarget + "\lib\501_520.lib" )
      nPercent = 40 ; oMeter:Refresh() ; SysRefresh()
   endif

   if lManual
      LZCopyFile( "d:readme.tx_", cTarget + "\Readme.txt" )
      nPercent = 42 ; oMeter:Refresh() ; SysRefresh()
      LZCopyFile( "d:Fw16.hl_", cTarget + "\manual\Fw16.hlp" )
      nPercent = 52 ; oMeter:Refresh() ; SysRefresh()
   endif


return nil

//----------------------------------------------------------------------------//

function BuildGroup()

   local oDde

   DEFINE DDE oDde SERVICE "Progman" TOPIC "Progman"

   ACTIVATE DDE oDde

   oDde:Execute( "[DeleteGroup( FiveWin 1.6 )]" )
   oDde:Execute( "[CreateGroup( FiveWin 1.6 )]" )
   oDde:Execute( "[ShowGroup( FiveWin 1.6, 1 )]" )
   oDde:Execute( "[AddItem(" + cTarget + "\Readme.txt, Readme.txt )]" )
   oDde:Execute( "[AddItem(" + cTarget + "\manual\Fw16.hlp, Fw16.hlp )]" )
   oDde:Execute( "[AddItem(" + cTarget + "\ide\ide.exe, IDE, " + ;
                  cTarget + "\IDE\FwIde.ico )]" )

   oDde:Execute( "[AddItem( c:\command.com, MsDos, " + ;
                  cTarget + "\Icons\MsDos.ico,,,," + cTarget + ")]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor01.exe, Tutor01," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor02.exe, Tutor02," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor03.exe, Tutor03," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor04.exe, Tutor04," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor05.exe, Tutor05," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor06.exe, Tutor06," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor07.exe, Tutor07," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\Tutor08.exe, Tutor08," + ;
                  cTarget + "\icons\Tutor.ico )]" )

   oDde:Execute( "[AddItem(" + cTarget + "\examples\AllTest.bat, Build Examples," + ;
                  cTarget + "\icons\Build.ico,0,2,1 )]" )

   RELEASE DDE oDde

return nil

//----------------------------------------------------------------------------//
