#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TIni

   DATA   cIniFile

   METHOD New( cIniFile ) CONSTRUCTOR

   METHOD Get( cSection, cEntry, uDefault, uVar )

   METHOD Set( cSection, cEntry, uValue )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cIniFile ) CLASS TIni

   DEFAULT cIniFile := ""

   if ! Empty( cIniFile ) .and. At( ".", cIniFile ) == 0
      cIniFile += ".ini"
   endif

   ::cIniFile = cIniFile

return

//----------------------------------------------------------------------------//

METHOD Get( cSection, cEntry, uDefault, uVar ) CLASS TIni

   local cType := ValType( If( uDefault != nil, uDefault, uVar ) )

   if Empty( ::cIniFile )
      if cType == "N"
         uVar = GetProfInt( cSection, cEntry, uDefault )
      else
         uVar = GetProfString( cSection, cEntry, cValToChar( uDefault ) )
      endif
   else
      if cType == "N"
         uVar = GetPvProfInt( cSection, cEntry, uDefault, ::cIniFile )
      else
         uVar = GetPvProfString( cSection, cEntry, cValToChar( uDefault ),;
                                 ::cIniFile )
      endif
   endif

   ::Set( cSection, cEntry, uVar )

   do case
      case cType == "D"
           uVar = CToD( uVar )

      case cType == "L"
           uVar = ( Upper( uVar ) == ".T." )
   endcase

return uVar

//----------------------------------------------------------------------------//

METHOD Set( cSection, cEntry, uValue ) CLASS TIni

   if Empty( ::cIniFile )
      WriteProfString( cSection, cEntry, cValToChar( uValue ) )
   else
      WritePProString( cSection, cEntry, cValToChar( uValue ), ::cIniFile )
   endif

return nil

//----------------------------------------------------------------------------//
