#include "FiveWin.ch"

#define ID_BUILD    180
#define ID_MATH     190
#define ID_LOGICAL  195
#define ID_STRING   196
#define ID_DATE     197
#define ID_NAME     104
#define ID_PATH     105
#define ID_DBFS     106
#define ID_FIELDS   107
#define ID_DRIVER   150

#define ID_EXPTYPE  240
#define ID_LSTEXPR  250

#define TAB      Chr(9)

//----------------------------------------------------------------------------//

function IdxBuilder()

   local oDlg, oLbxFields
   local cIndex  := PadR( "*.ntx", 50 )
   local cDbf    := ""
   local cField  := ""
   local cDriver := "DbfNtx"

   DEFINE DIALOG oDlg RESOURCE "IdxBuilder"

   REDEFINE GET cIndex ID ID_NAME OF oDlg

   REDEFINE BUTTON ID ID_PATH OF oDlg ACTION cGetFile( "*.ntx", "Select Indexes path" )

   REDEFINE LISTBOX cDbf FILES "*.dbf" ID ID_DBFS OF oDlg ;
      ON CHANGE ShowFields( cDbf, oLbxFields )

   REDEFINE LISTBOX oLbxFields VAR cField ID ID_FIELDS OF oDlg

   REDEFINE BUTTON ID ID_MATH OF oDlg ;
      ACTION ExprSelect( "Math Expression",;
                         { "Abs()" + TAB + "Absolute value",;
                           "Int()" + TAB + "Int value",;
                           "<  Less than",;
                           ">  More than",;
                           "== Equal to",;
                           "<> Not equal to",;
                           "*", "/" } )

   REDEFINE BUTTON ID ID_LOGICAL OF oDlg ;
      ACTION ExprSelect( "Logical expression",;
                         { "()"  + TAB + "Grouping indicator",;
                           "AND" + TAB + ".and. expression",;
                           "OR"  + TAB + ".or.  expression",;
                           "NOT" + TAB + ".not. expression",;
                           "<"   + TAB + "Less than",;
                           ">"   + TAB + "More than",;
                           "=="  + TAB + "Equal to",;
                           "<>"  + TAB + "Not equal to" } )

   REDEFINE BUTTON ID ID_STRING OF oDlg ;
      ACTION ExprSelect( "Character expression",;
                         { "AllTrim()" + TAB + "Remove blanks",;
                           "Chr()"     + TAB + "Chr from ascii",;
                           "PadC()"    + TAB + "Fill center",;
                           "PadL()"    + TAB + "Fill left side",;
                           "PadR()"    + TAB + "Fill right side",;
                           "RTrim()"   + TAB + "Remove right blanks",;
                           "SubStr()"  + TAB + "Extract from",;
                           "==" + TAB + "Equal to",;
                           "<>" + TAB + "Not equal to" } )

   REDEFINE BUTTON ID ID_DATE OF oDlg ;
      ACTION ExprSelect( "Date expression",;
                         { "Date()" + TAB + "Today date",;
                           "DoM()"  + TAB + "Day of month",;
                           "DoW()"  + TAB + "Day of week",;
                           "/"  + TAB + "Divide" } )

   REDEFINE COMBOBOX cDriver ITEMS { "DbfNtx", "DbfCdx", "DbPdx" } ;
      ID ID_DRIVER OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

static function ExprSelect( cType, aSymbols )

   local oDlg
   local cExpr := ""

   DEFINE DIALOG oDlg RESOURCE "ExpBuilder"

   REDEFINE SAY PROMPT cType ID ID_EXPTYPE OF oDlg

   REDEFINE LISTBOX cExpr ITEMS aSymbols ID ID_LSTEXPR OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

static function ShowFields( cDbf, oLbx )

   local aFields
   local n

   USE ( cDbf )

   aFields = ( cDbf )->( DbStruct() )
   oLbx:Reset()

   for n = 1 to Len( aFields )
      oLbx:Add( PadR( aFields[ n ][ 1 ], 12 ) + TAB + ;
                aFields[ n ][ 2 ] + ;
                xPadL( Str( aFields[ n ][ 3 ], 3 ), 40 ) + ;
                xPadL( Str( aFields[ n ][ 4 ], 1 ), 20 ) )
   next

   USE

return nil

//----------------------------------------------------------------------------//
