#include "FiveWin.ch"

#define EM_GETSEL  (WM_USER+0)
#define EM_SETSEL  (WM_USER+1)

#define COLOR_WINDOW         5
#define COLOR_WINDOWTEXT     8

//----------------------------------------------------------------------------//

CLASS TGet FROM TControl

   DATA   oGet

   METHOD New( nRow, nCol, bSetGet, oWnd, nWidth, nHeight, cPict, bValid,;
               nClrFore, nClrBack, oFont, lDesign, oCursor ) CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, cPict, bValid,;
                    nClrFore, nClrBack, oFont, oCursor ) CONSTRUCTOR

   METHOD cToChar() INLINE Super:cToChar( "EDIT" )

   METHOD GotFocus() INLINE  Super:GotFocus(),;
                             ::oGet:SetFocus(),;
                             SetWindowText( ::hWnd, ::oGet:buffer )

   METHOD HandleEvent( nMsg, nWParam, nLParam )
   METHOD Init( hDlg )

   METHOD LostFocus() INLINE  Super:LostFocus(),;
                              ::oGet:Assign(),;     // for adjust numbers
                              SetWindowText( ::hWnd, ::oGet:buffer ),;
                              ::oGet:KillFocus()

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD cText( cText ) SETGET

   METHOD Refresh() INLINE ::oGet:SetFocus(),;
                           ::oGet:UpdateBuffer(),;
                           SetWindowText( ::hWnd, ::oGet:buffer )

   METHOD Save() INLINE ::oGet:Assign()

   METHOD GetSel()
   METHOD GetSelPos( @nStart, @nEnd )
   METHOD GetDelSel( nStart, nEnd )

   METHOD EditUpdate()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, bSetGet, oWnd, nWidth, nHeight, cPict, bValid,;
            nClrFore, nClrBack, oFont, lDesign, oCursor ) CLASS TGet

   DEFAULT nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           nClrBack := GetSysColor( COLOR_WINDOW ),;
           nHeight  := If( oFont != nil, oFont:nHeight, 11 ),;
           lDesign  := .f.

   ::cCaption = If( cPict == nil, cValToChar( Eval( bSetGet ) ), ;
                                  Transform( Eval( bSetGet ), cPict ) )
   ::nTop     = nRow * 13
   ::nLeft    = nCol * 8
   ::nBottom  = ::nTop + nHeight
   ::nRight   = ::nLeft + If( nWidth == nil, ( 1 + Len( ::cCaption ) ) * 3.5, ;
                                               nWidth )
   ::oWnd      = oWnd
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE, WS_BORDER, WS_TABSTOP, ES_LEFT,;
                      ES_AUTOHSCROLL, If( lDesign, WS_THICKFRAME, 0 ) )
   ::nId       = ::GetNewId()
   ::oGet      = GetNew( 5000, 5000, bSetGet,, cPict )
   ::bValid    = bValid
   ::lDrag     = lDesign
   ::lCaptured = .f.
   ::oFont     = oFont
   ::oCursor   = oCursor

   ::SetColor( nClrFore, nClrBack )

   ::oGet:SetFocus()
   ::cCaption = ::oGet:Buffer
   ::oGet:KillFocus()

   if oWnd:lVisible
      ::Create( "EDIT" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, cPict, bValid, nClrFore,;
                 nClrBack, oFont, oCursor ) CLASS TGet

   DEFAULT nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           nClrBack := GetSysColor( COLOR_WINDOW )

   ::nId       = nId
   ::oWnd      = oWnd
   ::nHelpId   = nHelpId
   ::oGet      = GetNew( 5000, 5000, bSetGet,, cPict )
   ::bValid    = bValid
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::oFont     = oFont
   ::oCursor   = oCursor

   ::SetColor( nClrFore, nClrBack )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TGet

   Super:Init( hDlg )
   ::oGet:SetFocus()
   SetWindowText( ::hWnd, ::oGet:buffer )
   ::oGet:KillFocus()

return nil

//---------------------------------------------------------------------------//
 // Actualiza texto y y posicin del cursor del EDIT en funcin del oGet.
 // Updates the text and the EDIT cursor position depending the oGet

METHOD EditUpdate() CLASS TGet

   if ::oGet:HasFocus
      SetWindowText( ::hWnd, ::oGet:buffer )
   endif

   CallWindowProc( ::nOldProc, ::hWnd, EM_SETSEL, 0, ;
                   nMakeLong( ::oGet:pos - 1, ::oGet:pos - 1 ) )

return nil

//---------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TGet

   static nCaretCol := 0
   local nHi, nLo

   do case
      case nMsg == WM_PAINT
           return nil

      case nMsg == WM_LBUTTONDOWN
           if ::lDrag
              return Super:HandleEvent( nMsg, nWParam, nLParam )
           else
              CallWindowProc( ::nOldProc, ::hWnd, nMsg, nWParam, nLParam )
              nCaretCol = GetCaretPos()[ 1 ]
              return 1
           endif

      case nMsg == WM_LBUTTONUP
           if ::lDrag
              return Super:HandleEvent( nMsg, nWParam, nLParam )
           else
              ::GetSelPos( @nLo, @nHi )
              ::oGet:pos = If( nCaretCol <= GetCaretPos()[ 1 ], nHi, nLo ) + 1
           endif
                   
      case nMsg == WM_KEYUP
           // Paste from clipboard
           if nWParam == VK_INSERT .and. GetKeyState( VK_SHIFT )
               ::oGet:buffer = GetWindowText( ::hWnd )
               ::oGet:pos    = nHiWord( ::SendMsg( EM_GETSEL ) ) + 1
           elseif nWParam == VK_UP .or. nWParam == VK_DOWN
               return 1  // We have not processed the key and we don't let
                         // the edit to do it
           endif

      case nMsg == WM_KEYDOWN
           do case
              case nWParam == VK_F1
                   HelpTopic( ::nHelpId )

              case nWParam == VK_UP .or. nWParam == VK_DOWN
                   ::oWnd:FocusNext( ::hWnd, nWParam == VK_UP )
                   return 1  // We have not processed the key and we
                             // don't let the edit to do it

              case nWParam == VK_LEFT
                   if GetKeyState( VK_CONTROL )
                      ::oGet:wordLeft()
                   else
                      ::oGet:left()
                   endif

              case nWParam == VK_RIGHT
                   if GetKeyState( VK_CONTROL )
                      ::oGet:wordRight()
                   else
                      ::oGet:right()
                   endif

              case nWParam == VK_DELETE

                   ::GetSelPos( @nLo, @nHi )

                   // Deletes selection
                   if nHi != nLo

                      ::GetDelSel( nLo, nHi )

                      if GetKeyState( VK_SHIFT )
                         CallWindowProc( ::nOldProc, ::hWnd, nMsg, nWParam, nLParam )
                      endif

                   else
                      ::oGet:Delete()
                   endif

                   ::EditUpdate()

                   return 1

              case nWParam == VK_HOME
                   ::oGet:Home()

              case nWParam == VK_END
                   ::oGet:End()
                   ::EditUpdate()
                   return 1

           endcase
           
           return nil

      case nMsg == WM_CHAR

           do case
              case nWParam == VK_BACK
                   ::oGet:backSpace()
                   ::EditUpdate()

              case nWParam >= 32 .or. nWParam < 256
                   ::GetSelPos( @nLo, @nHi )

                   // Borrar seleccin.
                   if nHi != nLo
                      ::GetDelSel( nLo, nHi )

                      ::EditUpdate()

                   endif

                   ::oGet:insert( chr( nWParam ) )
                   if ::oGet:rejected()
                      MessageBeep( -1 )
                   else
                      ::EditUpdate()
                   endif
              otherwise
                   return nil
           endcase

           return 1
       endcase

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//

METHOD cText( uVal ) CLASS TGet

   if PCount() == 1      // OJO Con Objects 2.0 PCount() es PCount() + 1
      ::oGet:VarPut( uVal )
      ::Refresh()
   endif

return GetWindowText( ::hWnd )

//----------------------------------------------------------------------------//

METHOD GetSel() CLASS TGet

   local n      := ::SendMsg( EM_GETSEL )
   local nStart := nLoWord( n )
   local nEnd   := nHiWord( n )

return If( nStart != nEnd, SubStr( ::cText, nStart, nEnd - nStart + 1 ), "" )

//----------------------------------------------------------------------------//

METHOD GetSelPos( nStart, nEnd ) CLASS TGet

   local n := ::SendMsg( EM_GETSEL )
   nStart  := nLoWord( n )
   nEnd    := nHiWord( n )

return nil

//----------------------------------------------------------------------------//

METHOD GetDelSel( nStart, nEnd ) CLASS TGet

   ::oGet:buffer = Left( ::oGet:buffer, Min( nEnd, nStart ) ) ;
                   + Right( ::oGet:buffer, ;
                            Len( ::oGet:buffer ) - Max( nEnd, nStart ) ) ;
                   + Space( Abs( nStart - nEnd ) )

   ::oGet:Assign()
   ::oGet:Reset()
   ::oGet:pos := Min( nStart, nEnd ) + 1

return nil

//---------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TGet

   if ::lDrag
      return Super:MouseMove( nRow, nCol, nKeyFlags )
   else
      if ::oCursor != nil
         SetCursor( ::oCursor:hCursor )
      else
         CursorIBeam()
      endif
   endif

return nil      // We want standard Get behavior !!!

//---------------------------------------------------------------------------//
