// FiveWin main Header File

#ifndef _FIVEWIN_CH
#define _FIVEWIN_CH

#define FWVERSION   "FiveWin 1.6 - May 1994"
#define FWCOPYRIGHT OemToAnsi( "(c) Antonio Linares & Francisco Pulpn, 1993-4" )

#include "Colors.ch"
#include "Window.ch"
#include "Brush.ch"
#include "Dbf.ch"
#include "DDE.ch"
#include "Dialog.ch"
#include "DLL.ch"
#include "Font.ch"
#include "Icon.ch"
#include "Ini.ch"
#include "Menu.ch"
#include "Objects.ch"
#include "ODBC.ch"
#include "Print.ch"
#include "Timer.ch"
#include "Tree.ch"
#include "Video.ch"
#include "VKey.ch"
#include "WinApi.ch"
#include "Meter.ch"

#define CRLF Chr(13)+Chr(10)

//----------------------------------------------------------------------------//
// ACCESSING / SETTING Variables

#xtranslate bSETGET(<uVar>) => ;
            { | u | If( PCount() == 0, <uVar>, <uVar> := u ) }

//----------------------------------------------------------------------------//

#xcommand DEFAULT <uVar1> := <uVal1> ;
               [, <uVarN> := <uValN> ] => ;
                  <uVar1> := If( <uVar1> == nil, <uVal1>, <uVar1> ) ;;
                [ <uVarN> := If( <uVarN> == nil, <uValN>, <uVarN> ); ]

//----------------------------------------------------------------------------//
// DO ... UNTIL support

#xcommand DO            => while .t.
#xcommand UNTIL <uExpr> => if <uExpr>; exit; end; end

//----------------------------------------------------------------------------//
// PUSHBUTTON

#xcommand @ <nRow>, <nCol> BUTTON [ <oBtn> PROMPT ] <cCaption> ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ ACTION <uAction> ] ;
             [ <default: DEFAULT> ] ;
             [ <of:OF, WINDOW, DIALOG> <oWnd> ] ;
             [ <help:HELP, HELPID, HELP ID> <nHelpId> ] ;
             [ FONT <oFont> ] ;
             [ <pixel: PIXEL> ] ;
             [ <design: DESIGN> ] ;
      => ;
         [ <oBtn> := ] TButton():New( <nRow>, <nCol>, <cCaption>, <oWnd>,;
            <{uAction}>, <nWidth>, <nHeight>, <nHelpId>, <oFont>, <.default.>,;
            <.pixel.>, <.design.> )

#xcommand REDEFINE BUTTON [ <oBtn> ] ;
             [ ID <nId> <of:OF, WINDOW, DIALOG> <oDlg> ] ;
             [ ACTION <uAction> ] ;
             [ <help:HELP, HELPID, HELP ID> <nHelpId> ] ;
       => ;
          [ <oBtn> := ] TButton():ReDefine( <nId>, <{uAction}>, <oDlg>,;
             <nHelpId> )

//----------------------------------------------------------------------------//
// CHECKBOX

#xcommand REDEFINE CHECKBOX [ <oCbx> VAR ] <lVar> ;
             [ ID <nId> ] ;
             [ <of:OF, WINDOW, DIALOG> <oWnd> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ <click:ON CLICK, ON CHANGE> <uClick> ];
             [ VALID   <ValidFunc> ]       ;
             [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
       => ;
          [ <oCbx> := ] TCheckBox():ReDefine( <nId>, bSETGET(<lVar>),;
             <oWnd>, <nHelpId>, [<{uClick}>], <{ValidFunc}>, <nClrFore>,;
             <nClrBack>  )

#xcommand @ <nRow>, <nCol> CHECKBOX [ <oCbx> VAR ] <lVar> ;
             [ PROMPT <cCaption> ] ;
             [ <of:OF, WINDOW, DIALOG> <oWnd> ] ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ; 
             [ FONT <oFont> ] ;
             [ ON CLICK <uClick> ] ;
             [ VALID   <ValidFunc> ] ;
             [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
      => ;
         [ <oCbx> := ] TCheckBox():New( <nRow>, <nCol>, <cCaption>,;
             [bSETGET(<lVar>)], <oWnd>, <nWidth>, <nHeight>, <nHelpId>,;
             [<{uClick}>], <oFont>, <{ValidFunc}>, <nClrFore>, <nClrBack> )

//----------------------------------------------------------------------------//
// COMBOBOX

#xcommand @ <nRow>, <nCol> COMBOBOX [ <oCbx> VAR ] <cVar> ;
             [ ITEMS <aItems> ] ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ <dlg:OF,WINDOW,DIALOG> <oWnd> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ ON CHANGE <uChange> ] ;
             [ VALID   <ValidFunc> ] ;
             [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
       => ;
          [ <oCbx> := ] TComboBox():New( <nRow>, <nCol>, bSETGET(<cVar>),;
             <aItems>, <nWidth>, <nHeight>, <oWnd>, <nHelpId>,;
             [{|Self|<uChange>}], <{ValidFunc}>, <nClrText>, <nClrBack> )

#xcommand REDEFINE COMBOBOX [ <oCbx> VAR ] <cVar> ;
             [ ITEMS <aItems> ] ;
             [ ID <nId> ] ;
             [ <dlg:OF,WINDOW,DIALOG> <oWnd> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ ON CHANGE <uChange> ] ;
             [ VALID   <ValidFunc> ]       ;
             [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
       => ;
          [ <oCbx> := ] TComboBox():ReDefine( <nId>, bSETGET(<cVar>),;
             <aItems>, <oWnd>, <nHelpId>, <{ValidFunc}>, [{|Self|<uChange>}],;
             <nClrText>, <nClrBack> )

//----------------------------------------------------------------------------//
// LISTBOX

#xcommand REDEFINE LISTBOX [ <oLbx> VAR ] <cVar> ;
             [ ITEMS <aItems> ]  ;
             [ FILES <cFileSpec> ] ;
             [ ID <nId> ] ;
             [ ON CHANGE <uChange> ] ;
             [ <of: OF, WINDOW, DIALOG > <oWnd> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ <bitmaps: BITMAPS > [ SIZE <nSize> ] ] ;
             [ VALID   <ValidFunc> ]       ;
             [ <color: COLOR,COLORS> <nClrFore> [,<nClrBack>] ] ;
       => ;
          [ <oLbx> := ] TListBox():ReDefine( <nId>, bSETGET(<cVar>), <aItems>,;
             <{uChange}>, <oWnd>, <nHelpId>, <.bitmaps.>, <nSize>, ;
             <{ValidFunc}>, <cFileSpec>, <nClrFore>, <nClrBack> )

#xcommand @ <nRow>, <nCol> LISTBOX [ <oLbx> VAR ] <cVar> ;
             [ ITEMS <aList>  ] ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ ON CHANGE <uChange> ] ;
             [ <of: OF, WINDOW, DIALOG > <oWnd> ] ;
             [ VALID   <ValidFunc> ]       ;
             [ <color: COLOR,COLORS> <nClrFore> [,<nClrBack>] ] ;
             [ <pixel: PIXEL> ] ;
             [ <design: DESIGN> ] ;
       => ;
          [ <oLbx> := ] TListBox():New( <nRow>, <nCol>, bSETGET(<cVar>),;
             <aList>, <nWidth>, <nHeight>, <{uChange}>, <oWnd>, <{ValidFunc}>,;
             <nClrFore>, <nClrBack>, <.pixel.>, <.design.> )

//----------------------------------------------------------------------------//
// LISTBOX - BROWSE

// Warning: SELECT <cField>  ==> Must be the Field key of the current INDEX !!!

#xcommand REDEFINE LISTBOX [ <oLbx> ] FIELDS [<Flds,...>] ;
             [ ID <nId> ] ;
             [ <dlg:OF,DIALOG> <oDlg> ] ;
             [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
             [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
             [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
             [ <change: ON CHANGE, ON CLICK> <uChange> ] ;
             [ ON [ LEFT ] DBLCLICK <uLDblClick> ] ;
             [ ON RIGHT CLICK <uRClick> ] ;
             [ FONT <oFont> ] ;
             [ CURSOR <oCursor> ] ;
             [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
       => ;
              [ <oLbx> := ] TWBrowse():ReDefine( <nId>, ;
              [\{|| \{ <Flds> \} \}], <oDlg>,;
              [ \{<aHeaders>\}], [\{<aColSizes>\}],;
              <(cField)>, <uValue1>, <uValue2>,;
              [<{uChange}>], [<{uLDblClick}>], [<{uRClick}>], <oFont>,;
              <oCursor>, <nClrFore>, <nClrBack> )

#xcommand @ <nRow>, <nCol> LISTBOX [ <oBrw> ] FIELDS [<Flds,...>] ;
                           [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
                           [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
                           [ SIZE <nWidth>, <nHeigth> ] ;
                           [ <dlg:OF,DIALOG> <oDlg> ] ;
                           [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
                           [ <change: ON CHANGE, ON CLICK> <uChange> ] ;
                           [ ON [ LEFT ] DBLCLICK <uLDblClick> ] ;
                           [ ON RIGHT CLICK <uRClick> ] ;
                           [ FONT <oFont> ] ;
                           [ CURSOR <oCursor> ] ;
                           [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
      => ;
          [ <oBrw> := ] TWBrowse():New( <nRow>, <nCol>, <nWidth>, <nHeigth>,;
                           [\{|| \{<Flds> \} \}], ;
                           [ \{<aHeaders>\}], [\{<aColSizes>\}], ;
                           <oDlg>, <(cField)>, <uValue1>, <uValue2>,;
                           [<{uChange}>], [<{uLDblClick}>], [<{uRClick}>],;
                           <oFont>, <oCursor>, <nClrFore>, <nClrBack> )

//----------------------------------------------------------------------------//
// RADIOBUTTONS

#xcommand @ <nRow>, <nCol> RADIO [ <oRadMenu> VAR ] <nVar> ;
             [ PROMPT <cItems,...> ] ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ; 
             [ <change: ON CLICK, ON CHANGE> <uChange> ] ;
             [ COLOR <nClrFore> [,<nClrBack>] ] ;
       => ;
          [ <oRadMenu> := ] TRadMenu():New( <nRow>, <nCol>, {<cItems>},;
             [bSETGET(<nVar>)], <oWnd>, <nHelpId>, <{uChange}>,;
             <nClrFore>, <nClrBack> )

#xcommand REDEFINE RADIO [ <oRadMenu> VAR ] <nVar> ;
             [ ID <nId,...> ] ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ <change: ON CLICK, ON CHANGE> <uChange> ] ;
             [ COLOR <nClrFore> [,<nClrBack>] ] ;
       => ;
          [ <oRadMenu> := ] TRadMenu():Redefine( [bSETGET(<nVar>)],;
             <oWnd>, <nHelpId>, \{ <nId> \}, <{uChange}>, <nClrFore>,;
             <nClrBack> )

//----------------------------------------------------------------------------//
// BITMAP

#xcommand @ <nRow>, <nCol> BITMAP [ <oBmp> ] ;
             [ <resource: NAME, RESNAME, RESOURCE> <cResName> ] ;
             [ <file: FILE, FILENAME, DISK> <cBmpFile> ] ;
             [ <NoBorder:NOBORDER, NO BORDER> ] ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
             [ <lClick: ON CLICK, ON LEFT CLICK> <uLClick> ] ;
             [ <rClick: ON RIGHT CLICK> <uRClick> ] ;
             [ <scroll: SCROLL> ] ;
             [ <adjust: ADJUST> ] ;
             [ CURSOR <oCursor> ] ;
       => ;
          [ <oBmp> := ] TBitmap():New( <nRow>, <nCol>, <nWidth>, <nHeight>,;
             <cResName>, <cBmpFile>, <.NoBorder.>, <oWnd>,;
             [\{ |nRow,nCol,nKeyFlags| <uLClick> \} ],;
             [\{ |nRow,nCol,nKeyFlags| <uRClick> \} ], <.scroll.>,;
             <.adjust.>, <oCursor> )

#xcommand REDEFINE BITMAP [ <oBmp> ] ;
             [ ID <nId> ] ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
             [ <resource: NAME, RESNAME, RESOURCE> <cResName> ] ;
             [ <file: FILE, FILENAME, DISK> <cBmpFile> ] ;
             [ <lClick: ON ClICK, ON LEFT CLICK> <uLClick> ] ;
             [ <rClick: ON RIGHT CLICK> <uRClick> ] ;
             [ <scroll: SCROLL> ] ;
             [ <adjust: ADJUST> ] ;
             [ CURSOR <oCursor> ] ;
       => ;      
          [ <oBmp> := ] TBitmap():ReDefine( <nId>, <cResName>, <cBmpFile>,;
             <oWnd>, [\{ |nRow,nCol,nKeyFlags| <uLClick> \}],;
                     [\{ |nRow,nCol,nKeyFlags| <uRClick> \}],;
             <.scroll.>, <.adjust.>, <oCursor> )

//----------------------------------------------------------------------------//
// SAY

#xcommand REDEFINE SAY [ <oSay> ] ;
             [ PROMPT <cText> ] ;
             [ PICTURE <cPict> ] ;
             [ ID <nId> ] ;
             [ <dlg:OF,WINDOW,DIALOG> <oWnd> ] ;
             [ <lCenter: CENTERED > ]  ;
             [ <lBorder: BORDER> ]  ;
             [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
       => ;
          [ <oSay> := ] TSay():ReDefine( <nId>, <cText>, <oWnd>, ;
             <cPict>, <.lCenter.>, <.lBorder.>, <nClrText>, <nClrBack> )

#xcommand @ <nRow>, <nCol> SAY [ <oSay> PROMPT ]  <cText> ;
             [ PICTURE <cPict> ] ;
             [ <dlg:OF,WINDOW,DIALOG> <oWnd> ] ;
             [ FONT <oFont> ]  ;
             [ <lCenter: CENTERED > ]  ;
             [ <lBorder: BORDER> ]  ;
             [ <lPixel: PIXEL, PIXELS> ] ;
             [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ <design: DESIGN> ] ;
      => ;
          [ <oSay> := ] TSay():New( <nRow>, <nCol>, <cText>,;
             [<oWnd>], [<cPict>], <oFont>, <.lCenter.>, <.lBorder.>,;
             <.lPixel.>, <nClrText>, <nClrBack>, <nWidth>, <nHeight>,;
             <.design.> )

//----------------------------------------------------------------------------//
// GET

#xcommand REDEFINE GET [ <oGet> VAR ] <uVar> ;
             [ <memo: MULTILINE, MEMO, TEXT> ] ;
             [ ID <nId> ] ;
             [ <dlg: OF, WINDOW, DIALOG> <oDlg> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ <color: COLOR,COLORS> <nClrFore> [,<nClrBack>] ] ;
             [ FONT <oFont> ] ;
             [ CURSOR <oCursor> ] ;
       => ;
          [ <oGet> := ] TMultiGet():ReDefine( <nId>, bSETGET(<uVar>),;
             <oDlg>, <nHelpId>, <nClrFore>, <nClrBack>, <oFont>, <oCursor> )

#xcommand REDEFINE GET [ <oGet> VAR ] <uVar> ;
             [ ID <nId> ] ;
             [ <dlg: OF, WINDOW, DIALOG> <oDlg> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ VALID   <ValidFunc> ]       ;
             [ PICTURE <cPict> ] ;
             [ <color:COLOR,COLORS> <nClrFore> [,<nClrBack>] ] ;
             [ FONT <oFont> ] ;
             [ CURSOR <oCursor> ] ;
       => ;
          [ <oGet> := ] TGet():ReDefine( <nId>, bSETGET(<uVar>), <oDlg>,;
             <nHelpId>, <cPict>, <{ValidFunc}>, <nClrFore>, <nClrBack>,;
             <oFont>, <oCursor> )

#command @ <nRow>, <nCol> GET [ <oGet> VAR ] <uVar> ;
                          [ <dlg: OF, WINDOW, DIALOG> <oWnd> ] ;
                          [ <memo: MULTILINE, MEMO, TEXT> ] ;
                          [ <color:COLOR,COLORS> <nClrFore> [,<nClrBack>] ] ;
                          [ SIZE <nWidth>, <nHeight> ] ;
                          [ FONT <oFont> ] ;
                          [ <hscroll: HSCROLL> ] ;
                          [ CURSOR <oCursor> ] ;
       => ;
          [ <oGet> := ] TMultiGet():New( <nRow>, <nCol>, bSETGET(<uVar>),;
                            [<oWnd>], <nWidth>, <nHeight>, <oFont>, <.hscroll.>,;
                            <nClrFore>, <nClrBack>, <oCursor> )

#command @ <nRow>, <nCol> GET [ <oGet> VAR ] <uVar>     ;
                          [ <dlg: OF, WINDOW, DIALOG> <oWnd> ] ;
                          [ PICTURE <cPict> ]           ;
                          [ VALID   <ValidFunc> ]       ;
                          [ WHEN    <WhenFunc> ]        ;
                          [ <color:COLOR,COLORS> <nClrFore> [,<nClrBack>] ] ;
                          [ SIZE <nWidth>, <nHeight> ]  ;
                          [ FONT <oFont> ] ;
                          [ <design: DESIGN> ] ;
                          [ CURSOR <oCursor> ] ;
       => ;
          [ <oGet> := ] TGet():New( <nRow>, <nCol>, bSETGET(<uVar>),;
                      [<oWnd>], <nWidth>, <nHeight>, <cPict>, <{ValidFunc}>,;
                      <nClrFore>, <nClrBack>, <oFont>, <.design.>,;
                      <oCursor> )

//----------------------------------------------------------------------------//
// SCROLLBAR

#xcommand @ <nRow>, <nCol> SCROLLBAR [ <oSbr> ] ;
             [ <h: HORIZONTAL> ] ;
             [ <v: VERTICAL> ] ;
             [ RANGE <nMin>, <nMax> ] ;
             [ PAGESTEP <nPgStep> ] ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ <up:UP, ON UP> <uUpAction> ] ;
             [ <dn:DOWN, ON DOWN> <uDownAction> ] ;
             [ <pgup:PAGEUP, ON PAGEUP> <uPgUpAction> ] ;
             [ <pgdn:PAGEDOWN, ON PAGEDOWN> <uPgDownAction> ] ;
             [ <pos: ON THUMBPOS> <uPos> ] ;
             [ <pixel: PIXEL> ] ;
             [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
             [ OF <oWnd> ] ;
       => ;
          [ <oSbr> := ] TScrollBar():New( <nRow>, <nCol>, <nMin>, <nMax>, <nPgStep>,;
             (.not.<.h.>) [.or. <.v.> ], <oWnd>, <nWidth>, <nHeight> ,;
             [<{uUpAction}>], [<{uDownAction}>], [<{uPgUpAction}>], ;
             [<{uPgDownAction}>], [\{|nPos| <uPos> \}], [<.pixel.>],;
             <nClrText>, <nClrBack> )

// for 'non-true ScrollBars' ( when using WS_VSCROLL or WS_HSCROLL styles )

#xcommand DEFINE SCROLLBAR [ <oSbr> ] ;
             [ <h: HORIZONTAL> ] ;
             [ <v: VERTICAL> ] ;
             [ RANGE <nMin>, <nMax> ] ;
             [ PAGESTEP <nPgStep> ] ;
             [ <up:UP, ON UP> <uUpAction> ] ;
             [ <dn:DOWN, ON DOWN> <uDownAction> ] ;
             [ <pgup:PAGEUP, ON PAGEUP> <uPgUpAction> ] ;
             [ <pgdn:PAGEDOWN, ON PAGEDOWN> <uPgDownAction> ] ;
             [ <pos: ON THUMBPOS> <uPos> ] ;
             [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
       => ;
             [ <oSbr> := ] TScrollBar():WinNew( <nMin>, <nMax>, <nPgStep>, ;
             (.not.<.h.>) [.or. <.v.> ], <oWnd>, [<{uUpAction}>],;
             [<{uDownAction}>], [<{uPgUpAction}>], ;
             [<{uPgDownAction}>], [\{|nPos| <uPos> \}],;
             <nClrText>, <nClrBack> )

#xcommand REDEFINE SCROLLBAR [ <oSbr> ] ;
             [ ID <nID>  ] ;
             [ RANGE <nMin>, <nMax> ] ;
             [ PAGESTEP <nPgStep> ] ;
             [ <up:UP, ON UP> <uUpAction> ] ;
             [ <dn:DOWN, ON DOWN> <uDownAction> ] ;
             [ <pgup:PAGEUP, ON PAGEUP> <uPgUpAction> ] ;
             [ <pgdn:PAGEDOWN, ON PAGEDOWN> <uPgDownAction> ] ;
             [ <pos: ON THUMBPOS> <uPos> ] ;
             [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
             [ OF <oDlg> ] ;
       => ;
             [ <oSbr> := ] TScrollBar():Redefine( <nID>, <nMin>, <nMax>, <nPgStep>,;
             <oDlg>, [<{uUpAction}>], [<{uDownAction}>], [<{uPgUpAction}>], ;
             [<{uPgDownAction}>], [\{|nPos| <uPos> \}], <nClrText>, <nClrBack> )

//----------------------------------------------------------------------------//
// BOX - GROUPS

#xcommand @ <nTop>, <nLeft> [ GROUP <oGroup> ] TO <nBottom>, <nRight > ;
             [ <label:LABEL,PROMPT> <cLabel> ] ;
             [ OF <oWnd> ] ;
             [ COLOR <nClrFore> [,<nClrBack>] ] ;
       => ;
          [ <oGroup> := ] TGroup():New( <nTop>, <nLeft>, <nBottom>, <nRight>,;
             <cLabel>, <oWnd>, <nClrFore>, <nClrBack> )

#xcommand REDEFINE GROUP [ <oGroup> ] ;
             [ <label:LABEL,PROMPT> <cLabel> ] ;
             [ ID <nId> ] ;
             [ <of: OF, WINDOW, DIALOG> <oWnd> ] ;
             [ COLOR <nClrFore> [,<nClrBack>] ] ;
       => ;
          [ <oGroup> := ] TGroup():ReDefine( <nId>, <cLabel>, <oWnd>,;
             <nClrFore>, <nClrBack> )

//----------------------------------------------------------------------------//
// CLIPBOARD

#xcommand DEFINE CLIPBOARD <oClp> ;
             [ FORMAT <format:TEXT,OEMTEXT,BITMAP,DIF> ] ;
             [ OF <oWnd> ] ;
       => ;
          <oClp> := TClipBoard():New( [Upper(<(format)>)], <oWnd> )

#xcommand ACTIVATE CLIPBOARD <oClp>  => <oClp>:Open()

#xcommand SET TEXT OF CLIPBOARD <oClp> ;
             TO <cText> ;
       => ;
          <oClp>:SetText( <cText> )

#xcommand DEACTIVATE CLIPBOARD <oClp>   => <oClp>:Close()

#xcommand RELEASE CLIPBOARD <oClp>      => <oClp>:Close(); <oClp> := nil

//----------------------------------------------------------------------------//
// Visual Basic VBX Controls Support

#xcommand REDEFINE VBX [<oControl>] ;
             [ ID <nId> ] ;
             [ OF <oDlg> ] ;
       => ;
          [ <oControl> := ] TVbControl():ReDefine( <nId>, <oDlg> )

//----------------------------------------------------------------------------//
// Commands & functions not supported

#xcommand CLS =>

#xcommand CLEAR SCREEN =>

#xcommand READ =>

#xcommand InKey( [<nTime>] ) => ;
   MsgAlert( OemToAnsi( "InKey() not available in FiveWin" ) )

#xcommand KEYBOARD <cChars> =>

#xcommand __KeyBoard( <cChars> ) => ;
   MsgAlert( OemToAnsi( "__KeyBoard() not available in FiveWin" ) )

#xcommand SET KEY <nKey> TO <*func*> =>

#xcommand SAVE SCREEN [ TO <u> ] =>

#xcommand RESTORE SCREEN [ FROM <u> ] =>

#xcommand SaveScreen( <*u*> ) => ;
   MsgAlert( OemToAnsi( "SaveScreen() not available in FiveWin" ) )

#xcommand RestScreen( <*u*> ) => ;
   MsgAlert( OemToAnsi( "RestScreen() not available in FiveWin" ) )

#xcommand @ <nRow>, <nCol> PROMPT <*u*> =>

#xcommand MENU TO <u> =>

#command ? [ <list,...> ] => WQout( [ \{ <list> \} ] )

#command ?? [ <list,...> ] => WQout( [ \{ <list> \} ] )

#endif
