/*************
*   Errsysw.prg
*   From Standard Clipper 5.0 error handler
*	Compile:  /m/n/w
*/

#include "error.ch"
#include "FiveWin.ch"

external _fwGenError   // Link FiveWin generic Error Objects Generator

#define NTRIM(n)		( LTrim(Str(n)) )

/*************
*	ErrorSys()
*
*	Note:  automatically executes at startup
*/
proc ErrorSys()
    ErrorBlock( { | e | ErrorDialog( e ) } )
return


/*************
*   ErrorDialog()
*/
static func ErrorDialog( e ) // -> logical  or quits App.

   local oDlg, oLbx
   local lRet    // if lRet == nil -> default action: QUIT
   local i, cMessage, aStack := {}
   local oSay, hLogo := FWBitMap()
   local nButtons := 1

   

   // by default, division by zero yields zero
   if ( e:genCode == EG_ZERODIV )
       return (0)
   end


   // for network open error, set NETERR() and subsystem default
   if ( e:genCode == EG_OPEN .and. e:osCode == 32 .and. e:canDefault )

       NetErr(.t.)
       return .f.       // Warning: Exiting!

   end


   // for lock error during APPEND BLANK, set NETERR() and subsystem default
   if ( e:genCode == EG_APPENDLOCK .and. e:canDefault )

       NetErr(.t.)
       return .f.       // OJO SALIDA

   endif

   if e:canRetry
      nButtons++
   endif

   if e:canDefault
      nButtons++
   endif


   // build error message
   cMessage := ErrorMessage(e)


   i := 2
   while ( i < 74 )

       if !Empty(ProcName(i))
          AAdd( aStack, "Called from " + Trim(ProcName(i)) + ;
                        "(" + NTRIM(ProcLine(i)) + ")" )
       endif

       i++
   end

   DEFINE DIALOG oDlg FROM 0, 0 TO 20, 58 ;
      TITLE OemToAnsi( FWVERSION + " ERROR Window" )

   @ 0, 0 SAY oSay PROMPT OemToAnsi( cMessage ) CENTERED BORDER OF oDlg

   oSay:nTop     = 10
   oSay:nLeft    = 21
   oSay:nBottom  = 36
   oSay:nRight   = 206

   @ 3,  3 SAY "&Stack List" OF oDlg

   i = aStack[ 1 ]

   @ 4, 2 LISTBOX oLbx VAR i ITEMS aStack OF oDlg SIZE 193, 72

   oLbx:nTop  -= 5
   oLbx:nLeft += 3

   @ 11, if( nButtons > 1, 3, 13 ) BUTTON "&Quit"     OF oDlg ACTION oDlg:End() ;
                                           SIZE 40, 12
   if e:canRetry
      @ 11, if( nButtons == 2, 24, 13 ) BUTTON "&Retry"    OF oDlg ACTION ( lRet  := .t., oDlg:End() ) ;
                                        SIZE 40, 12
   endif

   if e:canDefault
      @ 11, 24 BUTTON "&Default"  OF oDlg ACTION ( lRet  := .f., oDlg:End() ) ;
                                        SIZE 40, 12
   endif

   ACTIVATE DIALOG oDlg CENTERED ;
      ON PAINT ( DrawBitmap( oDlg:hDC, hLogo, 34, 4 ),;
                 DrawBitmap( oDlg:hDC, hLogo, 34, 420 ) )

   DeleteObject( hLogo )

   if lRet == nil .or. ( !LWRunning() .and. lRet )
      SET RESOURCES TO
      ErrorLevel(1)
      QUIT              // OJO QUIT
   endif

return lRet


/*************
*	ErrorMessage()
*/
static func ErrorMessage(e)

	// start error message
    local cMessage := if( empty( e:osCode ), ;
                          if( e:severity > ES_WARNING, "Error ", "Warning " ),;
                          "(DOS Error " + NTRIM(e:osCode) + ") " )

	// add subsystem name if available
    cMessage += if( ValType( e:subsystem ) == "C",;
                    e:subsystem()                ,;
                    "???" )

	// add subsystem's error code if available
    cMessage += if( ValType( e:subCode ) == "N",;
                    "/" + NTRIM( e:subCode )   ,;
                    "/???" )
	// add error description if available
	if ( ValType(e:description) == "C" )
        cMessage += "  " + e:description
	end

	// add either filename or operation
    cMessage += if( !Empty( e:filename ),;
                    ": " + e:filename   ,;
                    if( !Empty( e:operation ),;
                        ": " + e:operation   ,;
                        "" ) )
return cMessage
