#ifndef _DIALOG_CH
#define _DIALOG_CH

//----------------------------------------------------------------------------//
// Microsoft 3D Look

#xcommand SET <look_3d: 3DLOOK, LOOK3D, LOOK 3D, 3D LOOK> <on:ON,OFF,&> => ;
          Set3DLook( Upper(<(on)>) == "ON" )

//----------------------------------------------------------------------------//
// Resources

#xcommand SET RESOURCES TO <cName1> [,<cName2>] ;
       => ;
          [ SetResources( <cName2> ); ] SetResources( <cName1> )

#xcommand SET RESOURCES TO => FreeResources()

//----------------------------------------------------------------------------//

#xcommand SET HELPFILE TO <cFile>    => SetHelpFile( <cFile> )
#xcommand SET HELP TOPIC TO <cTopic> => HelpSetTopic( <cTopic> )

//----------------------------------------------------------------------------//
// Loading strings/or other Types from Resources

#xcommand REDEFINE <uVar> ;
             [ AS <type: CHARACTER, NUMERIC, LOGICAL, DATE> ] ;
             [ <resource: RESOURCE, RESNAME, NAME> <nIdRes> ] ;
       => ;
          <uVar> := LoadValue( <nIdRes>, [Upper(<(type)>)], <uVar> )

//----------------------------------------------------------------------------//

#xcommand DEFINE DIALOG <oDlg> ;
             [ <resource: NAME, RESNAME, RESOURCE> <cResName> ] ;
             [ TITLE <cTitle> ] ;
             [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
             [ <lib: LIBRARY, DLL> <hResources> ] ;
             [ <vbx: VBX> ] ;
             [ STYLE <nStyle> ] ;
             [ <color: COLOR, COLORS> <nClrText> [,<nClrBack> ] ] ;
             [ BRUSH <oBrush> ] ;
             [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
       => ;
          <oDlg> = TDialog():New( <nTop>, <nLeft>, <nBottom>, <nRight>,;
                 <cTitle>, <cResName>, <hResources>, <.vbx.>, <nStyle>,;
                 <nClrText>, <nClrBack>, <oBrush>, <oWnd> )

#xcommand ACTIVATE DIALOG <oDlg> ;
             [ ON LEFT CLICK <uClick> ] ;
             [ ON MOVE <uMoved> ] ;
             [ ON PAINT <uPaint> ] ;
             [ <center: CENTER, CENTERED> ] ;
             [ <NonModal: NOWAIT, NOMODAL> ] ;
             [ VALID <uValid> ] ;
             [ ON INIT <uInit> ] ;
             [ ON RIGHT CLICK <uRClicked> ] ;
        => ;
          <oDlg>:Activate( <oDlg>:bLClicked [ := <{uClick}> ], ;
                           <oDlg>:bMoved    [ := <{uMoved}> ], ;
                           <oDlg>:bPainted  [ := <{uPaint}> ], ;
                           <.center.>, [{|Self|<uValid>}],;
                           [ ! <.NonModal.> ], [{|Self|<uInit>}],;
                           [ <{uRClicked}> ] )

//----------------------------------------------------------------------------//

#endif
