#include "FiveWin.ch"

#define SQL_SUCCESS   0
#define SQL_DROP      1

//----------------------------------------------------------------------------//

CLASS TDbOdbc

   DATA   hEnv, hDbc, hStmt                   AS NUMERIC PROTECTED
   DATA   cConnect, cDSN, cUser, cPassword
   DATA   aFields

   METHOD New( cDSN, cUser, cPassword, cConnect, lDlg ) CONSTRUCTOR

   METHOD Execute( cCommand ) INLINE ;
                   If( SQLExecDirect( ::hStmt, cCommand ) != SQL_SUCCESS,;
                   MsgInfo( "Cannot execute that command" ),)

   METHOD FieldName( nField ) INLINE  ::aFields[ nField ][ 1 ]
   METHOD Field( nField )     INLINE  ::aFields[ nField ][ 1 ]
   METHOD FieldType( nField ) INLINE  ::aFields[ nField ][ 2 ]
   METHOD FieldLen( nField )  INLINE  ::aFields[ nField ][ 3 ]
   METHOD FieldDec( nField )  INLINE  ::aFields[ nField ][ 4 ]

   MESSAGE FCount METHOD _FCount()

   METHOD End()

   METHOD FieldGet( nField )

   METHOD InitFields()

   METHOD LastError()

   METHOD Skip()  INLINE  If( SQLFetch( ::hStmt ) != SQL_SUCCESS,;
                  MsgAlert( "Impossible to Skip" + CRLF + ::LastError() ),)

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cDSN, cUser, cPassword, cConnect, lDlg ) CLASS TDbOdbc

   local hEnv, hDbc, hStmt

   DEFAULT lDlg := .f.           // Dialog Box connection

   ::cDSN      = cDSN
   ::cUser     = cUser
   ::cPassword = cPassword

   if SQLAllocEnv( @hEnv ) == SQL_SUCCESS
      ::hEnv = hEnv
   else
      MsgStop( "Unable to create the enviroment for the ODBC Object" )
      return nil
   endif

   if SQLAllocConnect( hEnv, @hDbc ) == SQL_SUCCESS
      ::hDbc = hDbc
   else
      MsgStop( "Unable to create the Connection for the ODBC Object" )
      return nil
   endif

   if ! Empty( cConnect )
      if SQLDriverConnect( hDbc, @cConnect, lDlg ) != SQL_SUCCESS
         MsgStop( "Unable to perform the ODBC connection" )
         return nil
      else
         ::cConnect = cConnect
         ::cDSN     = SubStr( cConnect, 1, At( ";", cConnect ) - 1 )
         ::cDSN     = SubStr( ::cDSN, At( "=", ::cDSN ) + 1 )
      endif
   else
      if SQLConnect( hDbc, cDSN, cUser, cPassword ) != SQL_SUCCESS
         MsgStop( "Unable to perform the ODBC connection" )
         return nil
      endif
   endif

   if SQLAllocStmt( hDbc, @hStmt ) == SQL_SUCCESS
      ::hStmt = hStmt
   else
      MsgStop( "Unable to create a statement for the ODBC Object" )
      return nil
   endif

   ::Execute( "SELECT * FROM " + ::cDSN )
   ::InitFields()
   ::Skip()                    // Go to first element selected ???

return nil

//----------------------------------------------------------------------------//

METHOD _FCount() CLASS TDbOdbc

   local nFields

   if SQLNumResultCols( ::hStmt, @nFields ) != SQL_SUCCESS
      MsgStop( "Error calculating number fo fields" )
      return 0
   endif

return nFields

//----------------------------------------------------------------------------//

METHOD _FieldName( nField ) CLASS TdbOdbc

   local cName, nType, nLen, nDec

   SQLDescribeCol( ::hStmt, nField, @cName, @nType, @nLen, @nDec )

return cName

//----------------------------------------------------------------------------//

METHOD End() CLASS TDbOdbc

   SQLFreeStmt( ::hStmt, SQL_DROP )
   SQLDisconnect( ::hDbc )
   SQLFreeConnect( ::hDbc )
   SQLFreeEnv( ::hEnv )

   ::hEnv  = 0
   ::hDbc  = 0
   ::hStmt = 0

return nil

//----------------------------------------------------------------------------//

METHOD InitFields() CLASS TDbOdbc

   local n, nFields := ::FCount()
   local cName, nType, nLen, nDec, lNull

   ::aFields = {}

   for n = 1 to nFields
      SQLDescribeCol( ::hStmt, n, @cName, @nType, @nLen, @nDec, @lNull )
      AAdd( ::aFields, { cName, cSQLType( nType ), nLen, nDec, lNull } )
   next

return nil

//----------------------------------------------------------------------------//

METHOD FieldGet( nField ) CLASS TDbOdbc

   // local cType := ::FieldType( nField )
   local cData

   if SQLGetData( ::hStmt, nField, 0, ::FieldLen( nField ), @cData ) != ;
      SQL_SUCCESS
      MsgAlert( "Impossible retrieve Field Data" + CRLF + ::LastError() )
   endif

return cData

//----------------------------------------------------------------------------//

function cSQLType( nType )

   local cType := "U"

   do case
      case nType == 1
           cType = "C"

      case nType == -7
           cType = "L"

      case nType == 8
           cType = "N"

      case nType == 9
           cType = "D"

      case nType == -1
           cType = "M"
   endcase

return cType

//----------------------------------------------------------------------------//

METHOD LastError() CLASS TDbOdbc

   local cClassError, nType, cMsgError

   SQLError( ::hEnv, ::hDbc, ::hStmt, @cClassError, @nType, @cMsgError )

return cMsgError

//----------------------------------------------------------------------------//
