#include "FiveWin.ch"

#define BM_SETCHECK (WM_USER+1)

//----------------------------------------------------------------------------//

CLASS TCheckBox FROM TControl

   DATA   bClick

   METHOD New( nRow, nCol, cCaption, bSetGet, oWnd, nWidth, nHeight,;
               nHelpTopic, bClick, oFont, bValid, nClrFore, nClrBack ) ;
                                                                  CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, bClick, bValid,;
                    nClrFore, nClrBack ) CONSTRUCTOR

   METHOD Click()

   METHOD cToChar() INLINE Super:cToChar( "BUTTON" )

   METHOD Init( hDlg ) INLINE  Super:Init( hDlg ),;
                  ::SendMsg( BM_SETCHECK, If( Eval( ::bSetGet ), 1, 0 ) )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD Refresh() INLINE ;
                    ::SendMsg( BM_SETCHECK, If( Eval( ::bSetGet ), 1, 0 ) )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, cCaption, bSetGet, oWnd, nWidth, nHeight, nHelpTopic,;
            bClick, oFont, bValid, nClrFore, nClrBack ) CLASS TCheckBox

   DEFAULT cCaption   := "&CheckBox",;
           oFont      := TFont():New( "System", 8, 9 ),;
           nWidth     := Len( cCaption ) * oFont:nWidth,;
           nHeight    := oFont:nHeight + Int( oFont:nHeight / 2 ),;
           nHelpTopic := 100,;
           nClrFore   := oWnd:nClrText, nClrBack := oWnd:nClrPane

   ::nTop       = nRow * ( oFont:nHeight + Int( oFont:nHeight / 2 ) )
   ::nLeft      = ( nCol * oFont:nWidth ) + 3
   ::nBottom    = ::nTop + nHeight
   ::nRight     = ::nLeft + nWidth - 24
   ::cCaption   = cCaption
   ::nStyle     = nOR( WS_CHILD, WS_VISIBLE, BS_AUTOCHECKBOX, WS_TABSTOP )
   ::nId        = ::GetNewId()
   ::nHelpId    = nHelpTopic
   ::bSetGet    = bSetGet
   ::bClick     = bClick
   ::oWnd       = oWnd
   ::oFont      = oFont
   ::bValid     = bValid
   ::lDrag      = .f.
   ::lCaptured  = .f.

   ::SetColor( nClrFore, nClrBack )

   if ValType( Eval( bSetGet ) ) != "L"
      Eval( bSetGet, .f. )
   endif

   if oWnd:lVisible
      ::Create( "BUTTON" )
      ::SendMsg( BM_SETCHECK, If( Eval( ::bSetGet ), 1, 0 ) )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Click() CLASS TCheckBox

   if ::bSetGet != nil
      Eval( ::bSetGet, ! Eval( ::bSetGet ) )
   endif

   if ::bClick != nil
      Eval( ::bClick, Eval( ::bSetGet ) )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, bClick, bValid, nClrFore,;
                 nClrBack ) CLASS TCheckBox

   DEFAULT nClrFore := oWnd:nClrText, nClrBack := oWnd:nClrPane

   ::nId     = nId
   ::bSetGet = bSetGet
   ::bClick  = bClick
   ::oWnd    = oWnd
   ::nHelpId = nHelpId
   ::bValid     = bValid
   ::lDrag      = .f.
   ::lCaptured  = .f.

   ::SetColor( nClrFore, nClrBack )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TCheckBox

   if ::lDrag
      return Super:MouseMove( nRow, nCol, nKeyFlags )
   else
      Super:MouseMove( nRow, nCol, nKeyFlags )
   endif

return nil    //  We want standard behavior  !!!

//----------------------------------------------------------------------------//
