#include "FiveWin.ch"

#define LTGRAY_BRUSH 1
#define RT_BITMAP    2

static hWndLast := 0
static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TBtnBmp FROM TControl

   DATA   bAction, cMsg
   DATA   lPressed, lCaptured, lAdjust
   DATA   hBmpPal1, hBmpPal2

   METHOD New( nTop, nLeft, nWidth, nHeight,;
               cResName1, cResName2, cBmpFile1, cBmpFile2,;
               bAction, oWnd, cMsg ) CONSTRUCTOR

   METHOD NewBar( cResName1, cResName2, cBmpFile1, cBmpFile2,;
                  cMsg, bAction, lGroup, oBar, lAdjust ) CONSTRUCTOR

   METHOD Click()
   METHOD FreeBitmaps()
   METHOD cGenPRG()
   METHOD HandleEvent( nMsg, nWParam, nLParam )
   METHOD LButtonDown()
   METHOD LButtonUp( nLParam )
   METHOD LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 )

   METHOD Paint() INLINE ;
                  PalBtnPaint( ::hWnd, ::hBmpPal1, ::hBmpPal2, ::lPressed )

   METHOD MouseMove( nRow, nCol, nKeyFlags )
   METHOD Release()
   METHOD SetFile( cBmpUpFile, cBmpDownFile )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nWidth, nHeight,;
            cResName1, cResName2, cBmpFile1, cBmpFile2,;
            bAction, oWnd, cMsg )  CLASS TBtnBmp
   
   DEFAULT cMsg := " "

   ::nStyle    = nOR( WS_BORDER, WS_CHILD, WS_VISIBLE )
   ::nId       = ::GetNewId()
   ::oWnd      = oWnd
   ::bAction   = bAction
   ::cMsg      = cMsg
   ::nTop      = nTop
   ::nLeft     = nLeft
   ::nBottom   = nTop + nHeight - 1
   ::nRight    = nLeft + nWidth - 1
   ::lPressed  = .f.
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::nClrPane  = GetStockObject( LTGRAY_BRUSH )

   ::hBmpPal1  = 0
   ::hBmpPal2  = 0

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   if oWnd:lVisible
      ::Create()
   else
      oWnd:DefControl( Self )
   endif

   ::LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 )

return nil

//----------------------------------------------------------------------------//

METHOD NewBar( cResName1, cResName2, cBmpFile1, cBmpFile2, cMsg, bAction,;
               lGroup, oBar, lAdjust ) CLASS TBtnBmp

   DEFAULT cMsg := "", lAdjust := .f.

   ::nStyle    = nOR( WS_BORDER, WS_CHILD, WS_VISIBLE )
   ::nId       = ::GetNewId()
   ::oWnd      = oBar
   ::bAction   = bAction
   ::cMsg      = cMsg
   ::nTop      = oBar:GetBtnTop( lGroup )
   ::nLeft     = oBar:GetBtnLeft( lGroup )
   ::nBottom   = ::nTop + oBar:nBtnHeight + 1 - If( oBar:l3D, 6, 0 )
   ::nRight    = ::nLeft + oBar:nBtnWidth - If( oBar:l3D, 2, 0 )
   ::lPressed  = .f.
   ::lCaptured = .f.
   ::lDrag     = .f.
   ::lAdjust   = lAdjust
   ::nClrPane  = CLR_LIGHTGRAY

   ::hBmpPal1  = 0
   ::hBmpPal2  = 0

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   ::Create()
   oBar:Add( Self )

   ::LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 )

return nil

//----------------------------------------------------------------------------//

METHOD Click() CLASS TBtnBmp

   if ::bAction != nil
      Eval( ::bAction )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD cGenPRG() CLASS TBtnBmp

   local cPrg := ""

   cPrg += CRLF + CRLF + "   DEFINE BUTTON OF oBar " + ;
              'ACTION MsgInfo( "Not defined yet" )'

return cPrg

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam )  CLASS TBtnBmp

    do case
       case nMsg == WM_LBUTTONUP
            return ::LButtonUp( nLParam )

       case nMsg == WM_PAINT
            ::BeginPaint()
            ::Paint()
            ::EndPaint()
            return 0
    endcase

return Super:HandleEvent( nMsg, nWParam, nLParam )  

//---------------------------------------------------------------------------//

METHOD LButtonDown()  CLASS TBtnBmp

    ::lPressed  = .t.
    ::lCaptured = .t.
    ::Capture()
    ::Refresh( .f. )

return 0

//----------------------------------------------------------------------------//

METHOD LButtonUp( nLParam )  CLASS TBtnBmp

   local lClick := IsOverWnd( ::hWnd, nLParam )

   if ::lCaptured
      ::lCaptured = .f.
      if ::lPressed
         ::lPressed = .f.
         ::Refresh( .f. )
      endif
      ReleaseCapture()
      if lClick
         ::Click()
      endif
   endif

return 0

//----------------------------------------------------------------------------//

METHOD Release() CLASS TBtnBmp

   ::FreeBitmaps()
   Super:Release()

return 0

//----------------------------------------------------------------------------//

function ResetMsg( nMsg ) ; hWndLast := 0; return nil

//----------------------------------------------------------------------------//

METHOD SetFile( cBmpUpFile, cBmpDownFile ) CLASS TBtnBmp

   ::FreeBitmaps()
   ::LoadBitmaps( nil, nil, cBmpUpFile, cBmpDownFile )
   ::Refresh()

return nil

//----------------------------------------------------------------------------//

METHOD FreeBitmaps() CLASS TBtnBmp

   if ::hBmpPal1 != 0
      PalBmpFree( ::hBmpPal1 )
   endif

   if ::hBmpPal2 != 0
      PalBmpFree( ::hBmpPal2 )
   endif

   ::hBmpPal1 = 0
   ::hBmpPal2 = 0

return nil

//----------------------------------------------------------------------------//

METHOD LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 ) CLASS TBtnBmp

   if ! Empty( cResName1 )
      ::hBmpPal1 := PalBmpLoad( cResName1 )
   endif

   if ! Empty( cResName2 )
      ::hBmpPal2 := PalBmpLoad( cResName2 )
   endif

   if ! Empty( cBmpFile1 )
      if File( cBmpFile1 )
         ::hBmpPal1  := PalBmpRead( ::GetDC(), cBmpFile1 )
         ::ReleaseDC()
      endif
   endif

   if ! Empty( cBmpFile2 )
      if File( cBmpFile2 )
         ::hBmpPal2  := PalBmpRead( ::GetDC(), cBmpFile2 )
         ::ReleaseDC()
      endif
   endif

   if !empty( ::hBmpPal1 )
      PalBmpNew( ::hWnd, ::hBmpPal1 )
   endif

   if !empty( ::hBmpPal2 )
      PalBmpNew( ::hWnd, ::hBmpPal2 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TBtnBmp

   Super:MouseMove( nRow, nCol, nKeyFlags )

   if ::lCaptured
      if ::lPressed != IsOverWnd( ::hWnd, nRow, nCol )
         ::lPressed = ! ::lPressed
         ::Refresh( .f. )
      endif
   endif
   if hWndLast != ::hWnd
      hWndLast = ::hWnd
      ::oWnd:SetMsg( ::cMsg )
   endif

return 0

//----------------------------------------------------------------------------//
