// Implementacin de un Browse genrico creado desde cdigo

#include "FiveWin.ch"

#define ENGLISH

//----------------------------------------------------------------------------//

function Browse( cTitle, cListName, bNew, bModify, bDelete, bSearch, bList )

   local oDlg, oLbx
   local btnNew, btnModify, btnDelete, btnSearch, btnList, btnEnd

   DEFAULT cTitle := "Browse", cListName := "Campos"

   DEFINE DIALOG oDlg FROM 3, 3 TO 26, 79 TITLE cTitle

   @ 0,  1 SAY cListName  OF oDlg

   @ 1, 1 LISTBOX oLbx FIELDS ;
      SIZE 284, 137  OF oDlg

#ifdef ENGLISH

   @ 13,  1 BUTTON btnNew    PROMPT "&New"    OF oDlg SIZE 40, 12
   @ 13,  8 BUTTON btnModify PROMPT "&Modify" OF oDlg SIZE 40, 12
   @ 13, 15 BUTTON btnDelete PROMPT "&Delete" OF oDlg SIZE 40, 12
   @ 13, 22 BUTTON btnSearch PROMPT "&Search" OF oDlg SIZE 40, 12
   @ 13, 29 BUTTON btnList   PROMPT "&Print"  OF oDlg SIZE 40, 12
   @ 13, 36 BUTTON btnEnd    PROMPT "&Exit"   OF oDlg SIZE 40, 12

#else

   @ 13,  1 BUTTON btnNew    PROMPT "&Nuevo"    OF oDlg SIZE 40, 12
   @ 13,  8 BUTTON btnModify PROMPT "&Modifica" OF oDlg SIZE 40, 12
   @ 13, 15 BUTTON btnDelete PROMPT "&Elimina"  OF oDlg SIZE 40, 12
   @ 13, 22 BUTTON btnSearch PROMPT "&Buscar"   OF oDlg SIZE 40, 12
   @ 13, 29 BUTTON btnList   PROMPT "&Imprimir" OF oDlg SIZE 40, 12
   @ 13, 36 BUTTON btnEnd    PROMPT "&Salir"    OF oDlg SIZE 40, 12

#endif

   btnNew:bAction    = If( bNew    != nil,;
                           { || Eval( bNew ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnModify:bAction = If( bModify != nil,;
                           { || Eval( bModify ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnDelete:bAction = If( bDelete != nil,;
                           { || Eval( bDelete ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnSearch:bAction = If( bSearch != nil,;
                           { || Eval( bSearch ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnList:bAction   = If( bList   != nil,;
                           { || Eval( bList ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnEnd:bAction    = { || oDlg:End() }

   ACTIVATE DIALOG oDlg 

return

//----------------------------------------------------------------------------//
