#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

//----------------------------------------------------------------------------//

CLIPPER BMPWRITE()          // cBmpFile, hWnd, nWidth, nHeight
{
   FILE * hFile = fopen( _parc( 1 ), "wb" );
   HWND hWnd    = _parni( 2 );
   WORD wWidth  = _parni( 3 );
   WORD wHeight = _parni( 4 );
   RECT rct;
   HDC  hDC     = GetDC( hWnd );
   WORD wColors = GetDeviceCaps( hDC, SIZEPALETTE );
   WORD wLineWidth, wLinePad;
   LONG lBmpSize, lPalSize;
   BITMAPINFOHEADER bmIH;
   BITMAPFILEHEADER bmFH;
   HPALETTE hPal;
   LPLOGPALETTE pPal;

   if( ! _parni( 3 ) )
   {
      GetClientRect( hWnd, &rct );
      wWidth  = rct.right - rct.left + 1 ;
      wHeight = rct.bottom - rct.top + 1 ;
   }

   if( wColors == 16 )
   {
      bmIH.biBitCount = 4;
      wLineWidth = wWidth / 2;
   }
   else
   {
      bmIH.biBitCount = 8;
      wLineWidth = wWidth;
   }

   if( wLineWidth % sizeof( DWORD ) )
      wLinePad = sizeof( DWORD ) - ( wLineWidth % sizeof( DWORD ) );

   lBmpSize = ( wLineWidth + wLinePad ) * wHeight;
   lPalSize = wColors * sizeof( RGBQUAD );

   bmFH.bfType      = 0x4D42;
   bmFH.bfReserved1 = 0L;
   bmFH.bfReserved2 = 0L;
   bmFH.bfOffBits   = lPalSize + sizeof( BITMAPINFO ) +
                      sizeof( BITMAPFILEHEADER );
   bmFH.bfSize      = wBmpSize + bmFH.bfOffBits;

   fwrite( &bmFH, sizeof( bmFH ), 1, hFile );

   bmIH.biSize          = ( DWORD ) sizeof( BITMAPINFOHEADER );
   bmIH.biWidth         = wWidth;
   bmIH.biHeight        = wHeight;
   bmIH.biPlanes        = 1;
   bmIH.biCompression   = BI_RGB;
   bmIH.biSizeImage     = 0L;
   bmIH.biXPelsPerMeter = 0L;
   bmIH.biYPelsPerMeter = 0L;
   bmIH.biClrUsed       = 0L;
   bmIH.biClrImportant  = 0L;

   fwrite( &bmIH, sizeof( bmIH ), 1, hFile );

   hPal = GlobalAlloc( GHND, sizeof( LOGPALETTE ) +
          ( wColors * sizeof( PALETTEENTRY ) );
   pPal = ( LPLOGPALETTE ) GlobalLock( hPal );
   pPal->palNumEntries = wColors;
   pPal->palVersion    = 0x0300;
   GetSystemPaletteEntries( hDC, 0, wColors, pPal->palPalEntry );

   for( w = 0; w < wColors; w++ )
   {


