#include "FiveWin.ch"

#define GW_CHILD      5
#define GW_HWNDNEXT   2
#define RT_BITMAP     2

#define MB_ICONEXCLAMATION 48

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TBitmap FROM TControl

   DATA   nX, nY
   DATA   hBmpPal, cBmpFile, cResName
   DATA   lScroll, lStretch
   DATA   aHotAreas
   DATA   nVStep, nHStep

   METHOD New( nTop, nLeft, nWidth, nHeight, cResName, cBmpFile, lNoBorder,;
               oWnd, bLClicked, bRClicked, lScroll, lStretch,;
               oCursor ) CONSTRUCTOR

   METHOD ReDefine( nId, cResName, cBmpFile, oWnd, bLClicked, bRClicked,;
                    lStretch, oCursor ) CONSTRUCTOR

   METHOD Release()

   METHOD Command( nWParam, nLParam ) INLINE ;
                   SendMessage( nLoWord( nLParam ), WM_CLICK, 0, 0 ), 0

   METHOD Default()

   METHOD GotFocus() INLINE SetForeBmp( ::hBmpPal )

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD Paint()

   METHOD Load( cResName, cBmpFile )

   METHOD ReLoad( cResName, cBmpFile )

   METHOD ReSize( nType, nWidth, nHeight ) INLINE ;
                             ::ScrollAdjust(),;
                             Super:ReSize( nType, nWidth, nHeight )

   METHOD SetBMP( cResName )  INLINE ::ReLoad( cResName )
   METHOD LoadBMP( cBmpFile ) INLINE ::ReLoad( , cBmpFile )

   METHOD ScrollAdjust()

   METHOD nHeight()    INLINE  pBmpHeight( ::hBmpPal )

   METHOD Init( hDlg ) INLINE  Super:Init( hDlg ), ::Default()

   METHOD nWidth()     INLINE  pBmpWidth( ::hBmpPal )

   METHOD LButtonDown( nRow, nCol, nKeyFlags )

   METHOD ScrollUp()
   METHOD ScrollLeft()

   METHOD ScrollDown() INLINE  ::nX := Min( ::nX + ::nVStep, 0 ),;
                               ::Refresh( .f. )

   METHOD ScrollRight() INLINE  ::nY := Min( ::nY + ::nHStep, 0 ),;
                                ::Refresh( .f. )

   METHOD nXExtra() INLINE ::nHeight() - ( ::nBottom - ::nTop ) + 1
   METHOD nYExtra() INLINE ::nWidth()  - ( ::nRight - ::nLeft ) + 1

   METHOD VScroll( nWParam, nLParam )
   METHOD HScroll( nWParam, nLParam )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nWidth, nHeight, cResName, cBmpFile, lNoBorder,;
            oWnd, bLClicked, bRClicked, lScroll, lStretch, oCursor ) CLASS TBitmap

   DEFAULT lNoBorder := .f., lScroll := .f., lStretch := .f.

   ::hBmpPal   = 0
   ::lStretch := lStretch

   ::Load( cResName, cBmpFile )

   DEFAULT nWidth  := ::nWidth(), ;
           nHeight := ::nHeight()

   ::nTop      = nTop * 14
   ::nLeft     = nLeft * 8
   ::nBottom   = ::nTop + nHeight - 1
   ::nRight    = ::nLeft + nWidth - 1
   ::nX        = 0
   ::nY        = 0
   ::nStyle    = nOR( If( ! lNoBorder, WS_BORDER, 0 ),;
                      If( lScroll, nOR( WS_VSCROLL, WS_HSCROLL ), 0 ),;
                      WS_CHILD, WS_VISIBLE )
   ::nId       = ::GetNewId()
   ::oWnd      = oWnd
   ::lCaptured = .f.
   ::lDrag     = .f.
   ::bLClicked = bLClicked
   ::bRClicked = bRClicked
   ::lScroll   = lScroll
   ::aHotAreas = {}
   ::nVStep    = 1
   ::nHStep    = 1

   ::oCursor   = oCursor

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   if oWnd:lVisible
      ::Create()
      ::Default()
      ::lVisible = .t.
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
      ::lVisible  = .f.
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Default() CLASS TBitmap

   if ::lScroll == nil
      ::lScroll = WndHasScrolls( ::hWnd )
   endif

   if ::lScroll
      DEFINE SCROLLBAR ::oVScroll VERTICAL   OF Self
      DEFINE SCROLLBAR ::oHScroll HORIZONTAL OF Self
      ::ScrollAdjust()
   endif
   
   // Register the Bitmap for its later destruction on severe error.
   // From resource and file.

   PalBmpNew( ::hWnd, ::hBmpPal )

return nil

//----------------------------------------------------------------------------//

METHOD Release() CLASS TBitmap

   if ::hBmpPal != 0
      PalBmpFree( ::hBmpPal )
      ::hBmpPal = 0
   endif

   Super:Release()

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, cResName, cBmpFile, oWnd, bLClicked, bRClicked,;
                 lScroll, lStretch, oCursor ) CLASS TBitmap

   DEFAULT lScroll := .f., lStretch := .f.

   ::nId       = nId
   ::nX        = 0
   ::nY        = 0
   ::lCaptured = .f.
   ::lDrag     = .f.
   ::bLClicked = bLClicked
   ::bRClicked = bRClicked
   ::lScroll   = lScroll
   ::lStretch  = lStretch
   ::aHotAreas = {}
   ::oCursor   = oCursor
   ::oWnd      = oWnd
   ::nVStep    = 1
   ::nHStep    = 1

   ::Load( cResName, cBmpFile )

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   if oWnd != nil
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TBitmap

   if Empty( ::hBmpPal )
      return nil
   endif

return If( ::lStretch,;
           PALBMPDraw( ::hWnd, ::nX, ::nY, ::hBmpPal, ;
                       ::nRight - ::nLeft + 1, ::nBottom - ::nTop + 1 ),;
           PALBMPDraw( ::hWnd, ::nX, ::nY, ::hBmpPal ) )

//---------------------------------------------------------------------------//

METHOD ReLoad( cResName, cBmpFile ) CLASS TBitmap

  local lSuccess := ::Load( cResName, cBmpFile )

  if lSuccess
     ::ScrollAdjust()
     ::nX = 0
     ::nY = 0
     ::Refresh()
  endif

return lSuccess

//---------------------------------------------------------------------------//

METHOD Load( cResName, cBmpFile ) CLASS TBitmap

   local lChanged := .f.
   local hOld     := ::hBmpPal

   DEFAULT cResName := ::cResName,;
           cBmpFile := ::cBmpFile

   if ! Empty( cResName )

       ::hBmpPal := PalBmpLoad( cResName )
       lChanged  := .t.
       cBmpFile  := nil

   elseif File( cBmpFile )

       ::hBmpPal := PalBmpRead( ::GetDC(), cBmpFile )
       ::ReleaseDC()
       lChanged  := .t.
       cResName  := nil

   endif

   if lChanged

      ::cResName = cResName
      ::cBmpFile = cBmpFile

      if ! Empty( hOld )
         PalBmpFree( hOld )
      endif

      PalBmpNew( ::hWnd, ::hBmpPal )

   endif
   
return lChanged

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TBitmap

   local nRet

   do case
      case nMsg == WM_LBUTTONDOWN
           return ::LButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_PAINT
           ::ScrollAdjust()      // It generates WM_PAINT when range == 0
           ::BeginPaint()        // so here we avoid 'flicking'
           ::Paint()
           ::EndPaint()
           return 0

      case nMsg == WM_RBUTTONDOWN
           return ::RButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_VSCROLL
           return ::VScroll( nWParam, nLParam )

      case nMsg == WM_HSCROLL
           return ::HScroll( nWParam, nLParam )

      case nMsg == WM_COMMAND
           return ::Command( nWParam, nLParam )

      otherwise
         nRet = Super:HandleEvent( nMsg, nWParam, nLParam )
   endcase

return nRet

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol, nKeyFlags ) CLASS TBitmap

   if ::lDrag
      return Super:LButtonDown( nRow, nCol, nKeyFlags )
   else
      if ::bLClicked != nil
         Eval( ::bLClicked, nRow, nCol, nKeyFlags )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ScrollUp() CLASS TBitmap

   local nVisible := ::nBottom - ::nTop - If( ::oHScroll:nMax != 0, 16, 0 )
   local nStep

   nStep := ( ::nHeight() + ::nX ) - nVisible

   if ::nHeight() > nVisible
      if ::nHeight() + ::nX >= nVisible
         ::nX = ::nX - Min( nStep, ::nVStep )
         ::Refresh( .f. )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ScrollLeft() CLASS TBitmap

   local nVisible := ::nRight - ::nLeft - If( ::oVScroll:nMax != 0, 16, 0 )
   local nStep

   nStep := ( ::nWidth() + ::nY ) - nVisible

   if ::nWidth() > nVisible
      if ::nWidth() + ::nY >= nVisible
         ::nY = ::nY - Min( nStep, ::nHStep )
         ::Refresh( .f. )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD VScroll( nWParam, nLParam ) CLASS TBitmap

   do case
      case nWParam == SB_LINEUP
           ::oVScroll:GoUp()
           ::ScrollDown()

      case nWParam == SB_LINEDOWN
           ::oVScroll:GoDown()
           ::ScrollUp()

      case nWParam == SB_PAGEUP


      case nWParam == SB_PAGEDOWN


      case nWParam == SB_TOP
           ::nX = 0
           ::oVScroll:SetPos( 1 )
           ::Refresh( .f. )

      case nWParam == SB_BOTTOM
           ::nX = ::nXExtra()
           ::oVScroll:SetPos( ::oVScroll:nMax )
           ::Refresh( .f. )

      case nWParam == SB_THUMBPOSITION
           // ::nColPos = nLParam
           // ::oHScroll:SetPos( nLParam )
           // ::Refresh( .f. )

      otherwise
           return nil
   endcase

return 0

//----------------------------------------------------------------------------//

METHOD HScroll( nWParam, nLParam ) CLASS TBitmap

   do case
      case nWParam == SB_LINEUP
           ::oHScroll:GoUp()
           ::ScrollRight()

      case nWParam == SB_LINEDOWN
           ::oHScroll:GoDown()
           ::ScrollLeft()

      case nWParam == SB_PAGEUP

      case nWParam == SB_PAGEDOWN

      case nWParam == SB_TOP

      case nWParam == SB_BOTTOM

      case nWParam == SB_THUMBPOSITION

      otherwise
           return nil
   endcase

return 0

//----------------------------------------------------------------------------//

METHOD ScrollAdjust() CLASS TBitmap

   local nVisHeight
   local nVisWidth
   local lHor := .f., lVer := .f.

   ::CoorsUpdate()
   nVisHeight = ::nBottom - ::nTop + 1
   nVisWidth  = ::nRight - ::nLeft + 1

   if ::lScroll
      if ::nHeight() <= nVisHeight .or. ::lStretch
         ::oVScroll:SetRange( 0, 0 )
         ::nX = 0
         ::nY = 0
      else
         lVer = .t.
      endif
      if ::nWidth() <= nVisWidth .or. ::lStretch
         ::oHScroll:SetRange( 0, 0 )
         ::nX = 0
         ::nY = 0
      else
         lHor = .t.
      endif
      if lVer
         ::oVScroll:SetRange( 0, ::nXExtra() + If( lHor, 16, 0 ) )
      endif
      if lHor
         ::oHScroll:SetRange( 0, ::nYExtra() + If( lVer, 16, 0 ) )
      endif
   endif

return nil

//----------------------------------------------------------------------------//
