/*--------------------------------------------------------------------------*/
/*                                                                          */
/* Copyright 1989, Doug Boone.  FidoNet 119/5                               */
/*                              (916) 893-9019 Data                         */
/*                              (916) 891-0748 voice                        */
/*                              P.O. Box 5108, Chico, CA. 95928             */
/*                                                                          */
/* This program is not for sale. It is for the free use with Opus systems.  */
/* You may not sell it in ANY way. If you have an access charge to your     */
/* Bulletin Board, consider this to be like Opus, you can ONLY make it      */
/* available for download in an open area, where non-members can get access */
/*                                                                          */
/* If you need to modify this source code, please send me a copy of the     */
/* changes you've made so that everyone can share in the updates.           */
/*                                                                          */
/* "Don't rip me off!" -- Tom Jennings, FidoNet's founder                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#include    <stdio.h>
#include    <string.h>
#include    <ctype.h>
#include    <stdlib.h>
#include    <time.h>
#include    <dos.h>
#ifdef TURBOC
#include    <dir.h>
#include    <alloc.h>
#else
#include    <malloc.h>
#endif
#include    <io.h>
#include    <fcntl.h>
#include    <dos.h>
#include    <conio.h>
#include    <errno.h>
#include    <sys\types.h>
#include    <sys\stat.h>
#include    <opus.h>
#include    <process.h>
#include    <signal.h>
#include    "archdr.h"
#include    "fview.h"
#define     VER     "06.20"

#ifdef BOTH
#define DOLZH
#define PAKIT
#endif

extern  int unzip(char *,char *);
extern	int	unpak(char *,char *);
extern  int unlzh(char *,char *);

void main(int argc, char *argv[])
{
    int     i;
    char    *result;
    char    Log_path[MAX_PATH];
    long    now;

#ifdef TURBOC
    struct  dfree  *space;
#else
    struct  diskfree_t  space;
#endif

    signal(SIGINT,handler);		/* Set the ^C handler to internal */
    tzset(); 		/* We're going to play with the time so..... */
    *Sys_Path = EOS;
    sdisplay = locputs;        /* set ptrs to local functions */
    get_a_char = getch;
    chk_keyboard = kbhit;
    time(&quit_time);		/* Get the current time */
#ifdef  TDEBUG
    quit_time += 1800L;        /* 30 minutes while debugging */
#else
    quit_time += 300L;		/* Otherwise, five minutes */
#endif
    strcpy(dearc_path,"C:\\Dearc\\");		/* Set defaults */
    strcpy(Log_path,"Fview");

    for (i=1; i<argc; i++) {
        result = strupr(argv[i]);
        if ((result = strstr(argv[i],".CTL")) != NULL) {
            flags |= OPUS_10;
            result--;
            if (isxdigit(*result))
                if (isdigit(*result))
                    task = *result -'0';
                else
                    task = *result - 'A' + 10;
            else
                task = 0;
#ifdef SDEBUG
            fprintf(Log_fp,"FVIEW Task = %d  %s\n",task,result);
            printf("Task = %d  Result = %s\n",task,result);
#endif
            }
        result = argv[i];
#ifdef SDEBUG
        printf("%03i   %s\n",i,argv[i]);
        fprintf(Log_fp,"FVIEW Arg: %2d  %s\n",i,argv[i]);
#endif

        if (*result == '-' ||
            *result == '/') {
            result++;
            switch(*result) {

                case 'B':   baud = atoi(++result);
                            flags |= FOSSIL;
                            break;

                case '0':   flags |= OPUS_10;
                            break;

                case 'D':    strcpy(dearc_path,++result);
                            break;

                case 'L':    strcpy(Log_path,++result);
                            break;

                case 'S':   strcpy(Sys_Path,++result);
                            break;

                case 'G':    flags |= DEBUG;
                            break;

                case 'N':    flags |= NO_SHOW;
                            break;

                case 'P':   port = atoi(++result);
                            flags |= FOSSIL;
                            break;

                case 'T':    task = atoi(++result);
                            break;

                case 'W':    flags |= WATCH;
                            break;

                }        /* End of switch */
            }        /* End of reading params */
        }        /* End of first for() loop searching for params */
    check_cfg(Log_path);
    result = getenv("FVIEW");
    if (*result != EOS)
        parse_env(result,Log_path);
    strcat(Log_path,".Log");
    Log_fp = fopen(Log_path,"at");
    time(&now);
    fprintf(Log_fp,"FVIEW Coming online %s",ctime(&now));
    if (flags & DEBUG)  {
        for (i=0;i<argc;i++)
            fprintf(Log_fp,"ARG %02d = %s\n",i,argv[i]);
#ifdef TURBOC
        fprintf(Log_fp,"Free Memory = %u\n",coreleft());
#else
        fprintf(Log_fp,"Free Memory = %u\n",_memavl());
#endif
        }

    if ((i = strlen(Sys_Path)) > 0) {
        if (Sys_Path[--i] != '\\')
            strcat(Sys_Path,"\\");
        }

    i = strlen(dearc_path)-1;
    if (dearc_path[i] == '\\')
        dearc_path[i] = EOS;

    		/* Check to see if there's actually free disk space */

#ifdef TURBOC
    space = (struct dfree *) malloc(sizeof(struct dfree));
    getdfree(dearc_path[0]-'@',space);
    dearc_free = space->df_avail;
    dearc_free *= space->df_bsec;
    dearc_free *= space->df_sclus;
    dearc_free /= 1024L;
    free(space);
#else
    if (_dos_getdiskfree(dearc_path[0]-'@',&space) == 0) {
        dearc_free = (long) space.avail_clusters;
        dearc_free *= (long) space.sectors_per_cluster;
        dearc_free *= (long) space.bytes_per_sector;
        } 
#endif

    if (flags & DEBUG)
        fprintf(Log_fp,"Free space in dearc directory = %ld\n",dearc_free);
    if (task > 1) {
        sprintf(apath,"%s\\%02X",dearc_path,task);
        strcpy(dearc_path,apath);
        }
    if (flags & DEBUG)
        fprintf(Log_fp,"FVIEW Dearc path = %s\n",dearc_path);

    if ((i = access(dearc_path,04)) != 0) {
        fprintf(Log_fp,"FVIEW ERROR Can't access %s Exitting\n",dearc_path);
        sdisplay("\nSorry, Sysop hasn't configured this properly yet.\n");
        terminate(5);
        }

    if (flags & OPUS_10)
        get_path("lastuse");
    else
        get_path("lastus");

    if (flags & FOSSIL)
        load_fossil();

/*--------------------------------------------------------------------------*/
/* This is the loop where the actual work is done. Everything until here    */
/* was just initialization.                                                 */
/*--------------------------------------------------------------------------*/
    do {
        line %= (screen -2);
        i = get_names();
        if (quit_time < time(NULL))
            ctrl_err = 0;
        } while (i && ctrl_err);
    terminate(0);
}


/*--------------------------------------------------------------------------*/
/* Get the current file area path                                           */
/*--------------------------------------------------------------------------*/

void get_path(char *result)
{
    struct  _sys    *system;
    FILE    *infp;
    char    luser[MAX_PATH];

    system = (struct _sys *) malloc(sizeof(struct _sys));

    if (task == 0)
        sprintf(luser,"%sLASTUSER.BBS",Sys_Path);
    else {
        if (flags & OPUS_10)
            sprintf(luser,"%s%s%X.BBS",Sys_Path,result,task);
        else
            sprintf(luser,"%s%s%02X.BBS",Sys_Path,result,task);
        }

    if (flags & DEBUG)
        fprintf(Log_fp,"Reading %s\n",luser);
    if ((infp = fopen(luser,"rb")) == NULL) {
        fprintf(Log_fp,"Can't open lastuser.bbs %s\n",luser);
        fclose(infp);
        terminate(1);
        }
    fread(last,sizeof(struct _usr),1,infp);
    fclose(infp);
    fprintf(Log_fp,"FVIEW User = %s\n",last[0].name);
	screen = (int)last[0].len;

	if (last[0].help == 0x06) {
        help();
		if (!(flags & NO_SHOW))
			list_help();
		}

    if (last[0].Bits & MORE_PROMPT)
        flags |= WANTS_MORE;

    if (last[0].files >0) {
        if (flags & OPUS_10)
            sprintf(apath,"SYSTEM%d.BBS",last[0].files);
        else
            sprintf(apath,"SYSTEM%X.BBS",last[0].files);
        }
    else
        strcpy(apath,"SYSTEM.BBS");
    strcat(Sys_Path,apath);
    if ((infp = fopen(Sys_Path,"rb")) == NULL)
        terminate(2);
    fread(system,sizeof(struct _sys),1,infp);
    fclose(infp);
    strcpy(file_path,system->filepath);
    fprintf(Log_fp,"FVIEW Area = %03d  FilePath = %s\n",last[0].files,file_path);
    free(system);
    return;
}

/*--------------------------------------------------------------------------*/
/* If user is on remotely, load the FOSSIL                                  */
/*--------------------------------------------------------------------------*/

void load_fossil(void)
{
#ifdef SDEBUG
    printf("Loading FOSSIL\n");
#endif
    if (flags & FOSSIL) {
        if (CkFossilCD()) {
            GetDriverInfo();
            Comm_Purge_out();
            Comm_Purge_in();
            if (flags & WATCH)
                Comm_Watch(1);        /* turn FOSSIL watchdog on */
            sdisplay = fosputs;        /* set ptrs to fossil functions */
            get_a_char = Comm_Receive;
            chk_keyboard = Comm_Char_Avail;
            }        /* End of succesful FOSSIL install */
        }        /* End of installing FOSSIL */
}

/* ====================================================================
 * common termination routine
 * restore environment and exit to dos
 * ====================================================================
 */
void terminate(int stat)
{
    char    temp[80];
    long    now;

    flags &= ~MORE;
	sprintf(temp,"\n\n Sysop of 119/5 Thanks you for using FView v. %s : %s\n\n",VER,__DATE__);
    if (!(flags & FOSSIL))
        sdisplay(temp);
    unlink(mbr_path);
    if(flags & FOSSIL) {
        if (Comm_CD())
            sdisplay(temp);
        Comm_Purge_out();
        Comm_Purge_in();
        if (flags & WATCH)
            Comm_Watch(0);        /* turn FOSSIL watchdog off */
        }
    time(&now);
    fprintf(Log_fp,"FVIEW Exiting(%u) %s\n",stat,ctime(&now));
    fclose(Log_fp);
    signal(SIGINT,SIG_DFL);
    exit(stat);
}

/*--------------------------------------------------------------------------*/
/* Look at each matching archive file, get full names                       */
/*--------------------------------------------------------------------------*/

void file_name(char *start)
{
    int     done;
    int     success;
    long    now;
#ifdef TURBOC
    struct  ffblk   ffblk;
#else
    struct  find_t  cfile;
#endif
    char    name[MAX_PATH];
    char    temp_path[MAX_PATH];
    int     infile;        /* file handle */
    char    *firstchar;
    char    *result;

    if (flags & DEBUG)
        fprintf(Log_fp,"In filename(): %s\n",start);

	if ((firstchar = (char *) malloc(2)) == NULL) {
		fprintf(Log_fp,"Failed to allocate memory for FIRSTCHAR\n");
		return;
		}
    result = strrchr(start,'\\');
    if (result != NULL)
        *++result = '\0';
    else if ((result = strrchr(start,':')) != NULL)
            *++result = '\0';
    else result = start;
    if (strncmp(result,".",1)==0)
        strcpy(result,"*.*");
    strcpy(temp_path,file_path);
    strcpy(apath,file_path);
    strcat(temp_path,result);
#ifdef TURBOC
    done = findfirst(temp_path,&ffblk,0);
#else
    done = _dos_findfirst(temp_path,_A_NORMAL,&cfile);
#endif
    while (ctrl_err && done == 0) {
        strcpy(name,file_path);

#ifdef TURBOC
        strcat(name,ffblk.ff_name);
#else
        strcat(name,cfile.name);
#endif
        time(&now);
        fprintf(Log_fp,"FVIEW %s %s",name,ctime(&now));
        if (flags & FOSSIL && !(Comm_CD()))
            terminate(3);
        infile = open(name,O_RDONLY|O_BINARY);
        if (infile > 0)
			success = read(infile,firstchar,2);
        close(infile);
        flags &= ~0xf000;
        switch(toupper(firstchar[0])) {
            case 0x1a   :   flags |= ARC;		/* Get archive members */
                               success = lstarc(name);
                                                /* Get text inside archive */
                            if ((success == 0) && (flags & VIEW) &&
                                !(flags & NO_SHOW))
                                success = get_mbr_name(name);
                            break;

            case 'Z'    :   flags |= ZOO;
                            success = do_zoo(name);
                            break;

            case 'P'    :   flags |= ZIP;
                            success = do_zip(name);
                            if (success == 0 && flags & VIEW &&
                                !(flags & NO_SHOW))
                                success = get_mbr_name(name);
                            break;

            case 'M'    :   play("%s is an EXE file, not an archive\n",
#ifdef TURBOC
                                ffblk.ff_name);
#else
                                cfile.name);
#endif
                            break;

			default     :   success = read_lzh(name);
#ifdef DOLZH
                            if (success == 0 && flags & VIEW &&
                                !(flags & NO_SHOW))
                                success = get_mbr_name(name);
                            else {
#endif
                                if (success < 0)
                                      success = read_dwc(name);
#ifdef DOLZH

                                }
#endif
                            break;
            }
        if (success < 0) {
#ifdef TURBOC
            sprintf(temp_path,"\n%s Not an archive file\n\n",ffblk.ff_name);
#else
            sprintf(temp_path,"\n%s Not an archive file\n\n",cfile.name);
#endif
            sdisplay(temp_path);
            }
#ifdef TURBOC
        done = findnext(&ffblk);
#else
        done = _dos_findnext(&cfile);
#endif
        if (FOSSIL & flags && !(Comm_CD()))
            done = 1;
        if (success == -1 && ctrl_err == 0) {
            ctrl_err = 1;
            done = 1;
            }
        if (!(ctrl_err))
            done = 1;
        }        /* end of findfirst/findnext loop */
	free(firstchar);
    return;
}

/*--------------------------------------------------------------------------*/
/* Get archive/file name(s) from user                                       */
/*--------------------------------------------------------------------------*/

int get_names(void)
{
    char    *temp;
    char    *buf;
    char    fname[50];

    if (flags & DEBUG)
        fprintf(Log_fp,"Getting names, File-Path = %s\n",file_path);

    temp = (char *) malloc(50);
    buf = temp;
    *mbr = EOS;
    memset(temp,'\0',50);
    ctrl_err = 1;
    if (time(NULL) > quit_time)
        terminate(1);
	sdisplay("\n\n  Contents of which file? [ ? for help]  ");
    get_string(temp);

    if ((strlen(temp) == 0) ||
        (stricmp(temp,"quit") == 0)) {
        free(temp);
        return(0);
        }

    if (flags & WANTS_MORE)
        flags |= MORE;

    line %= (screen-2);

    if (stricmp(temp,"help") == 0) {
        help();
        if (!(flags & NO_SHOW))
            list_help();
        return(1);
        }

    if (strlen(temp) == 1) {
        switch(*temp) {
            case 'Q':   free(temp);return(0);

            case 'V':
            case 'L':   flags |= VIEW;
                        file_name(++buf);
                        ctrl_err = 1;
                        return(1);

            case 'H':
            case '?':
            default :   help();
                        if (!(flags & NO_SHOW))
                            list_help();
                        return(1);
            }
        }
    buf = strchr(temp,' ');
    if (buf != NULL) {
        if (temp[1] == ' ') {
            if (*temp == 'V' || *temp == 'L') {
                flags |= VIEW;
                strcpy(fname,++buf);
                if ((buf=strchr(fname,' ')) != NULL) {
                    *buf = EOS;
                    strcpy(mbr,++buf);
                    }
                file_name(fname);
                ctrl_err = 1;
                return(1);
                }
            }
        else {
            flags |= VIEW;
            *buf = EOS;
            ++buf;
            strcpy(mbr,buf);
            file_name(temp);
            ctrl_err = 1;
            return(1);
            }
        }
    else {
        flags &= ~VIEW;
        file_name(temp);
        ctrl_err = 1;
        }
    return(1);
}

/*--------------------------------------------------------------------------*/
/* Control Break handler                                                    */
/*--------------------------------------------------------------------------*/

void handler(void)
{

    signal(SIGINT,SIG_IGN);
    ctrl_err = 0;
    if (flags & FOSSIL) {
        Comm_Purge_in();
        Comm_Purge_out();
        }
    signal(SIGINT,handler);
}

void help(void)
{
    sdisplay("\n\n This program will list the contents of any of the existing archive\n");
    sdisplay(" format.  You need to specify a file name, and wildcards will be allowed.\n");
    sdisplay(" Pres <ENTER> or type 'quit' when done and you'll be returned to the BBS.\n\n");
    if (time(NULL) > quit_time)
        terminate(1);
    return;
}

void list_help(void)
{
    sdisplay(" If you want to see a text file WITHIN an archive, start the line with a \n");
    sdisplay(" 'V' followed by a space character, then the file name. You'll be prompted\n");
    sdisplay(" for a member name. Only '*'-type wildcards here. Or, you can give an archive\n");
    sdisplay(" name and the internal files you'd like listed.  Something like this:\n\n");
    sdisplay("        Contents of which file?  V *.ARC\n        Contents of which file? ARCVIEW.* ARCVIEW.C\n");
    sdisplay("        Contents of which file?  *.ARC *.DOC\n        Contents of which file? *.* READ.ME\n\n");
    if (time(NULL) > quit_time)
        terminate(1);
    return;
}

/*--------------------------------------------------------------------------*/
/* Print out the list of file names inside an archive that's already been   */
/* read in. Used for getting the name of the text file to display.          */
/*--------------------------------------------------------------------------*/

void short_list(char *infile)
{
    int     i = 0;

    ctrl_err = 1;
    if (time(NULL) > quit_time)
        terminate(1);
    play("\nList of files in %s\n\n",infile);
    do {
        play(" %14s %5ik    ",member[i].name,member[i].size);
        i++;
        if ((i % 3) == 0)
            sendbyte('\n');
        } while (i <= mem_used);
    sendbyte('\n');
    return;
}
/*--------------------------------------------------------------------------*/
/* Get the name of a member of an archive from a user                       */
/*--------------------------------------------------------------------------*/

int get_mbr_name(char *name)
{
    char    *buf;
    char    *get_file;
    int     i;
    int     test = 0;

#ifdef DOLZH
	if (!(flags & (ARC|ZIP|LZH))) {
#else
    if (!(flags & (ARC|ZIP))) {
#endif
        sdisplay("\nSorry, Can't handle this type of file.\n\n");
        return(1);
        }

    get_file = (char *)malloc(20);
    do {
        if (time(NULL) > quit_time)
            terminate(1);
        if (strlen(mbr) == 0) {
            short_list(name);
			sdisplay("\nWhich file?  [QUIT to stop. ? for help]   ");
            get_string(get_file);
            }
        else
            strcpy(get_file,mbr);

        if (strlen(get_file) < 1) {
            free(get_file);
            ctrl_err = 1;
            return(1);
            }
        else if ((strstr(get_file,".COM")) != NULL ||
            (strstr(get_file,".ARC")) != NULL ||
            (strstr(get_file,".ZIP")) != NULL ||
            (strstr(get_file,".PAK")) != NULL ||
            (strstr(get_file,".ZOO")) != NULL ||
            (strstr(get_file,".EXE")) != NULL ||
            (strstr(get_file,".OBJ")) != NULL) {
            play("Can't list %s\n",get_file);
            free(get_file);
            return(1);
            }
        else if (strcmp(get_file,"QUIT") == 0) {
            free(get_file);
            ctrl_err = 0;
            return(0);
            }
        else if (strcmp(get_file,"HELP") == 0) 
             list_help();

        else if (strchr(get_file,'*') != NULL) {
            if ((test = do_wild(name,get_file)) == -1) {
                free(get_file);
                return(0);
                }
            else
                continue;
            }
        else {
            for (i=0;i<=mem_used;i++) {
                ctrl_err = 1;
                if (time(NULL) > quit_time) {
                    ctrl_err = 0;
                    return(0);
                    }
                if (validate(get_file,member[i].name)) {
                    test++;
                    show_file(name,member[i].name);
                    ctrl_err = 1;
                    }
                }
            *mbr = EOS;
            *get_file = EOS;
            }        /* No wildcards */
        } while (get_file && ctrl_err);

    if (test == 0) {
        if ((buf = strrchr(name,'\\')) != NULL)
            play("No matches found in %s\n",buf);
        else
            play("No matches found in %s\n",name);
        }
    free(get_file);
    ctrl_err = 1;
    return(1);
}

/*--------------------------------------------------------------------------*/
/* Deal with wildcard requests by prompting users for each archive          */
/*--------------------------------------------------------------------------*/

do_wild(char *name, char *get_file)
{

    int     i;
    int     test = 0;
    char    ch;
    char    *check;

    check = strrchr(name,'\\');
    check++;
    for (i=0;i<=mem_used;i++) {
        ctrl_err = 1;
        if (validate(get_file,member[i].name)) {
            test++;
            if (dearc_free > member[i].size) {
                if (time(NULL) > quit_time)
                    terminate(1);
                if (strlen(mbr) != 0) {
                    play("\n List %14s in %s?\n\n",member[i].name,check);
                    sdisplay("      Y)ES (default)          N)o             S)top this archive\n");
                    sdisplay("      E)nd wildcards          Q)uit to OPUS    ");
                    if (!ctrl_err)
                        ch = 'E';
                    else
                        ch = (char) get_a_char();
                    sendbyte('\n');
                    switch(ch) {
                        case 'Q':
                        case 'q':     terminate(0);
                                      break;
                        case 'S':
                        case 's':     ctrl_err = 1;
                                      return(-1);
                        case 'E':
                        case 'e':     ctrl_err = 0;
                                      *mbr = EOS;
                                      *name = EOS;
                                      return(-1);

                        case 'n':
                        case 'N':     continue;

                        default :     show_file(name,member[i].name);
                                      break;
                        }        /* Do we really want to do this? */
                    }
                else
                    show_file(name,member[i].name);
                }        /* There's enough free disk space */
            else  {
                fprintf(Log_fp,"Not enough disk space to unpack %s : %ldK\n",
                    member[i].name,member[i].size);
                sdisplay("Sorry, can't unpack that file, too large...\n");
                if (time(NULL) > quit_time)
                    terminate(1);
                }
            }        /* End of validating file name */
        }        /* End of FOR loop */
    ctrl_err = 0;
    return(test);
}

/*--------------------------------------------------------------------------*/
/* Shell to un-archive a file                                               */
/*--------------------------------------------------------------------------*/

void show_file(char *name,char *member)
{
    int     result = 100;
    char    get_file[MAX_PATH];


    sdisplay("\nWorking.....\n");
    sprintf(get_file,"%s\\%s",dearc_path,member);
    if (flags & WANTS_MORE)
        flags |= MORE;
    line %= (screen -2);
    ctrl_err = 1;
    if (flags & DEBUG) {

#ifdef TURBOC
        fprintf(Log_fp,"Free Memory = %u\n",coreleft());
#else
        fprintf(Log_fp,"Free Memory = %u\n",_memavl());
#endif
        fprintf(Log_fp,"Output = %s\nInput = %s\nMember = %20s  Flag = %04X\n",
            get_file,name,member,flags);
        }
	if (flags & ARC)
#ifdef PAKIT
					result = unpak(name,get_file); 
#else
                    result = spawnlp(P_WAIT,"pak.exe","pak.exe",
                        "ewa",name,get_file,NULL);
#endif
	else if (flags & ZIP)
					result = unzip(name,get_file);

#ifdef DOLZH
	else if (flags & LZH)
                    result = unlzh(name,get_file);
#endif

    if (result == 0)
        list_file(get_file);
    else {
        play("Error reading %s from %s\n",member,name);
        fprintf(Log_fp,"Error %02d Reading %s from %s\n",result,member,name);
        if (result <0)
            terminate(errno);
        }
    unlink(get_file);
    return;
}

/*--------------------------------------------------------------------------*/
/* List the actual text that has been pulled out of the archive             */
/*--------------------------------------------------------------------------*/

void list_file(char *name)
{
    char    *one_line;
    char    *result;
    int     count;
    FILE    *infp;
    long    now;

    time(&now);
    fprintf(Log_fp,"FVIEW Listing %s %s",name,ctime(&now));
    
    if ((infp = fopen(name,"rt")) != NULL) {

        one_line = (char *) malloc(100);
        do {
            count = 0;
            result = one_line;
            do {
                *result = (char) fgetc(infp);
                if (*result == '\n' || *result == '\r')
                    count = 81;
                else if (!isprint(*result))
                    *result = ' ';
                result++;
                count++;
                } while (*result != '\n' && count < 81);
            *result = EOS;
            sdisplay(one_line);
            } while(ctrl_err && result && !feof(infp));
        free(one_line);
        fclose(infp);
        }
    return;
}

/*--------------------------------------------------------------------------*/
/* Validate that the name of a member of an archive that a user has asked   */
/* to read actually exists. You can't pass "*.*" to the unarchive program!  */
/*--------------------------------------------------------------------------*/

int validate(char *name,char *target)

{
    char    *pt1;
    char    *pt2;
    char    real[14];
    char    ext[4];
    int     m1 = 0;
    int     l1;
    int     l2;

	if (flags & FOSSIL && !(Comm_CD()))
		terminate(3);

    if ((strstr(target,".COM")) != NULL ||
        (strstr(target,".ARC")) != NULL ||
        (strstr(target,".ZIP")) != NULL ||
        (strstr(target,".PAK")) != NULL ||
        (strstr(target,".ZOO")) != NULL ||
        (strstr(target,".EXE")) != NULL ||
        (strstr(target,".OBJ")) != NULL)
            return(0);        /* Can't deal with these */

    if (strcmp(name,"*.*") == 0)
        return(1);

    if (strcmp(name,target) == 0)
        return(1);

    strcpy(real,name);        /* Work on a copy, not the original */

/* Match root name */
    if ((pt1 = strchr(real,'.')) != NULL) {        /* Parse file name */
        *pt1 = EOS;
        strcpy(ext,++pt1);
        }
    if ((pt1 = strchr(real,'*')) != NULL) {
        if (real[0] != '*') {
            *pt1 = EOS;
            l1 = strlen(real);
            if (strnicmp(real,target,l1) != 0)
                return(0);
            else
                m1 = 1;
            }
        else
            m1 = 1;
        }
    else {
        l1 = strlen(real);
		if (strchr(target,'.') != NULL) {
			l2 = 0;
			pt2 = target;
			while (*pt2++ != '.')
				l2++;
            }
        else
            l2 = strlen(target);

        if (l1 >= l2)
            l1 = l2;
        if (strnicmp(real,target,l1) != 0)
            return(0);
        else
            m1 = 1;
        }        /* End of matching filename */

/* Try matching extensions */
    if ((pt1 = strchr(ext,'*')) != NULL) {
        if (ext[0] == '*' && m1 == 1)
            return(1);
        else {
            *pt1 = EOS;
            l1 = strlen(ext);
            if ((pt1 = strchr(target,'.')) != NULL) {
                pt1++;
                if ((strnicmp(ext,pt1,l1) == 0) && m1 == 1)
                    return(1);
                else
                    return(0);
                }
            if (strlen(ext) == 0 && m1 == 1)
                return(1);
            else
                return(0);
            }
        }        /* End of wildcard in Extension */
    else {
        if ((pt1 = strchr(target,'.')) != NULL) {
            pt1++;
            l1 = strlen(pt1);
            if ((strnicmp(ext,pt1,l1) == 0) && m1 == 1)
                return(1);
            else
                return(0);
            }
        else
            if (strlen(ext) == 0 && m1 == 1)
                return(1);
        return(0);
        }
}
/*--------------------------------------------------------------------------*/
/* Get a string of characters from a remote user.                           */
/*--------------------------------------------------------------------------*/

void    get_string(char *buf)
{
    char    ch = EOS;
    char    *start;

    start = buf;        /* Used to prevent user BS past start of line */

    if (!ctrl_err)
        return;
    while((ch = (char) get_a_char()) != '\r') {
        ch = toupper(ch);
        if (ch != 0x08) {
            *buf++ = ch;
            sendbyte(ch);
            }
		else if (buf>start) {
            ch = ' ';
            sendbyte(ch);
			sendbyte(0x08);
			sendbyte(0x08);
			sendbyte(ch);
            sendbyte(0x08);
			*--buf = EOS;
            }
        }
    *buf++ = EOS;
    sendbyte('\n');
    return;
}

/*--------------------------------------------------------------------------*/
/* Check for the existence of a CFG file 1.03 people                        */
/*--------------------------------------------------------------------------*/
void    check_cfg(char *Log)
{
    FILE    *cfg;
    char    *result;
    char    *check;
    char    *aline;

    if ((cfg = fopen("FVIEW.CFG","rt")) == NULL)
        return;
    aline = (char *) malloc(120);
    do {
        result = fgets(aline,80,cfg);
        check = strrchr(aline,'\n');
        *check = EOS;
        if ((check = strchr(aline,';')) != NULL)
            *check = EOS;
        if (strlen(aline) > 0) {
            if (strnicmp(aline,"Log",3) == 0) {
                check = get_next(aline);
                strcpy(Log,check);
                }
            else if (strnicmp(aline,"dearc",5) == 0) {
                check = get_next(aline);
                strcpy(dearc_path,check);
                }
            else if (strnicmp(aline,"System",6) == 0) {
                check = get_next(aline);
                strcpy(Sys_Path,check);
                }
            else if (strnicmp(aline,"noshow",6) == 0) 
                flags |= NO_SHOW;
            else if (strnicmp(aline,"debug",5) == 0)
                flags |= DEBUG;
            else if (strnicmp(aline,"watch",5) == 0)
                if (flags & FOSSIL)
                    flags |= WATCH;
            }        /* End of getting matches for flags */
        } while(result != NULL && !feof(cfg));
    free(aline);
    fclose(cfg);
    return;
}

/*--------------------------------------------------------------------------*/
/* Parse lines in CFG file if needed                                        */
/*--------------------------------------------------------------------------*/

char *get_next(char *line)
{
    char    *test;
    char    *test1;

    test = line;
    while (!isspace(*test) && (++test));
    while (isspace(*test) && (++test));
    test1 = test;
    while (!isspace(*test1) && (++test1));
    *test1 = EOS;
    return(test);
}
/*--------------------------------------------------------------------------*/
/* If user has a "SET FVIEW=...." in environment                            */
/*--------------------------------------------------------------------------*/
void    parse_env(char *env,char *Log)
{
    char    *test1;

    test1 = env;
    while(*env && *env > 0x1f) {
        while (!isspace(*test1) && (++test1));
        *test1 = EOS;
        ++test1;
        if (*env == '-' ||
            *env == '/') {
            env++;
            switch(toupper(*env)) {

                case '0':   flags |= OPUS_10;
                            break;

                case 'D':    strcpy(dearc_path,++env);
                            break;

                case 'L':    strcpy(Log,++env);
                            break;

                case 'S':   strcpy(Sys_Path,++env);
                            break;

                case 'G':    flags |= DEBUG;
                            break;

                case 'N':    flags |= NO_SHOW;
                            break;

                case 'W':    flags |= WATCH;
                            break;

                }        /* End of switch */
            }        /* end of finding '-' */
        env = test1;
        }        /* end of while(env) loop */
    return;
}

