//----------------------------------------------------------------------------
//   Application: NotePad
//     File Name: NOTE.PRG
//
//        Author: Wilson H. Yuen
//  Date created: 04-02-93
//  Time created: 10:04:53pm
//     Make File: Note.RMK
//     Exec File: Note.EXE
//     Copyright: Wilson H. Yuen
//
//   Description: Word processor using the new Funcky II Notepad Class.
//
//                Features:
//
//                ENTER       - Move cursor to the next line.  Insert line
//                              if insert mode is on.
//                SPACE       - Delete character under cursor and move
//                              cursor one character to the right.  Insert
//                              one character if insert mode is on.
//                ESC         - Exit edit mode.  If changes were made the
//                              system will prompt to save their changes.
//                DEL         - Delete character under cursor, or current
//                              blocked text.
//                INS         - Toggle insert mode.
//                BACKSPACE   - Delete previous character.
//                LEFT ARROW  - Move cursor one character to the left.
//                RIGHT ARROW - Move cursor one character to the right.
//                UP ARROW    - Move cusror up one line.
//                DOWN ARROW  - Move cursor down one line.
//                PGUP        - Move cursor one page up.
//                PGDN        - Move cursor one page down.
//                HOME        - Move cursor to the beginning of the line.
//                END         - Move cursor to the end of the line.
//                TAB         - Tab four characters to the right.
//
//                CTRL-LEFT   - Move cursor to the first character of the
//                              previous word.
//                CTRL-RIGHT  - Move cursor to the first character of the
//                              next word.
//                CTRL-PGUP   - Move cursor to the top of the text.
//                CTRL-PGDN   - Move cursor to the end of the text.
//                CTRL-HOME   - Move cursor to the top of the window.
//                CTRL-END    - Move cursor to the bottom of the window.
//                CTRL-BS     - Delete previous word.
//                CTRL-F5     - Center a line or block of text.
//                CTRL-F6     - Left justify a line of text.
//                CTRL-F7     - Right justify a line of text.
//                CTRL-F8     - Justify the current paragraph.
//                CTRL-U      - Restore a previously deleted block of text.
//                CTRL-Y      - Delete to end of line, starting at cursor
//                              position.
//
//                ALT-INS     - Insert text that was last blocked into
//                              buffer starting at cursor position.
//                ALT-C       - BLOCK COPY: Copy a block of text.
//                              Press Alt-C to start blocking.  Use arrow
//                              keys to block text.  Press Enter to end
//                              blocking.  Move cursor to the target
//                              location.  Press Enter again to copy text
//                              to new location.  Press + to copy the block
//                              to the scratch pad. Press Esc or Alt-C before
//                              Enter to cancel copying.
//
//                ALT-D       - DELETE BLOCK: Delete a block of text.
//                              Press Alt-D to start blocking.  Use arrow
//                              keys to block text.  Press Enter to delete
//                              blocked text.  Press + to copy the block to
//                              the scratch pad. Press Esc or Alt-D before
//                              Enter to cancel deletion.
//
//                ALT-F       - SEARCH: Non-case sensitive search forward
//                              or backward.
//
//                ALT-M       - MOVE BLOCK: Move a block of text.
//                              Press Alt-M to start blocking.  Use arrow
//                              keys to block text.  Press Enter to end
//                              blocking.  Move cursor to the target
//                              location.  Press Enter again to move text
//                              to new location.  Press + to copy the block
//                              to the scratch pad.  Press Esc or Alt-M before
//                              Enter to cancel moving process.
//
//                ALT-R       - Read an ASCII file into current buffer.
//                ALT-T       - Search and replace.
//                ALT-S       - Save text and exit edit mode.
//                ALT-U       - Undelete previous deleted text.
//                ALT-W       - WRITE BLOCK: Write the text or a block of
//                              text to file. Press Alt-W to start blocking.
//                              Use arrow keys to block text.  Press Enter
//                              to end block.  Enter name of the file to
//                              write the text to.  Press + to copy the block
//                              to the scratch pad.  Press Esc or Alt-W before
//                              Enter to cancel process.
//
//     Revisions:
//
//----------------------------------------------------------------------------
#include "Inkey.ch"


//----------------------------------------------------------------------------
//           Name: Note()
//        Purpose: Function used to demonstrate how to use my version of
//                 MemoEdit() to replace Clipper's MemoEdit()
//
//         Author: Wilson H. Yuen
//   Date created: 04-02-93
//   Time created: 11:29:36pm
//      Copyright: Wilson H. Yuen
//
//         Syntax: Note() --> NIL
//
//   Return Value: NIL
//
//----------------------------------------------------------------------------
Function Note()
    local cChoice    := "Y"    //-- default reponse
    local cInterface := "N"    //-- N-NotePad interface
    local aFunc      := {}     //-- functions specific to this application
    local lEdit      := .t.    //-- memo can be edited
    local cMemo                //-- memo text
    local cHelpText            //-- name of help text
    local lNPInterFace         //-- TRUE - NotePad interface
    local getlist    := {}

    SETCANCEL(.F.)             //-- must disable termination keys to use the block copy function
    Altd(0)                 //-- must deactivate Alt-D to use the block delete function

    SET(_SET_SCOREBOARD, .f. ) //-- turn scoreboard off


    //----------------------------
    //  open demo database
    //----------------------------
    cls()
    Use tickmast

    Do while .t.
        cls
        @ 10,10 say "Type of keyboard mapping:" get cInterface pict "!"
        @ 11,10 say "N-NotePad  W-WordPerfect"
        read
        If lastkey() == K_ESC
           Exit
        elseif ! cInterFace $ "N~W"
           Alert({"Keyboard mapping must be either:",;
                  "N - NotePad    ",;
                  "W - WordPerfect"})
           loop
        Endif


        aFunc := {}  //-- reset
        If cInterface == "N"
           cHelpText    := "NPHelp.txt"
           lNPInterface := .t.
           aadd(aFunc, {"STATUSLINE" , "~F~1=Help"+space(27)+"Ctrl-P=Print"+space(26)+"~E~s~c=Exit" })  //-- help status line
        Else
           cHelpText    := "WP5Help.txt"
           lNPInterface := .f.
           aadd(aFunc, {"STATUSLINE" , "~F~1=Help"+space(27)+"Ctrl-P=Print"+space(27)+"~F~7=Exit" })    //-- WP5 help status line
        Endif
        aadd(aFunc, {K_CTRL_P     , {|oEdit| PrtMemo(oEdit:Buffer) }})      //-- print memo
        HelpText(cHelpText)         //-- init help text to use
        NPInterface(lNPInterface)   //-- interface to use

        cMemo  := tickmast->text                                   //-- get memo text
        cMemo := NPMemoEdit( cMemo, 8, 8, 19, 74, lEdit, aFunc )   //-- edit memo text


        //-----------------------------
        // save changes
        //-----------------------------
        If ! cMemo == tickmast->text          //-- any changes
            Rlock()                           //-- lock record
            tickmast->text := cMemo           //-- update field
        Endif

        cls()
        @ 10,10 say "Get next memo (y/n)?" get cChoice    pict "!"
        read

        if cChoice == "N" .or. lastkey() == K_ESC
            Exit
        endif

        dbskip()
        If eof()
            dbgotop()
        Endif

    enddo

   cls()

Return(NIL)
* eof Note()
*
*
//----------------------------------------------------------------------------
//           Name: PrtMemo()
//        Purpose: Print memo
//
//         Author: Wilson H. Yuen
//   Date created: 04-15-93
//   Time created: 08:40:33pm
//      Copyright: Wilson H. Yuen
//
//         Syntax: PrtMemo(cText) --> NIL
//
//       Argument: cText - text to print.
//
//   Return Value: NIL
//
//    Description: Print memo.
//
//        Example: PrtMemo(cText)
//
//----------------------------------------------------------------------------
Static Function PrtMemo(cText)
    //-- enter code here to print your memo.
    Alert("This is where you print your memo")
Return(NIL)
* eof PrtMemo()
*
*
