
*--- Includes ---*

#include system.hdr
#include bits.hdr
#include string.hdr
#include fileio.hdr
#include screen.hdr
#include error.hdr
#include io.hdr
#include warn.hdr
#include xsvforce.hdr

*--- Definitions ---*

#pragma W_FUNC_PROC-
#pragma W_INDIRECT-
#pragma W_EXTERN-

#define  TRUE            .T.
#define  FALSE           .F.
#define  NULL            ""
#define  QUOTE           CHR(34)
#define  CR              CHR(13)
#define  LF              CHR(10)
#define  EOF_BYTE        0x1A

#DEFINE  BLACK_CYAN           003
#DEFINE  BLACK_LIGHT_GREY     007
#DEFINE  BLACK_LIGHT_BLUE     009
#DEFINE  BLACK_LIGHT_GREEN    010
#DEFINE  BLACK_LIGHT_CYAN     011
#DEFINE  BLACK_LIGHT_RED      012
#DEFINE  BLACK_LIGHT_MAGENTA  013
#DEFINE  BLACK_YELLOW         014
#DEFINE  BLACK_WHITE          015
#DEFINE  BLUE_BLACK           016
#DEFINE  BLUE_LIGHT_GREEN     026
#DEFINE  BLUE_LIGHT_RED       028
#DEFINE  BLUE_LIGHT_MAGENTA   029
#DEFINE  BLUE_YELLOW          030
#DEFINE  BLUE_WHITE           031
#DEFINE  CYAN_BLACK           048
#DEFINE  CYAN_BLUE            049
#DEFINE  CYAN_RED             052
#DEFINE  CYAN_LIGHT_GREEN     058
#DEFINE  CYAN_LIGHT_MAGENTA   061
#DEFINE  CYAN_YELLOW          062
#DEFINE  CYAN_WHITE           063
#DEFINE  RED_BLACK            064
#DEFINE  RED_LIGHT_GREEN      074
#DEFINE  RED_LIGHT_CYAN       075
#DEFINE  RED_YELLOW           078
#DEFINE  RED_WHITE            079

#DEFINE  K_BS                8
#DEFINE  K_TAB               9
#DEFINE  K_ENTER            13
#DEFINE  K_C_W              23
#DEFINE  K_ESC              27
#DEFINE  K_S_TAB         32783
#DEFINE  K_F1            32827
#DEFINE  K_F3            32829
#DEFINE  K_F4            32830
#DEFINE  K_F5            32831
#DEFINE  K_F9            32835
#DEFINE  K_HOME          32839
#DEFINE  K_UP            32840
#DEFINE  K_PG_UP         32841
#DEFINE  K_LEFT          32843
#DEFINE  K_RIGHT         32845
#DEFINE  K_END           32847
#DEFINE  K_DOWN          32848
#DEFINE  K_PG_DOWN       32849
#DEFINE  K_C_RIGHT       32884
#DEFINE  K_C_LEFT        32883
#DEFINE  K_C_END         32885
#DEFINE  K_C_PG_DOWN     32886
#DEFINE  K_C_HOME        32887
#DEFINE  K_C_PG_UP       32900

*--- Global Variables ---*

VARDEF EXTERN
   BYTE                  __color_std, __color_enhcd
   UINT                  __errcode
ENDDEF

VARDEF
   CHAR                  Argv[5], Work, ADrvs
   CHAR(128)             Cmd_Line
   CHAR(80)              SCDR, FromFile, ToFile, Files[99]
   CHAR(5)               Options
   CHAR(4)               Switch
   CHAR(1)               SDisk, TDisk
   FILE                  Disk_ID
   INT                   Message_Number, Next_Row, Start_Col, Start_Row, SCD, F_Nbr
   UINT                  Argc, Counter, GSts
   LOGICAL               DFlag, QFlag, FDrive
   LONG                  NInc, WCtr
   ULONG                 Byt_Total, Dsk_Free
ENDDEF

FUNCTION LONG i_round PROTOTYPE
  PARAMETERS CONST DBL argument

FUNCTION INT _diskstatus PROTOTYPE
  PARAMETERS VALUE INT Drv

FUNCTION INT _isdrive PROTOTYPE
  PARAMETERS CONST CHAR SDrv

FUNCTION INT _isfloppy PROTOTYPE
  PARAMETERS CONST CHAR SDrv

FUNCTION CHAR _drivestr PROTOTYPE
  PARAMETERS CONST CHAR ADrv

PROCEDURE Display_Help
  CLEAR
  ? 'UNITE - File Unification Utility'
  ? '    Copyright (C) MBSI 1993. All rights reserved.'
  ? " "
  ? 'UNITE [d:][path]file [d:][path]file.ext /F|/Nxx [/O:options]'
  ? '  where [d:][path]file       Valid DOS name of file(s) to unite'
  ? '        [d:][path]file.ext   Name of output file'
  ? '        /F           -or-    Build from floppy diskette(s)'
  ? '          /Nxx               Number of increments(1-99)'
  ? '        [/O:options] are: D  Delete original file(s)'
  ? '                          Q  Quiet mode'
  ? " "
  ? 'Examples: UNITE INSTALL INSTALL.BIN /N3'
  ? '          UNITE B:TEST C:\TEST\TEST.EXE /F /O:DQ'
  ? " "
  QUIT
ENDPRO

PROCEDURE Clear_Args
  VARDEF
    UINT x
  ENDDEF
  FOR x = 0 TO (5 - 1)
    argv[x] = &NULL
  NEXT
ENDPRO

PROCEDURE Cmd_Line_Error
  ?? 'Missing "...'
  QUIT 99
ENDPRO

FUNCTION CHAR Rmv_Redndt
  PARAMETERS CONST char str_to_cmprs
  VARDEF
    UINT where
    CHAR ckstr,newstr,tmpstr
  ENDDEF
  ckstr  = str_to_cmprs
  where  = AT(" ",ckstr)
  newstr = &NULL
  DO WHILE where > 0
    tmpstr = LEFT(ckstr,where-1)
    ckstr  = SUBSTR(ckstr,where+1,LEN(ckstr)-where)
    ckstr  = LTRIM(ckstr)
    where  = AT(" ",ckstr)
    newstr = newstr+" "+tmpstr
  ENDDO
  ckstr = newstr+" "+ckstr
  RETURN LTRIM(ckstr)
ENDPRO

FUNCTION INT Count_Chr
  PARAMETERS CONST CHAR(1) chr_to_cnt, CONST CHAR str_to_cnt
  VARDEF
    UINT x,where,count_quotes
    CHAR ckstr
  ENDDEF
  count_quotes = 0
  ckstr        = LTRIM(RTRIM(str_to_cnt))
  x            = 0
  where        = AT(chr_to_cnt,ckstr)
  IF LEN(ckstr) > 0
    x = 1
  ENDIF
  DO WHILE where > 0
    x     = x+1
    ckstr = SUBSTR(ckstr,where+1,LEN(ckstr)-where)
    IF SUBSTR(ckstr,1,1) == &QUOTE
       x            = x-1
       count_quotes = count_quotes + 1
       ckstr        = SUBSTR(ckstr,2,LEN(ckstr)-1)
       where        = AT(&QUOTE,ckstr)
       IF where > 0
         count_quotes = count_quotes + 1
         LOOP
       ENDIF
       ckstr = LTRIM(ckstr)
    ENDIF
    where = AT(chr_to_cnt,ckstr)
  ENDDO
  IF count_quotes > 0
    IF (count_quotes % 2) > 0
      Cmd_Line_Error()
    ENDIF
  ENDIF
  RETURN x
ENDPRO

PROCEDURE Parse_Cmd_Line
  PARAMETERS CONST CHAR(128) cmd_line
  VARDEF
    CHAR(200)          new_cmd
    UINT               x,where
  ENDDEF
  new_cmd = LTRIM(RTRIM(cmd_line))
  new_cmd = Rmv_Redndt(new_cmd)
  new_cmd = GET_EXEC()+" "+new_cmd
  Clear_Args()
  argc = Count_Chr(" ",new_cmd)
  x = 0
  REPEAT
    where = AT(" ",new_cmd)
    IF where > 0
      IF SUBSTR(new_cmd,1,1) == &QUOTE
        new_cmd = SUBSTR(new_cmd,2,LEN(new_cmd)-1)
        where   = AT(&QUOTE,new_cmd)
        argv[x] = SUBSTR(new_cmd,1,where-1)
        new_cmd = SUBSTR(new_cmd,where+1,LEN(new_cmd)-where)
        new_cmd = LTRIM(new_cmd)
      ELSE
        argv[x] = SUBSTR(new_cmd,1,where-1)
        new_cmd = SUBSTR(new_cmd,where+1,LEN(new_cmd)-where)
      ENDIF
    ELSE
      argv[x] = LTRIM(RTRIM(new_cmd))
      new_cmd = &NULL
    ENDIF
    IF LEFT(argv[x],1) == "/"
      argv[x] = "-" + RIGHT(argv[x],LEN(argv[x])-1)
    ENDIF
    x = x+1
  UNTIL x = argc
ENDPRO

PROCEDURE Clear_Line
  @ Next_Row,0 TO Next_Row,78 CLEAR
  @ Next_Row,0
ENDPRO

PROCEDURE Force_Error
  IF QFlag
    SET CONSOLE OFF
    SET PRINTER TO 'UNITE.ERR'
    SET PRINT ON
  ELSE
    Clear_Line()
  ENDIF
  ?? 'RTE-'+I_STR(__errcode)+":"
  ?? e_message()
  IF QFlag
    SET PRINT OFF
    SET PRINTER TO
    SET CONSOLE ON
  ENDIF
  SELECT_DRIVE(SCD)
  CHDIR(SCDR)
  QUIT __errcode
ENDPRO

PROCEDURE Display_Error
  PARAMETERS INT Message_Number
  IF QFlag
    SET CONSOLE OFF
    SET PRINTER TO 'UNITE.ERR'
    SET PRINT ON
  ELSE
    Clear_Line()
  ENDIF
  DO CASE
    CASE Message_Number == 1
      ?? 'Invalid disk drive.'
      ?  'Valid drives are '+RTRIM(ADrvs)+"."
    CASE Message_Number == 2
      ?? 'Valid options are /O: followed by D, and/or Q.'
    CASE Message_Number == 3
      ?? 'Invalid switch.'
      ?  'Valid switches are /F, or /Nxx.'
    CASE Message_Number == 4
      ?? '/F switch only valid for floppy diskette(s).'
    CASE Message_Number == 5
      ?? 'DIVIDE.ID disk id not found.'
    CASE Message_Number == 6
      ?? 'Input file(s) not found.'
    CASE Message_Number == 7
      ?? 'Invalid number of increments.'
    CASE Message_Number == 8
      ?? 'Insufficient disk space available for operation.'
      ?  'Operation requires '+LTRIM(STR(Byt_Total,8,0))+' bytes.'
    CASE Message_Number == 20
      ?? 'UNITE has been aborted!'
    CASE Message_Number == 30
      ?? 'UNITE failed.'
  ENDCASE
  IF QFlag
    SET PRINT OFF
    SET PRINTER TO
    SET CONSOLE ON
  ENDIF
  SELECT_DRIVE(SCD)
  CHDIR(SCDR)
  QUIT Message_Number
ENDPRO

PROCEDURE Wait_Message
  PARAMETERS CONST DBL WNbr
  WCtr = 0
  DO WHILE WCtr < WNbr
    WCtr = WCtr + 1
  ENDDO
ENDPRO

PROCEDURE File_Build
  PARAMETERS CHAR(80) fi, CHAR(80) fo
  VARDEF
    UINT      i, o, j
    ULONG     k, l
    BYTE      Buf[32768]
  ENDDEF
  IF EXIST(fi)
    FB_OPEN(i, fi, &B_READ)
    IF EXIST(fo)
      FB_OPEN(o, fo, &B_WRITE)
    ELSE
      FB_OPEN(o, fo, &B_CWRITE)
    ENDIF
    FB_SEEK(i,0,&FB_BEGIN)
    FB_SEEK(o,0,&FB_END)
    k = 0
    l = 0
    DO WHILE k < FILESIZE(fi)
      j = 0
      REPEAT
        j = j + 1
        Buf[j] = 0
      UNTIL j = 32767
      l = FILESIZE(fi) - k
      IF l > 32767
        FB_READ(i,Buf[],32767)
        FB_WRITE(o,Buf[],32767)
        k = k + 32767
      ELSE
        FB_READ(i,Buf[],l)
        FB_WRITE(o,Buf[],l)
        k = k + l
      ENDIF
    ENDDO
    FB_CLOSE(i)
    FB_CLOSE(o)
  ENDIF
ENDPRO

FUNCTION LOGICAL Chk_Dsk
  PARAMETERS CONST CHAR(1) get_dsk
  VARDEF
    UINT     dtype
    CHAR     gdsk
  ENDDEF

  gdsk = get_dsk + ":"
  IF _isdrive(gdsk) <> 1
    Message_Number = 1
    Display_Error(Message_Number)
  ENDIF
  IF _isfloppy(gdsk) == 1
    FDrive = &TRUE
  ELSE
    FDrive = &FALSE
  ENDIF
  RETURN &TRUE
ENDPRO

PROCEDURE Load_Files
  VARDEF
     CHAR(12)              S_FFil
     CHAR(03)              S_FExt
     LONG                  S_FSiz
     UINT                  GKey, DSts
     LOGICAL               S_Flag, GFlag
  ENDDEF

  F_Nbr  = 0
  IF SUBSTR(Switch,1,2) <> '-F'
    IF FIND_FIRST(RTRIM(FromFile)+'.*',&FIND_ARCHIVE)
      REPEAT
        IF FIND_FATTR() == 0x20
          S_FExt  = RTRIM(FIND_FEXT())
          S_FSiz  = FIND_FSIZE()
          IF I_VAL(S_FExt) > 0
            F_Nbr = F_Nbr + 1
            Files[I_VAL(S_FExt)] = RTRIM(FromFile)+"."+RTRIM(S_FExt)
            Byt_Total = Byt_Total + S_FSiz
          ENDIF
        ENDIF
      UNTIL .NOT. FIND_NEXT()
    ENDIF
    IF F_Nbr == 0
      Message_Number = 6
      Display_Error(Message_Number)
    ENDIF
    IF F_Nbr < NInc
      Message_Number = 7
      Display_Error(Message_Number)
    ENDIF
    Dsk_Free = DISKSPACE(ASC(TDisk)-65)
    IF Dsk_Free < Byt_Total
      Message_Number = 8
      Display_Error(Message_Number)
    ENDIF
  ELSE
    S_Flag = &TRUE
    DO WHILE S_Flag
      F_Nbr = F_Nbr + 1
      ?? CHR(7)
      Clear_Line()
      ?? 'Please insert Diskette '+I_STR(F_Nbr)+' in the '+SDisk+': Drive...ENTER when ready, or ESC to abort...'
      REPEAT
        GKey = GET_KEY()
      UNTIL ((GKey == &K_ENTER) .OR. (GKey == &K_ESC))
      IF GKey == &K_ESC
        Message_Number = 20
        Display_Error(Message_Number)
      ENDIF
      GFlag = &FALSE
      DO WHILE .NOT. GFlag
        REPEAT
          IF FDrive
            DSts = _diskstatus(ASC(SDisk)-65)
            DO CASE
              CASE DSts == 1
                ?? CHR(7)
                Clear_Line()
                ?? 'Diskette is write-protected...press ENTER when ready, or ESC to abort...'
                GFlag = &FALSE
              CASE DSts == 3
                ?? CHR(7)
                Clear_Line()
                ?? 'Drive is not ready...press ENTER when ready, or ESC to abort...'
                GFlag = &FALSE
              CASE DSts == 13
                ?? CHR(7)
                Clear_Line()
                ?? 'Diskette is not formatted...press ENTER when ready, or ESC to abort...'
                GFlag = &FALSE
            ENDCASE
          ELSE
            GFlag = &TRUE
          ENDIF
          IF .NOT. GFlag
            REPEAT
              GKey = GET_KEY()
            UNTIL ((GKey == &K_ENTER) .OR. (GKEY == &K_ESC))
            IF GKey == &K_ESC
              Message_Number = 20
              Display_Error(Message_Number)
            ENDIF
          ENDIF
        UNTIL GFlag
        GFlag = &FALSE
        IF .NOT. EXIST(SDisk+':\DIVIDE.ID')
          ?? CHR(7)
          Clear_Line()
          ?? 'Invalid disk id...load new diskette and press ENTER, or ESC to abort...'
          REPEAT
            GKey = GET_KEY()
          UNTIL ((GKey == &K_ENTER) .OR. (GKEY == &K_ESC))
          IF GKey == &K_ESC
            Message_Number = 20
            Display_Error(Message_Number)
          ENDIF
        ELSE
          GFlag = &TRUE
        ENDIF
        GFlag = &FALSE
        F_OPEN(Disk_ID,SDisk+':\DIVIDE.ID',&F_READ,&F_TEXT)
        F_GETLN(Disk_ID, Work)
        F_CLOSE(Disk_ID)
        IF I_VAL(SUBSTR(Work,8,2)) <> F_Nbr
          ?? CHR(7)
          Clear_Line()
          ?? 'Wrong diskette...load correct diskette and press ENTER, or ESC to abort...'
          REPEAT
            GKey = GET_KEY()
          UNTIL ((GKey == &K_ENTER) .OR. (GKEY == &K_ESC))
          IF GKey == &K_ESC
            Message_Number = 20
            Display_Error(Message_Number)
          ENDIF
        ELSE
          GFlag = &TRUE
        ENDIF
      ENDDO
      IF FIND_FIRST(RTRIM(FromFile)+'.*',&FIND_ARCHIVE)
        IF FIND_FATTR() == 0x20
          S_FFil  = RTRIM(FIND_FSTR())
          S_FExt  = RTRIM(FIND_FEXT())
          S_FSiz  = FIND_FSIZE()
          Files[F_Nbr] = RTRIM(FromFile)+"."+RTRIM(S_FExt)
          Byt_Total = Byt_Total + S_FSiz
        ENDIF
      ENDIF
      Dsk_Free = DISKSPACE(ASC(TDisk)-65)
      IF Dsk_Free < Byt_Total
        Message_Number = 8
        Display_Error(Message_Number)
      ENDIF
      IF .NOT. QFlag
        Clear_Line()
        ?? 'Copying '+Files[F_Nbr]+' into '+RTRIM(ToFile)+'...'
      ENDIF
      File_Build(Files[F_Nbr],ToFile)
      IF SUBSTR(Work,1,6) == '*LAST*'
        S_Flag = &FALSE
      ENDIF
    ENDDO
    NInc = F_Nbr
  ENDIF
ENDPRO

FUNCTION int critical_error_handler
    PARAMETERS VALUE INT error_code, ;
               VALUE INT which_device, ;
               VALUE LOGICAL chr_device, ;
               VALUE LOGICAL ignore, ;
               VALUE LOGICAL retry, ;
               VALUE LOGICAL fail, ;
               VALUE INT disk_area, ;
               VALUE LOGICAL during_write, ;
               VALUE INT drive_id, ;
               VALUE LOGICAL drive
  VARDEF
    CHAR(50)   block_error[13]
    CHAR(25)   disk_string[4], chr_error_string[4]
    CHAR(80)   error_message, cmd_message
    CHAR(4)    options
    LONG       i
    INT        dos_code
    INT        j, k, l, m
  ENDDEF
  chr_error_string[0] = 'Standard input device'
  chr_error_string[1] = 'Standard output device'
  chr_error_string[2] = 'Null device'
  chr_error_string[3] = 'Clock device'
  disk_string[0] = 'DOS disk area'
  disk_string[1] = 'File allocation table'
  disk_string[2] = 'Disk directory'
  disk_string[3] = 'Disk data area'
  block_error[0] = 'Diskette is write-protected'
  block_error[1] = 'Device unknown'
  block_error[2] = 'Drive is not ready'
  block_error[3] = 'Unknown device command'
  block_error[4] = 'Checksum error in data'
  block_error[5] = 'Drive structure length'
  block_error[6] = 'Drive seek error'
  block_error[7] = 'Unrecognizable media'
  block_error[8] = 'Disk sector not found'
  block_error[9] = 'Printer is out of paper'
  block_error[10] = 'Write fault error'
  block_error[11] = 'Read fault error'
  block_error[12] = 'General failure error'
  IF chr_device
    error_message = chr_error_string[which_device]+" has failed!"
  ELSE
    IF drive
      IF during_write
        error_message = "Write error: "+block_error[error_code]+"!"
      ELSE
        error_message = "Read error: "+block_error[error_code]+"!"
      ENDIF
    ELSE
      error_message = disk_string[disk_area]+" corrupted!"
    ENDIF
  ENDIF
  l = LEN(error_message)
  IF l <= 30
    l = 30
  ENDIF
  i = I_ROUND(((80 - l))/2) - 1
  j = i
  k = j + l + 1
  SAVE_AREA(11,j,15,k)
  @ 11,j TO 15,k CLEAR
  FILL(11,j,15,k,"        "," ",&BLUE_YELLOW,&BLUE_YELLOW,0)
  __color_std = &BLUE_YELLOW
  @ 12,j+1 ?? error_message
  cmd_message = 'Abort'
  options     = "a"
  IF retry
    cmd_message = cmd_message + ', Retry'
    options     = options + "r"
  ENDIF
  IF ignore
    cmd_message = cmd_message + ', Ignore'
    options     = options + "i"
  ENDIF
  cmd_message = cmd_message + "?"
  m = LEN(cmd_message)
  IF m < l
    i = I_ROUND((l - m)/2)
    j = j + i
  ENDIF
  __color_std = &BLUE_LIGHT_RED
  @ 14,j ?? "A"
  __color_std = &BLUE_YELLOW
  ?? "bort"
  IF retry
    ?? ", "
    __color_std = &BLUE_LIGHT_GREEN
    ?? "R"
    __color_std = &BLUE_YELLOW
    ?? "etry"
  ENDIF
  IF ignore
    ?? ", "
    __color_std = &BLUE_WHITE
    ?? "I"
    __color_std = &BLUE_YELLOW
    ?? "gnore"
  ENDIF
  __color_std = &BLUE_YELLOW
  ?? "?"
  __color_std = &BLACK_LIGHT_GREY
  k = 0
  DO WHILE &TRUE
    k = GET_KEY()
    DO CASE
      CASE CHR(k) == "a"
        dos_code = 2
        RESTORE_AREA()
        SELECT_DRIVE(SCD)
        CHDIR(SCDR)
        Message_Number = 20
        Display_Error(Message_Number)
      CASE CHR(k) == "i"
        dos_code = 0
        EXIT
      CASE CHR(k) == "r"
        dos_code = 1
        EXIT
    ENDCASE
  ENDDO
  RESTORE_AREA()
  SELECT_DRIVE(SCD)
  CHDIR(SCDR)
  RETURN (dos_code)
ENDPRO

PROCEDURE force_main
  PARAMETERS CHAR(128) Cmd_Line

  CRITICAL(critical_error_handler)

  ON ERROR DO FORCE_Error

  DO CASE
    CASE RTRIM(LTRIM(Cmd_Line)) == '/?'
      Display_Help()
    OTHERWISE
      Clear_Args()
      Parse_Cmd_Line(Cmd_Line)
  ENDCASE
  IF argc > 5
    Display_Help()
  ENDIF
  IF argc < 4
    Display_Help()
  ENDIF

  Start_Row = ROW()
  Start_Col = COL()
  Next_Row  = ROW()
  IF Next_Row > 25
    Next_Row  = 25
  ENDIF
  SCD  = CURDRIVE()
  SCDR = CHR(SCD + 65)+":"+RTRIM(CURDIR(0))

  ADrvs = _drivestr(Work)

  SELECT_DRIVE(SCD)
  CHDIR(SCDR)

  FromFile = UPPER(argv[1])
  ToFile   = UPPER(argv[2])
  Switch   = UPPER(argv[3])
  Options  = &NULL
  IF Argc == 5
    Options = UPPER(argv[4])
  ENDIF
  IF SUBSTR(FromFile,2,1) == ":"
    SDisk = SUBSTR(FromFile,1,1)
    Chk_Dsk(SDisk)
  ENDIF
  TDisk = CHR(SCD + 65)
  IF SUBSTR(ToFile,2,1) == ":"
    TDisk = SUBSTR(ToFile,1,1)
    Chk_Dsk(TDisk)
  ENDIF
  IF LEN(Options) > 0
    Work = "D Q DQ QD"
    IF AT( SUBSTR(Options,4,LEN(Options)-3), Work ) == 0
      Message_Number = 2
      Display_Error(Message_Number)
    ENDIF
    Work = SUBSTR(Options,4,LEN(Options)-3)
    IF AT( "D", Work ) <> 0
      DFlag = &TRUE
    ENDIF
    IF AT( "Q", Work ) <> 0
      QFlag = &TRUE
    ENDIF
  ENDIF
  IF ((SUBSTR(Switch,1,2) <> '-F') .AND. ;
       (SUBSTR(Switch,1,2) <> '-N'))
    Message_Number = 3
    Display_Error(Message_Number)
  ENDIF
  IF SUBSTR(Switch,1,2) == '-F'
    IF .NOT. FDrive
      Message_Number = 4
      Display_Error(Message_Number)
    ENDIF
  ENDIF
  IF SUBSTR(Switch,1,2) == '-N'
    NInc = I_VAL(SUBSTR(Switch,3,LEN(Switch)))
    IF ((NInc == 0) .OR. (NInc > 99))
      Message_Number = 7
      Display_Error(Message_Number)
    ENDIF
  ENDIF

  IF EXIST(ToFile)
    ERASE ToFile
  ENDIF

  Load_Files()
  IF SUBSTR(Switch,1,2) <> '-F'
    Counter = 0
    DO WHILE Counter < F_Nbr
      Counter = Counter + 1
      IF .NOT. QFlag
        Clear_Line()
        ?? 'Copying '+RTRIM(Files[Counter])+' into '+RTRIM(ToFile)+'...'
      ENDIF
      File_Build(Files[Counter],ToFile)
      Wait_Message(10000)
    ENDDO
    Work = SUBSTR(Options,4,LEN(Options)-3)
    IF DFlag
      Counter = 0
      DO WHILE Counter < F_Nbr
        Counter = Counter + 1
        IF .NOT. QFlag
          Clear_Line()
          ?? 'Erasing '+RTRIM(Files[Counter])+'...'
        ENDIF
        Erase RTRIM(Files[Counter])
        Wait_Message(10000)
      ENDDO
    ENDIF
  ENDIF

  SELECT_DRIVE(SCD)
  CHDIR(SCDR)

  __color_std = &BLACK_LIGHT_GREY
  IF .NOT. QFlag
    Clear_Line()
    ?? 'UNITE completed successfully!'
  ENDIF

ENDPRO
