/* FTPFIDO.CMD - rexx script to get FidoNet mail via FTP Binkley Style. */

/*------------------------------------------------------------------
 * Version 1.5 by Jerry Gause 1:3651/9
 * Many thanks go to John Souvestre for the original base code
 * and of course to Patrick J. Mueller & Cliff Nadler for RxFtp.
 * Change global variables below to suit your system.
 * Change lines marked with "CFP!!!" to suit your provider.
 * Dlls needed for this script are: RxFtp, Rexxutil and Rexxlib.
 * This is tailored for Binkley style outbound. You need to use the FD version
 * and setup a seperate Binkley style outbound to pack out netmail.
 * I have made many changes to the original code including much more
 * mailer-like operation. I simply truncate the file the same way Bink would.
 * Lot's of error checking and logging of errors as well as normal
 * operation. If anything goes wrong, it is logged and the session
 * is aborted after 2 retries. 
 *------------------------------------------------------------------*/

'@echo off'
host = "0.0.0.0"
name = "xxxxxxx"
password = "xxxxxxx"
seqfile  = 'f:\bbs\ftpfido.seq'
Binkin = 'f:\binkley\inbound'   /* binkley inbound */
ftpin = 'd:\ftpin' /* Inbound for FTP */
mailbundle = 'd:\ftpin\00090327.*' /* Incoming mail bundles moved from ftpin to binkin */
outbound = 'f:\binkley\outbound'   /* Binkley style outbound */
bsy = 'f:\binkley\IHUB.BSY'      /* local file sent as remote busy flag */
remotebsyname = 'IHUB.BSY'    /* remote name for above */
avbps = 2000 /* Your average bps rate */
flg = 'f:\bbs\logs\Doing_ftp.flg' /* process flag */
logfile  = 'F:\bbs\logs\ftpfido.log' /* logfile for FTP */
errlog = 'f:\bbs\logs\error.log' /* a logfile for errors */
listfile  = 'F:\bbs\logs\ftplist.log' /* A list used for calculations */
fidosite = '0e4c0330' /* In hex of course */
fidobsy  = fidosite'.bsy'
fidohold = fidosite".hlo"
pktname = '0e4c0330.hut' /* Only hold mail is handled */ 
newname = '0e4c0330.pkt' /* Remote file name */
fixtic = 0 /* Set to 1 if you have blank lines in your tics   CFP!!! */
ticc = 'd:\ftpin\*.tic'

total_received = 0
Total_sent = 0
total_files = 0
sizethere = 0

Signal on Syntax Name ErrorStop
Signal on Halt Name Abort
Signal on Failure Name FailureStop

rc = stream(logfile,'C','open write')

call Lineout logfile ,date('N') Time('N') 'FTPFIDO starting up.'

Call SysCurState Off
Call CopyInfo

if RxFuncQuery("FtpLoadFuncs") then
   do
   rc = RxFuncAdd("FtpLoadFuncs","RxFtp","FtpLoadFuncs")
   rc = FtpLoadFuncs(quiet)
   end

if RxFuncQuery("SysLoadFuncs") then
   do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
   end

if RxFuncQuery("rexxlibregister") then
   do
   rc = RxFuncAdd('rexxlibregister','rexxlib','rexxlibregister')
   rc = rexxlibregister()
   end

/* Check the busy flag */
New=Directory(outbound)
IF Stream(fidobsy,'C', 'Query Exists') <>' ' Then
    Do
  say '[1;31m!Tosser Busy - Not this time...[0m'
rc = lineout(logfile,'!Tosser Busy - Not this time.')
  signal exit
    end
else
 do
 rc= doscreat(fidobsy) /* Set local busy flag */
if rc <> 1 Then
    Do
  say '[1;31m!Error creating busy flag.[0m'
rc = lineout(logfile,'!Error creating busyflag.')
  signal exit
    end
 end

IF Stream(flg,'C', 'Query Exists') <>' ' Then
    Do
  say '[1;31m!Must be running already.[0m'
rc = lineout(logfile,' Must be running already.')
New=Directory(outbound)
'del 'fidobsy '> nul: 2>&1'
 IF rc <> 0 Then
  Do
  say '[1;31m!Error deleting 'fidobsy'[0m'
  rc = lineout(logfile,'!Error deleting 'fidobsy)
  end
 signal exit
    end
else
 do
rc=doscreat(flg) /* Set process flag */
IF rc <> 1 Then
    Do
  say '[1;31m!Error creating flagfile.[0m'
rc = lineout(logfile,'!Error creating flagfile.')
  signal exit
    end
 end

/* Get the latest send sequence*/
seqstr = "0123456789abcdefghijklmnopqrstuvwxyz"
daywk = "mo tu we th fr sa su"

/* Contains the day and sequence*/
IF Stream(seqfile,'C', 'Query Exists') <>' ' Then
  Do
  line = LINEIN(seqfile)
  day = WORD(line, 1)
  if POS(day, daywk) = 0 then
    day = "mo"
  seq = WORD(line, 2)
  seqno = POS(seq, seqstr)
  if seqno = 0 then do
    seq = "0"
    seqno = 1
  end
 end
else do
  file = LINEOUT(seqfile, 'mo 0')
  seqno = 1
end
file = LINEOUT(seqfile)

rc = FtpSetBinary('Binary')

elapsed = time('e')

/*------------------------------------------------------------------
 * LOGON
 *------------------------------------------------------------------*/

rc = FtpSetUser(host, name, password) 

attached = FtpSys(siteinfo)
say '[1;44m'attached '[0m'
len = length(attached)
if len > 33 then                                               /* CFP!!! */
do
    rc = lineout(logfile,' Login successful')
    say '[1;44mLogin successful [0m'

    rc = FtpChDir('..')                                         /* CFP!!! */

    rc = FtpPut(bsy,remotebsyname)
    if err <> -1 & FTPERRNO <> '0' then
    do
    say '[1;31m!Error putting busy flag on remote.[0m'
    rc = lineout(logfile,'!Error putting busy flag on remote.')
    signal abort
    end

/*------------------------------------------------------------------
 * Change to remote inbound directory.
 *------------------------------------------------------------------*/

    rc = FtpChDir("in")                                      /* CFP!!!! */
    if err <> -1 & FTPERRNO <> '0' then
    do
    say '[1;31m!Error changing directory on remote.[0m'
    rc = lineout(logfile,'!Error changing directory on remote.')
    signal abort
    end

/*------------------------------------------------------------------
 * Send Raw Packets (.Hut)
 *------------------------------------------------------------------*/

New=Directory(outbound)

rc = SysFileTree(pktname,files.,"F")
if files.0 > 0 then
  do
	  filename = filespec("name", word(files.1,5))
	   Trunc = 0
	   Nuke = 1
	   Call Put filename word(files.1,5) word(files.1,3) newname
  end

/*------------------------------------------------------------------
 * Send Mail Bundles and files
 *------------------------------------------------------------------*/

IF Stream(fidohold,'C', 'Query Exists') <>' ' Then
 Do
  do until LINES(fidohold) = 0
    line = LINEIN(fidohold)
    /* Get the file name out of the path ect*/
    posfile = LASTPOS('\', line) + 1
    filename = SUBSTR(line, posfile)

   Select

     When Pos('^', line) = 1 then
      Do
     fullname = strip(line,l,'^')
      rc = SysFileTree(fullname,outfile.,"F")
      IF Stream(fullname,'C', 'Query Exists') <>' ' Then
       Do
      Trunc = 0
      Nuke = 1       
      Call Put filename word(outfile.1,5) word(outfile.1,3) filename
       end
       else do
	   say '[1;31m!'fullname' not found .[0m'
	   rc = lineout(logfile,'!'fullname' not found.')
	    end
      end

     When Pos('#', line) = 1 then
       Do
       fullname = strip(line,l,'#')
	rc = SysFileTree(fullname,outfile.,"F")
      IF Stream(fullname,'C', 'Query Exists') <>' ' & word(outfile.1,3) <> 0 Then
	Do
	/* Make sure the sequence is correct*/
	posfile = LASTPOS('.', filename) + 1
	setseq = SUBSTR(filename, posfile)
	fday = TRANSLATE(DELSTR(setseq, 3))
	fseq = TRANSLATE(SUBSTR(setseq, 3, 1))
	fseqno = POS(fseq, seqstr)

	/* Check if the days match*/
	if day = fday then 
	  do
	if fseqno > seqno then 
	    do
	  seqno = fseqno
	  seq = SUBSTR(seqstr, seqno, 1)
	    end
	  end
	   else do
	   day = fday
	   seqno = fseqno
	   if seqno = 0 then seqno = 1
	   seq = SUBSTR(seqstr, seqno, 1)
	    end

	  remfile1 = DELSTR(filename, posfile)||day||seq

	  Trunc = 1
	  Nuke = 0       

      Call Put filename word(outfile.1,5) word(outfile.1,3) remfile1
      
	    /* Update the sequence file*/
	    'erase 'seqfile
	    seqno = seqno + 1
	    seq = SUBSTR(seqstr, seqno, 1)
	    file = LINEOUT(seqfile, day' 'seq)
	    file = LINEOUT(seqfile)
	end
       else do
	   say '[1;31m!'fullname' not found or 0 length.[0m'
	   rc = lineout(logfile,'!'fullname' not found or 0 length.')
	    end
       end

    otherwise
       Do
      IF Stream(line,'C', 'Query Exists') <>' ' Then
	Do
      rc = SysFileTree(line,outfile.,"F")
      Trunc = 0
      Nuke = 0       
      Call Put filename word(outfile.1,5) word(outfile.1,3) filename
	end
       else do
	   say '[1;31m!'fullname' not found .[0m'
	   rc = lineout(logfile,'!'fullname' not found.')
	    end
       end
   end /* Select */
  end /* Do Until */
   rc = stream(fidohold,'C','close')
   'del 'fidohold '> nul: 2>&1'
    IF rc <> 0 Then
    Do
    say '[1;31m!Error deleting 'fidohold'[0m'
    rc = lineout(logfile,'!Error deleting 'fidohold)
    end
 end /* Do */
if sizethere = '0' then
 do
 say '[1;33m No mail to send at this time.[0m'
 rc = lineout(logfile,' No mail to send at this time')
 end


/*------------------------------------------------------------------
 * Change to remote outbound directory.
 *------------------------------------------------------------------*/

    rc = FtpChDir("..")                                 /* CFP!!!! */
    if err <> -1 & FTPERRNO <> '0' then
    do
    say '[1;31m!Error changing directory on remote.[0m'
    rc = lineout(logfile,'!Error changing directory on remote.')
    signal abort
    end
    rc = FtpChDir("out")                                /* CFP!!!! */
    if err <> -1 & FTPERRNO <> '0' then
    do
    say '[1;31m!Error changing directory on remote.[0m'
    rc = lineout(logfile,'!Error changing directory on remote.')
    signal abort
    end

/*------------------------------------------------------------------
 * Get Mail and Files
 *------------------------------------------------------------------*/

    New=Directory(ftpin)
    rc = Ftpdir('*.*',infile.)  /* get list of files there for list */
      if infile.0 > 1 & rc = 0 then
   do
      'del 'listfile '> nul: 2>&1'
      rc = stream(listfile,'C','open write')
       total_bytes = 0
       do i = 1 to infile.0
	filename = word(infile.i,9)
	size = word(infile.i,5)
	total_bytes = total_bytes + size
	rc = LINEOUT(listfile, filename size)
       end
	rc = stream(listfile,'C','close')
	apxsecs = total_bytes%avbps
	apxmins = apxsecs%60
	say '[1;33m Receiving 'infile.0  'file(s) 'total_bytes' bytes 'apxmins' avg. mins.[0m'
	rc = lineout(logfile,' Receiving 'infile.0 'file(s) 'total_bytes' bytes 'apxmins' avg. mins.')
	bps = 2000
	x = 1
	o = 1                       /* reset the pointer */
	
    /* time to get files here from There */
     do infile.0
	    filename = word(infile.x,9)

	    Call Get filename word(infile.x,5)

	x = x + 1
     end /* Do loop */
 end
    else
    do
	rc = lineout(logfile,' No files to get')
	say '[1;33m No files to get.[0m'
    end

/*------------------------------------------------------------------
 * Change to remote root directory and remove busy flag.
 *------------------------------------------------------------------*/

    rc = FtpChDir('..')
    if err <> -1 & FTPERRNO <> '0' then
    do
    say '[1;31m!Error changing directory on remote.[0m'
    rc = lineout(logfile,'!Error changing directory on remote.')
    end
    rc = FtpDelete(remotebsyname)
    if err <> -1 & FTPERRNO <> '0' then
    do
    say '[1;31m!Error deleting busy flag from remote.[0m'
    rc = lineout(logfile,'!Error deleting busy flag from remote.')
    end

    signal done

end /* Login loop */
else
do
    say '[1;31m!Login failed... session aborted[0m'
    rc = lineout(logfile,'!Login failed... session aborted')
    signal done
end


/*------------------------------------------------------------------
 * SubRoutines
 *------------------------------------------------------------------*/


/*------------------------------------------------------------------
 * PUT
 *------------------------------------------------------------------*/

Put:
parse arg filehere fullname sizehere filethere
o = 1
if filehere <> filethere then
 do
   rc = lineout(logfile,' sending 'filehere '- 'sizehere 'bytes as 'filethere)
   say '[1;32m Sending 'fullname ' -  'sizehere' bytes as 'filethere'[0m'
 end
else
  do
    rc = lineout(logfile,' sending 'filehere '- 'sizehere 'bytes')
    say '[1;32m Sending 'fullname ' -  'sizehere' bytes [0m'
  end
      
  err = FtpPut(fullname, filethere, 'binary')
	    
  if err = -1 & FTPERRNO = '0' then
  do
  /* add code to  test for good transfer by filesize */
    rc = FtpDir(filethere,test.)     /* get size from remote */
    if test.0 = 1 then /* it did get there  */
     do
	sizethere = word(test.1,5)
     if sizehere = sizethere then /* if the same size, delete or truncate if necessary */
      do
	  total_sent = total_sent + sizethere /* get size for report */
       Select
	    When Trunc = 1 then
	    do  
	    rc = lineout(logfile,' Successful - Truncating 'filehere)
	    say '[1;33m Truncating 'filehere'[0m'
	    rc=doscreat(fullname)
	    IF rc <> 1 Then
	      do
	    say '[1;31m!Error truncating 'fullname'[0m'
	    rc = lineout(logfile,'!Error truncating 'fullname
	    signal abort
	      end
	    end
	    When Nuke = 1 then
	    do  
	    rc = lineout(logfile,' Successful - Deleting 'fullname)
	    say '[1;33m Deleting 'fullname'[0m'
	    rc = SysFileDelete(fullname)
	    IF rc <> 0 Then
	      do
	    say '[1;31m!Error deleting 'fullname'[0m'
	    rc = lineout(logfile,'!Error deleting 'fullname
	    signal abort
	      end
	    end
       otherwise
       end /* Select */
      end /* size */
	else
	  do
	    rc = lineout(logfile,'!Error in size - Deleting  'filethere 'from inbound')
	    say '[1;31m!Error in size - Deleting  'filethere 'from inbound[0m'
	    rc = FtpDelete(filethere)
	    if err <> -1 & FTPERRNO <> '0' then
	    do
	    say '[1;31m!Error deleting 'filethere 'from remote.[0m'
	    rc = lineout(logfile,'!Error deleting 'filethere 'from remote.')
	    signal abort
	    end
	  end
     end /* test */
    else
       do
       say '[1;31m!Error in filetest[0m'
	rc = lineout(logfile,'!Error in filetest!')
       signal xabort
       end
  end
  else
   do
    say '[1;31m!FTP returned error 'FTPERRNO'[0m'
    rc = lineout(logfile,'!FTP returned error 'FTPERRNO)
    signal xabort
    end
Return

/*------------------------------------------------------------------
 * GET
 *------------------------------------------------------------------*/

Get:
parse arg filename filesize
	    say '[1;34m Recieving 'filename '- ' filesize 'bytes [0m'
	    start = time('e')
	    err = FtpGet(filename, filename,"binary")    /* Transfer the file */
	    elapsed = time('e')

	    sizehere = stream(filename,'C','query size')    /* get the filesize here */
	    if err = -1 & FTPERRNO = '0' & sizehere = filesize then
	     do
	    howmuch = strip(elapsed-start,,0)
	    bps = strip(format(sizehere/howmuch,10,0))
	    say '[1;35m Recieved 'filename '- 'howmuch%60 'min. 'strip(format(howmuch//60,3,0)) 'secs. 'bps 'bps [0m'
	    rc = lineout(logfile,' received 'filename' - 'sizehere' - 'howmuch%60 'min. 'strip(format(howmuch//60,3,0)) 'secs. Baud = 'bps)
		total_received = total_received + sizehere
		rc = FtpDelete(filename)
		if err <> -1 & FTPERRNO <> '0' then
		do
		say '[1;31m!Error deleting 'filename 'from remote.[0m'
		rc = lineout(logfile,'!Error deleting 'filename 'from remote.')
		end
		total_files = total_files + 1
		say '[1;36m Received 'total_files 'file(s) 'total_received 'bytes 'elapsed%60 'min. 'strip(format(elapsed//60,3,0)) 'secs. [0m'
		if bps < 500 & word(infile.x,5) > 10000 then
		do
		say '[1;31m!Something ain''t right!! too slow??[0m'
		rc = lineout(logfile,'!Something went wrong with bps')
		signal abort
		end
	     end
	else 
	do
	say '[1;31m!FTP returned error 'FTPERRNO'[0m'
	rc = lineout(logfile,'!FTP returned error 'FTPERRNO)
       if o = 2 then signal xabort
	o = o + 1
	x = x - 1
	end
Return

/*------------------------------------------------------------------
 * Aborts
 *------------------------------------------------------------------*/

Xabort:
say '[1;31m!File transfer failed..[0m'
rc = lineout(logfile,'!File transfer failed..')

Abort:
say '[1;31m!Session Aborted[0m'
rc = lineout(logfile,'!Session Aborted')

    rc = FtpChDir('..')
    rc = FtpDelete(remotebsyname)
signal Abort1

/*------------------------------------------------------------------
 * DONE
 *------------------------------------------------------------------*/

Done:

New=Directory(ftpin)
   IF Stream(ticc,'C', 'Query Exists') <>' ' & fixtic = 1 Then
    do
    rc = sysfiletree(ticc,"mfiles","FO")
     do i = 1 to mfiles.0
       parse var mfiles.i filename
	fname = filespec("Name",filename)
	CurrentLine = Linein(filename)
	rc = stream(filename,'c','close')
	 do while CurrentLine > ''
	  CurrentLine = Linein(filename)
	   BlankLine = Linein(filename)
	   posfile = LASTPOS('.', filename) + 1
	   new='tib'
	   outfile = DELSTR(filename, posfile)||new
	   rc = lineout(outfile,CurrentLine)
	  end
       rc = stream(filename,'c','close')
       'erase 'filename
       rc = stream(outfile,'c','close')
     end
     'ren *.tib *.tic'
    end

IF Stream(mailbundle,'C', 'Query Exists') <>' ' Then
 do
 New=Directory(fdin)
 copy mailbundle
 del mailbundle '/F'
 end

    'echo mailproc | rxqueue mailproc' /* This triggers my mailtosser */

Abort1:

    rc = FtpSetUser("X","X","X")
    rc = FtpLogoff()
    rc = FtpDropFuncs()

elapsed = time('e')
total = total_sent+total_received
say '[1;33m Sent 'total_sent 'bytes, received 'total_received 'bytes in 'elapsed%60 'minutes, 'strip(format(elapsed//60,6,0)) 'seconds.[0m'
say '[1;33m Averaging 'total/elapsed' bps for the session.[0m'
rc = lineout(logfile, ' $Sent 'total_sent 'bytes, received 'total_received 'bytes in 'elapsed%60 'minutes, 'strip(format(elapsed//60,10,0)) 'seconds.' )
rc = lineout(logfile, ' Averaging 'strip(format(total/elapsed,10,0)) 'bps for the session' )
rc = lineout(logfile, ' received 'total_files 'file(s)')


	  /* Clearing Local bsy Flag*/
	New=Directory(outbound)
	'del 'fidobsy '> nul: 2>&1'
       IF rc <> 0 Then
       Do
       say '[1;31m!Error deleting 'fidobsy'[0m'
       rc = lineout(logfile,'!Error deleting 'fidobsy)
       end

	/* remove process flag */
      'del 'flg '> nul: 2>&1'
       IF rc <> 0 Then
       Do
       say '[1;31m!Error deleting 'flg'[0m'
       rc = lineout(logfile,'!Error deleting 'flg)
       end


call Lineout logfile ,date('N') Time('N') 'FTPFIDO closing down.'

rc = stream(logfile,'C','close')

exit


CopyInfo: Procedure

Call SysCls

Say ' '
Say '[0;1;46m    [40m'
Say '      [36mFTPFido'
Say '   By Jerry Gause'
Say 'Warped Software'
Say '[37;46m۲    [40m'
Say '[0m'
Return

FailureStop:
parse upper source tst
tst=word(tst,3)
tst=parsefn(tst)
tst=word(tst,3)'.'word(tst,4)
      say '[1;31mA Failure ('RC') has occurred on Line 'Sigl' in 'tst'[0m'
      say 'ftpfido has Failure Exited'
      call Lineout errlog ,date('N') Time('N') ':  ftpfido ,  A Failure ('RC') has occurred on Line 'Sigl' in 'tst
   Signal Exit

ErrorStop:
parse upper source tst
tst=word(tst,3)
tst=parsefn(tst)
tst=word(tst,3)'.'word(tst,4)
      say '[1;31mAn Error ('RC') has occurred on Line 'Sigl' in 'tst'[0m'
      say 'ftpfido has Error Exited'
      call Lineout errlog ,date('N') Time('N') ':  ftpfido , An Error ('RC') has occurred on Line 'Sigl' in 'tst

exit:
rc = stream(errlog,'C','close')
rc = stream(logfile,'C','close')
exit
