/*
** FSCode.c (25.12.93) by Flavio Stanchina
** Loc. Montevaccino, 39
** 38040 Trento (Italy)
** 2:333/408.9@fidonet.org
*/

#include <exec/types.h>
#include <exec/memory.h>
#include <dos/dos.h>
#include <dos/rdargs.h>
#include <dos/stdio.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/utility_protos.h>

#if defined(__SASC)
#define _USEOLDEXEC_
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/utility.h>
#endif

#include <stdio.h>

#include "FSCode.h"
#include "FSCode_rev.h"

/***** Libraries *****/
struct DosLibrary	*DOSBase;
struct Library		*UtilityBase;

/***** Restituisce la lunghezza di un file gi aperto *****/
static LONG FileSizeFH(BPTR fh)
{
	struct FileInfoBlock *fib;
	LONG size = -1;

	if(fib = AllocDosObject(DOS_FIB, NULL))
	{
		if(ExamineFH(fh, fib))
			size = fib->fib_Size;
		FreeDosObject(DOS_FIB, fib);
	}

	return size;
}

/***** Strings *****/
TEXT StartFmt[] = "!start %s\n";
TEXT   EndFmt[] = "!end %ld %lx\n";

TEXT Template[] = "FILE/A,TO,E=ENCODE/S" VERSTAG " by Flavio Stanchina";
enum ARG_INDEX { ARG_FILE, ARG_TO, ARG_ENC, ARG_COUNT };

LONG __saveds FSCode(void)
{
	struct RDArgs *rda;
	LONG args[ARG_COUNT];

	BPTR in, out = 0;
	LONG tmp;
	BOOL close_out = FALSE;

	/* Open libraries (and make sure we're on OS 2.04 or greater) */
	if((DOSBase = OpenLibrary("dos.library", 37)) == NULL)
		return RETURN_FAIL;
	if((UtilityBase = OpenLibrary("utility.library", 37)) == NULL)
		return RETURN_FAIL;

	/* Set up arguments */
	args[ARG_FILE] = (LONG)NULL;
	args[ARG_TO  ] = (LONG)NULL;
	args[ARG_ENC ] = (LONG)FALSE;

	if(rda = ReadArgs(Template, args, NULL))
	{
		if((STRPTR)args[ARG_TO])
			if(out = Open((STRPTR)args[ARG_TO], MODE_NEWFILE))
				close_out = TRUE;
			else
			{
				PrintFault(IoErr(), (STRPTR)args[ARG_TO]);
				goto no_out;
			}

		if(in = Open((STRPTR)args[ARG_FILE], MODE_OLDFILE))
		{
			if(args[ARG_ENC])
			{
				ULONG crc;

				if(out == 0) out = Output();

				FPrintf(out, StartFmt, FilePart((STRPTR)args[ARG_FILE]));
				tmp = FileSizeFH(in);
				crc = Encode(in, out, tmp);
				FPrintf(out, EndFmt, tmp, crc);
			} else {
				TEXT line[256];
				LONG size1, size2;
				ULONG crc1, crc2;
get_start:
				if(FGets(in, line, 256) != NULL)
				{
					/* Use utility library string compare */
					if(Strnicmp(line, StartFmt, 7) != 0)
						goto get_start;

					/* Remove trailing newlines or other control characters */
					size1 = 7;
					while(line[size1] >= 32) size1++;
					line[size1] = '\0';

					/* Try to open specified file */
					if(out == 0)
						if(out = Open(line+7, MODE_NEWFILE))
							close_out = TRUE;
						else
						{
							PrintFault(IoErr(), line+7);
							goto the_end;
						}

					tmp = Decode(in, out, &size1, &crc1);

					if(tmp == ENDSTREAMCH)
					{
						PutStr("Unexpected EOF\n");
						goto the_end;
					}

					if(tmp == '!')
					{
						PutStr("Illegal '!' -- File corrupt\n");
						goto the_end;
					}
get_end:
					if(FGets(in, line, 256) != NULL)
					{
						if(Strnicmp(line, EndFmt, 5) != 0)
							goto get_end;
						sscanf(line, EndFmt, &size2, &crc2);

						if(size1 != size2)
							PutStr("Size mismatch\n");
						if(crc1 != crc2)
							PutStr("CRC mismatch\n");
					}
					else PutStr("No end line\n");
				}
				else PutStr("No start line\n");
			}
the_end:
			Close(in);
		}
		else PrintFault(IoErr(), (STRPTR)args[ARG_FILE]);

		if(close_out) Close(out);
no_out:
		FreeArgs(rda);
	}
	else PrintFault(IoErr(), NULL);

	CloseLibrary(DOSBase);
	CloseLibrary(UtilityBase);

	return RETURN_OK;
}
