/***** Decode.c (25.12.93) by Flavio Stanchina *****/

#include <exec/types.h>
#include <dos/dos.h>
#include <dos/stdio.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#if defined(__SASC)
#define _USEOLDEXEC_
#include <proto/exec.h>
#include <proto/dos.h>
#endif

#include "FSCode.h"

/* Skip spaces, newlines, tabs and whatever other control character slipped in */
static __inline LONG MyGetC(BPTR fh)
{
	register LONG c;
	do { c = FGetC(fh); } while((c >= 0) && (c <= 32));
	return c;
}

LONG Decode(BPTR in, BPTR out, LONG *size_ptr, ULONG *crc_ptr)
{
	LONG size = 0, skip = 0;
	ULONG crc = 0xFFFFFFFF; /* preload shift register, per CRC-32 spec */
	ULONG tmp;
	char buf[4];
	LONG c;

get_next:
	tmp = 0;

	/* 1 */
	c = MyGetC(in);

	if(c == ENDSTREAMCH) return c;
	if(c == '!')
	{
		UnGetC(in, c);
		*size_ptr = size;
		*crc_ptr = crc;
		return 0;
	}
	if(c == '#') skip = 1;
	else { tmp += c - 42; tmp *= 85; }

	/* 2 */
	c = MyGetC(in);

	if(c == ENDSTREAMCH) return c;
	if(c == '!') return c;
	if(c == '#') skip = 2;
	else { tmp += c - 42; tmp *= 85; }

	/* 3 */
	c = MyGetC(in);

	if(c == ENDSTREAMCH) return c;
	if(c == '!') return c;
	if(c == '#') skip = 3;
	else { tmp += c - 42; tmp *= 85; }

	/* 4 */
	c = MyGetC(in);

	if(c == ENDSTREAMCH) return c;
	if(c == '!') return c;

	tmp += c - 42; tmp *= 85;

	/* 5 */
	c = MyGetC(in);

	if(c == ENDSTREAMCH) return c;
	if(c == '!') return c;

	tmp += c - 42;

	/* Conversion to char truncates, so no & 0xFF needed */
	buf[0] = tmp;
	tmp >>= 8;
	buf[1] = tmp;
	tmp >>= 8;
	buf[2] = tmp;
	tmp >>= 8;
	buf[3] = tmp;

	/* Write out the correct amount of data and calculate CRC */
	switch(skip)
	{
		case 0: FPutC(out, buf[3]); size++; crc = crc32_stream(buf[3], crc);
		case 1: FPutC(out, buf[2]); size++; crc = crc32_stream(buf[2], crc);
		case 2: FPutC(out, buf[1]); size++; crc = crc32_stream(buf[1], crc);
		case 3: FPutC(out, buf[0]); size++; crc = crc32_stream(buf[0], crc);
	}

	goto get_next;
}
