#include "inkey.ch"

#define CD_PLAYING 768

FUNCTION cdDemo()
LOCAL nKey     := 0
LOCAL nJamp    := 1
LOCAL aSongs
LOCAL nSong
LOCAL nCursor  := SetCursor( 0 )
LOCAL aExit
LOCAL aPlay
LOCAL aStop
LOCAL aResume
LOCAL aEject
LOCAL cScreen
LOCAL nY       := Row()
LOCAL cMain    := SaveScreen( 0, 0, 24, 79 )
LOCAL nVolumeL := sbCDVolL()
LOCAL nVolumeR := sbCDVolR()
LOCAL lChannel := .T.
    IF ! cdinstall()
      ? "Sorry, CRROM driver not loaded"
    ELSE
      SetColor( "W/B, W+/B" )
      BoxOpen(  9,  9, 19, 70, "b" )
      BoxOpen( 10, 10, 13, 69, "b" )
      @ 11, 12 SAY "CD-ROM Audio Player created with FAST.lib by Manu Roibal" COLOR "gr+/b"
      @ 14, 13 SAY replicate( "", 10 ) COLOR "g+/b"
      @ 15, 13 SAY replicate( "", 10 ) COLOR "g+/b"
      @ 14, 30 SAY "Left Channel "      COLOR "b+/b"
      @ 15, 30 SAY "Right Channel"      COLOR "b+/b"
      @ 14 + IIF( lChannel, 0, 1 ), 28 SAY CHR( 26 ) COLOR "gr+/b"
      DrawVol( 14, 44, nVolumeL )
      DrawVol( 15, 44, nVolumeR )
      aExit   := BoxMessage( "Esc-Exit",  16, 11, "b" )
      aPlay   := BoxMessage( "F1-Play",   16, 23, "b" )
      aStop   := BoxMessage( "F2-Stop",   16, 34, "b" )
      aResume := BoxMessage( "F3-Resume", 16, 45, "b" )
      aEject  := BoxMessage( "F4-Eject",  16, 58, "b" )
      WHILE nKey != K_ESC
        nKey := 0
        WHILE nKey == 0
          nKey := Inkey()
          IF cdStatus() == CD_PLAYING
            @ 14, 13 SAY replicate( "", nJamp ) COLOR "r+/b"
            @ 15, 13 SAY replicate( "", nJamp ) COLOR "r+/b"
            nJamp++
            IF nJamp == 11
              nJamp := 1
              @ 14, 13 SAY replicate( "", 10 ) COLOR "g+/b"
              @ 15, 13 SAY replicate( "", 10 ) COLOR "g+/b"
            ENDIF
          ENDIF
        ENDDO
        IF nKey == K_F1
          BoxPush( aPlay )
          aSongs := cdInfo()
          IF LEN( aSongs ) > 1
            aEval( aSongs, ;
                   { | x, i | aSongs[ i ] := "Song " + ;
                                             Str( i, 2 ) + ;
                                             ". Time " + x } )
            cScreen := SaveScreen( 10, 28, 17, 50 )
            BoxOpen( 10, 28, 17, 50, "B" )
            nSong := aChoice( 11, 30, 16, 49, aSongs, .T. )
            RestScreen( 10, 28, 17, 50, cScreen )
            IF nSong > 0 .AND. nSong <= LEN( aSongs )
              cdPlay( nSong )
            ENDIF
          ENDIF
        ELSEIF nKey == K_F2
          BoxPush( aStop )
          cdStop()
        ELSEIF nKey == K_F3
          BoxPush( aResume )
          cdResume()
        ELSEIF nKey == K_F4
          BoxPush( aEject )
          cdStop()
          cdEject()
        ELSEIF nKey == K_UP .OR. nKey == K_DOWN
          @ 14 + IIF( lChannel, 0, 1 ), 28 SAY " "       COLOR "gr+/b"
          lChannel := ! lChannel
          @ 14 + IIF( lChannel, 0, 1 ), 28 SAY CHR( 26 ) COLOR "gr+/b"
        ELSEIF nKey == K_LEFT
          IF lChannel
            IF nVolumeL > 0
              nVolumeL--
              sbCDVolL( nVolumeL )
            ENDIF
          ELSE
            IF nVolumeR > 0
              nVolumeR--
              sbCDVolR( nVolumeR )
            ENDIF
          ENDIF
          DrawVol( 14, 44, nVolumeL )
          DrawVol( 15, 44, nVolumeR )
        ELSEIF nKey == K_RIGHT
          IF lChannel
            IF nVolumeL < 15
              nVolumeL++
              sbCDVolL( nVolumeL )
            ENDIF
          ELSE
            IF nVolumeR < 15
              nVolumeR++
              sbCDVolR( nVolumeR )
            ENDIF
          ENDIF
          DrawVol( 14, 44, nVolumeL )
          DrawVol( 15, 44, nVolumeR )
        ENDIF
      ENDDO
      BoxPush( aExit )
    ENDIF
    SetCursor( nCursor )
    RestScreen( 0, 0, 24, 79, cMain )
    SetPos( nY, 0 )
RETURN NIL


STATIC FUNCTION DrawVol( nY, nX, nVol )
    @ nY, nX        SAY REPLICATE( "",      nVol ) COLOR "g+/b"
    @ nY, nX + nVol SAY REPLICATE( "", 15 - nVol ) COLOR "r+/b"
RETURN NIL
