*------------------------
* FRX2PRG.prg
*
* Purpose: Generates a PRG from an FRX, thus avoiding the overhead
*          associated with calling REPORT FORM.
*
* Add your name to the CREDITS here:
*      E. Gamez
*      C. Lutions
*      F. Coppage
*      D. Hoffman
*------------------------
* Revision History
*
*   EG  4/29/93 Added some nice packaging and pizzaz!
*   EG  4/26/93 Fixed some line feed problems. Removed CTRL().
*   EG  4/23/93 Added Heading() & CTRL() & Time4LF().
*   EG  4/19/93 Changed design to incorporate boxes as individual
*               character elements. Now sending intermediate results
*               to a DBF which is later sorted and a PRG generated.
*   EG  4/13/93 Created
*------------------------

clear
close data
set safety off
set talk off

FRXFile = ""
m.Created = {4/29/93}

do intro.spr

if lastkey() != 27
   
   FRXFile = getfile( "FRX"," Select REPORT to convert... " )
   
   if !empty( FRXFile )
   
      * REMOVE EXTENSION
      x = at( ".FRX",FRXFile )
      if x > 1
          FRXFile = SUBSTR( FRXFile,1,x-1 )
      endif
      
      m.FRX = FRXFile+".FRX"
      m.FRT = FRXFile+".FRT"
      m.PRG = FRXFile+".PRG"
      m.QTE = chr(34)
      
      if file( m.FRT )
      
         create table SCRATCH (Row N(4), Col N(4), Height N(4), Width N(4), Stretch L, TextField C(1), AtSay C(140))
         select 0
         use (m.FRX) alias FRXf
         
         * CONTINUE WITH THE CODE BELOW ...
      
      else
         =Oops( "ERROR: "+m.FRT+" not found!" )
      endif
   else
      =Oops( "USER ABORT" )
   endif
else
   =Oops( "USER ABORT" )
endif

* FIRST CREATE TEMP DBF W/INDIVIDUAL GRAPHIC CHARACTERS, WHICH CAN
* BE INDEXED IN ROW/COL ORDER...

wait window "GENERATING" nowait

scan
   do case
      case FRXf.ObjType = 5      && TEXT
         select SCRATCH
         append blank
         replace Row with FRXf.vPOS, Col with FRXf.hPOS
         replace Height with FRXf.HEIGHT, Width with FRXf.WIDTH
         
         replace TextField with "0"               && TEXT=0, FIELD=1
         
         replace Stretch with FRXf.STRETCH
         replace AtSay with alltrim( FRXf.EXPR )
         
      case FRXf.ObjType = 8      && REPFIELD
         if type( FRXf.EXPR ) = "M"
            * SPECIAL HANDLING
            
            wait window FRXf.EXPR
            
         else
            select SCRATCH
            append blank
            replace Row with FRXf.vPOS, Col with FRXf.hPOS
            replace Height with FRXf.HEIGHT, Width with FRXf.WIDTH
            replace TextField with "1"
            replace Stretch with FRXf.STRETCH
            replace AtSay with alltrim( FRXf.EXPR )
         endif
         
      case FRXf.ObjType = 7      && BOX
         
         do case
            case ObjCode = 4       && SINGLE BOX
               m.xBOXCHAR = "ڿĳ"
               
            case ObjCode = 5       && DOUBLE BOX
               m.xBOXCHAR = "ɻͺ"
            
            case ObjCode = 6       && PANEL BOX
               m.xBOXCHAR = replicate( FRXf.BOXCHAR,6 )
               
            case ObjCode = 7       && CHAR BOX
               m.xBOXCHAR = replicate( FRXf.BOXCHAR,6 )
               
            otherwise
                wait window str( FRXf.ObjCode )
         endcase
         
         select SCRATCH
         
         * BOX OR LINE?
         do case
            case FRXf.HEIGHT = 1       && HORIZONTAL LINE
               
               * IF ENDPOINTS OF THIS LINE INTERSECT EITHER ANOTHER
               * LINE OR AN EDGE OF A BOX, ADJUST LINE SEGMENT SO IT
               * DOESN'T INTERSECT.
               
               * THE ENDPOINTS ARE:
               *      FRXf.vPOS, FRXf.hPOS
               * AND
               *      FRXf.vPOS, FRXf.hPOS+FRXf.WIDTH-1
               
               select FRXf
               o_RECNO = recno()  && SAVE CURRENT POSITION IN FRXf
               store .f. to m.ShortenLeft,m.ShortenRight
               m.Shorten = 0
               
               * LIMIT THE LOCATE TO BOXES (7) AND AVOID "LOCATE" FINDING
               * ITSELF!
               set filter to ObjType = 7 and recno()!=o_RECNO
               
               * 1. CHECK FOR INTERSECTING BOXES/LINES WITH LEFT ENDPOINT
               m.lrow = FRXf.vPOS
               m.lcol = FRXf.hPOS
               m.rrow = FRXf.vPOS
               m.rcol = m.lcol+FRXf.WIDTH-1
               
               locate for FRXf.hPOS = m.lcol ;
                  and FRXf.vPOS<=m.lrow and FRXf.vPOS+FRXf.HEIGHT-1>=m.lrow
               m.ShortenLeft = found()
               
               * 2. CHECK FOR INTERSECTING BOXES/LINES WITH RIGHT ENDPOINT
               go top
               locate for FRXf.hPOS+FRXf.WIDTH-1 = m.rcol ;
                  and FRXf.vPOS<=m.rrow and FRXf.vPOS+FRXf.HEIGHT-1>=m.rrow
               m.ShortenRight = found()
               
               select FRXf
               set filter to
               goto o_RECNO
               select SCRATCH
               
               append blank
               
               if m.ShortenLeft
                  replace Row with FRXf.vPOS, Col with FRXf.hPOS+1
                  m.Shorten = m.Shorten + 1
               else
                  replace Row with FRXf.vPOS, Col with FRXf.hPOS
               endif
               
               * HORIZ. LINES DON'T STRETCH!
               *replace Stretch with FRXf.STRETCH
               
               replace TextField with "0"
               
               if m.ShortenRight
                  m.Shorten = m.Shorten + 1
                  replace AtSay with m.QTE ;
                     + replicate( substr( m.xBOXCHAR,5,1),FRXf.WIDTH-m.Shorten )+m.QTE
               else
                  replace AtSay with m.QTE ;
                     + replicate( substr( m.xBOXCHAR,5,1),FRXf.WIDTH-m.Shorten )+m.QTE
               endif
               
            case FRXf.WIDTH = 1        && VERTICAL LINE
               
               * IF ENDPOINTS OF THIS LINE INTERSECT EITHER ANOTHER
               * LINE OR AN EDGE OF A BOX, ADJUST LINE SEGMENT SO IT
               * DOESN'T INTERSECT.
               
               * THE ENDPOINTS ARE:
               *      FRXf.vPOS, FRXf.hPOS
               * AND
               *      FRXf.vPOS+FRXf.FRXf.HEIGHT-1, FRXf.hPOS
               
               select FRXf
               o_RECNO = recno()  && SAVE CURRENT POSITION IN FRXf
               store .f. to m.ShortenTop,m.ShortenBott
               m.Shorten = 0
               
               * LIMIT THE LOCATE TO BOXES (7) AND AVOID "LOCATE" FINDING
               * ITSELF!
               set filter to ObjType = 7 and recno() != o_RECNO
               
               * 1. CHECK FOR INTERSECTING BOXES/LINES WITH TOP ENDPOINT
               m.trow = FRXf.vPOS
               m.tcol = FRXf.hPOS
               m.brow = FRXf.vPOS+FRXf.HEIGHT-1
               
               locate for FRXf.vPOS = m.trow ;
                  and FRXf.hPOS<=m.tcol and FRXf.hPOS+FRXf.WIDTH-1>=m.tcol
               m.ShortenTop = found()
               
               * 2. CHECK FOR INTERSECTING BOXES/LINES WITH BOTTOM ENDPOINT
               go top
               locate for FRXf.vPOS+FRXf.HEIGHT-1 = m.brow ;
                  and FRXf.hPOS<=m.tcol and FRXf.hPOS+FRXf.WIDTH-1>=m.tcol
               m.ShortenBott = found()
               
               select FRXf
               set filter to
               goto o_RECNO
               
               * LOOP TO CREATE VERTICAL LINE
               
               select SCRATCH
               append blank
               
               if m.ShortenTop
                  trow = trow + 1
                  m.Shorten = m.Shorten + 1
               endif
               if m.ShortenBott
                  m.Shorten = m.Shorten + 1
               endif
               
               for i = 0 to FRXf.HEIGHT-m.Shorten-1
                  append blank
                  replace Row with m.trow+i, Col with m.tcol
                  replace TextField with "0"
                  replace Stretch with FRXf.STRETCH
                  replace AtSay with m.QTE+substr( m.xBOXCHAR,6,1)+m.QTE
               next
               
            otherwise                  && BOX
               * CONVERT BOX TOP
               *------------------
               append blank
               replace Row with FRXf.vPOS, Col with FRXf.hPOS
               replace TextField with "0"
               replace Stretch with FRXf.STRETCH
               replace AtSay with m.QTE+substr( m.xBOXCHAR,1,1 ) ;
                  + replicate( substr( m.xBOXCHAR,5,1),FRXf.WIDTH-2 ) ;
                  + substr( m.xBOXCHAR,2,1 )+m.QTE
         
               * CONVERT BOX SIDES
               *------------------
               m.xPOS = FRXf.vPOS+1
         
               for i = 0 to FRXf.HEIGHT-3
                  * LEFT SIDE
                  append blank
                  replace Row with m.xPOS+i, Col with FRXf.hPOS
                  replace TextField with "0"
                  replace Stretch with FRXf.STRETCH
                  replace AtSay with m.QTE+substr( m.xBOXCHAR,6,1)+m.QTE
            
                  * RIGHT SIDE
                  append blank
                  replace Row with m.xPOS+i, Col with FRXf.hPOS+FRXf.WIDTH-1
                  replace TextField with "0"
                  replace Stretch with FRXf.STRETCH
                  replace AtSay with m.QTE+substr( m.xBOXCHAR,6,1)+m.QTE
               next
               
               * CONVERT BOX BOTTOM
               *--------------------
               append blank
               replace Row with FRXf.vPOS+FRXf.HEIGHT-1, Col with FRXf.hPOS
               replace TextField with "0"
               replace Stretch with FRXf.STRETCH
               replace AtSay with m.QTE+substr( m.xBOXCHAR,4,1 ) ;
                  + replicate( substr( m.xBOXCHAR,5,1),FRXf.WIDTH-2 ) ;
                  + substr( m.xBOXCHAR,3,1 )+m.QTE
         endcase
      otherwise
         * IGNORE FOR NOW ...
   endcase
   
   select FRXf
   
endscan

* GET PAGE LENGTH
go top
locate for FRXf.ObjType = 1 and FRXf.ObjCode = 0
if !found()
   =Oops( "ERROR: Unrecognized FRX file!" )
endif
xPageLen = FRXf.Height

* GET LENGTH OF HEADER BAND
go top
locate for FRXf.ObjType = 9 and FRXf.ObjCode = 1
if !found()
   =Oops( "ERROR: Unrecognized FRX file!" )
endif
xHeadLen = FRXf.Height
use in FRXf


wait window "WRITING PROGRAM" nowait


select SCRATCH
index on str(Row)+iif(Stretch,"1","0")+str(Col)+TextField tag POSITION


set textmerge to (prg)
set textmerge on

\\*
 \*
 \* Name     : <<prg>>
 \*
 \* Purpose  : Print a report.
 \*
 \* Generated by FRX2PRG on <<date()>> at <<time()>>.
 \*
 \*
 \private NumLines,o_MemWid
 \
 \o_MemWid = set( "memowidth" )
 \set console off
 \set printer on
 \

* GENERATE DETAIL LINES FIRST...
set filter to scratch.Row > xHeadLen

PrntRow = xHeadLen
Skip_LF = .f.

scan
   if Skip_LF
      * DON'T ISSUE A LINE FEED AFTER PRINTING A STRETCHED MEMO FIELD.
      * RATHER INELEGANT, I ADMIT!
      Skip_LF = .f.
      PrntRow = scratch.Row
   else
      =Time4LF()      && IS IT TIME TO INSERT A "\=LineFeed()" ?
   endif
   
   do case
      case TextField = "0"      && TEXT
         \?? <<trim(scratch.AtSay)>> at <<alltrim(str(scratch.Col))>>
         
      case TextField = "1"      && FIELD
         if scratch.Stretch
            * SPECIAL HANDLING FOR MEMO FIELDS. ADD TO xFLOAT ANY EXTRA
            * LINES PRINTED BECAUSE OF STRETCHING MEMO FIELDS.
            \
            \* MEMO FIELD
            \if empty( <<trim(scratch.AtSay)>> )
            \   =LineFeed()
            \else
            \   set memowidth to <<scratch.Width>>
            \   NumLines = memlines( <<trim(scratch.AtSay)>> )
            \   _MLINE   = 0
            \
            \   for count = 0 TO NumLines - 1
            \      ?? mline( <<trim(scratch.AtSay)>>, 1, _MLINE ) at <<alltrim(str(scratch.Col))>>
            \
            \      * COPY ANY REPEATING CHARS TO BE PRINTED ON THIS LINE MANUALLY.
            \      * (IE. BELONGING TO A SURROUNDING BOX...)
            \
            \      =LineFeed()
            \   next
            \endif
            \
            Skip_LF = .t.
         else
            * ORDINARY FIELD (NON-STRETCH). STYLE/PICTURE/FUNCTIONs NOT
            * YET SUPPORTED!
            \?? <<trim(scratch.AtSay)>> at <<alltrim(str(scratch.Col))>>
         endif
      otherwise
         * NONE YET
   endcase
endscan

\
\set printer off
\set console on
\eject
\set memowidth to o_MemWid
\return
\
\
\*
\* Name     : LineFeed()
\* Purpose  : Sends a LF char, checking for end of page and if
\*            necessary, do Heading().
\* Called by: Main line program at runtime.
\*
\function LineFeed
\do case
\   case prow() >= <<xPageLen>>
\      eject
\      =Heading()
\   case prow() = 0        && FIRST TIME DON'T EJECT
\      =Heading()
\   otherwise
\      ?
\endcase
\return
\
\
\*
\* Name     : Heading()
\* Purpose  : Prints page header.
\* Called by: LineFeed() at runtime.
\*
\function Heading

set filter to scratch.Row >= 0 and scratch.Row <= xHeadLen

PrntRow = 0

scan
   =GoToRow( scratch.Row )  && PAD TO NEXT DESIRED ROW WITH ?'s
   
   do case
      case TextField = "0"      && TEXT
         \?? <<trim(scratch.AtSay)>> at <<alltrim(str(scratch.Col))>>
      case TextField = "1"      && FIELD (NON STRETCH)
         \?? <<trim(scratch.AtSay)>> at <<alltrim(str(scratch.Col))>>
   endcase
endscan

=GoToRow( xHeadLen+1 )      && PAD OUT ENTIRE LENGTH OF HEADING.

\return


set textmerge to
close data
if file( "SCRATCH.DBF" )
   erase SCRATCH.DBF
endif
if file( "SCRATCH.CDX" )
   erase SCRATCH.CDX
endif

clear
?? chr(7)
? "Your converted report is: "+m.PRG

wait window "DONE!" nowait
return


*
* Name     : Oops()
* Purpose  : Error msg printer and exit.
*            Note that this function is used only during generation.
* Called by: FRX2PRG()
*---------------------------------------------------------------------
function Oops
parameter Msg

wait window Msg timeout 1
close all
clear all
cancel


*
* Name     : Time4LF
* Purpose  : Inserts a LineFeed() call depending on prow() difference.
*            Note that this function is used only during generation.
* Called by: FRX2PRG()
*---------------------------------------------------------------------
function Time4LF

if PrntRow != scratch.Row     && DIFFERENT LINE

   * INCREMENT TO PROPER PRINT ROW...
   y = scratch.Row - PrntRow
   for x = 1 to y
      \=LineFeed()
   next
   PrntRow = scratch.Row
endif
return


*
* Name     : GoToRow()
* Purpose  : Should only be used inside the Header(), where we know we
*            won't overflow to the next page requiring another Header()!
*            Note that this function is used only during generation.
* Called by: FRX2PRG()
*---------------------------------------------------------------------
function GoToRow
parameter TargetRow

if PrntRow != TargetRow         && DIFFERENT LINE

   * INCREMENT TO PROPER PRINT ROW...
   y = TargetRow - PrntRow
   for x = 1 to y
      \?
   next
   PrntRow = TargetRow
endif
return   


*
* Name     : DispMemo()
* Purpose  : Should only be used inside the Header(), where we know we
*            won't overflow to the next page requiring another Header()!
*            Note that this function is used only during generation.
* Called by: INFO.spr
*---------------------------------------------------------------------
function DispMemo
parameters WhichRec

select 0
use FRX2PRG exclusive noupdate
goto WhichRec
m.Titl = alltrim(frx2prg.TITLE)
do ShowMemo.spr
use
return
