
;ķ
;                         EXE MASTER  Enhanced                          
;                               (c) 1994                                
;     SEARCHES A FILE FOR A VARIETY OF STRINGS OR A SERIES OF BYTES     
;Ľ
;

    _search_file_ macro                 ; Do actual search!
        lodsb
        xor     ch, ch
        mov     cl, al
        mov     saved_length, al
        mov     file_type, si
        call    do_search
    #em

    _print_file_    macro               ; Print the whole thing out...
        call    formatting_engine
        call    display_data_field
    #em

    _pre_search_ macro                  ; Load "method of compression" string
        lodsb
        xor     ch, ch
        mov     cl, al
        mov     compress_length, al
        mov     comp_method, si
    #em

;-------------------------------------------------------------------------
code                    SEGMENT
ASSUME          cs:code, ds:code, ss:code
ORG             100h
start:
        jmp     dispatch
;-------------------------------------------------------------------------
compress_length         db      0           ; Length of the printed "method of compression"
comp_method             dw      0           ; actual "method of compression" string
bytes_read              DW      0
number_files            db      0
we_printed_one          db      0


PKLITEstr               db      06,'PKLITE'
pklite_sig              DB      11,'PKLITE Copr'
PKZIP1str               db      09,'Pkzip 1.1'
PKZIP2str               db      09,'Pkzip 2.0'
PKZIPjr2str             db      13,'Pkzip 2.0 -JR'
LZEXEstr                db      10,'LZEXE 0.91'
lzexe_sig               DB      04,'LZ91'
LHARCstr                db      10,'Lharc 1.13'
lharc_sig               db      08,'SFX 1.13'
LHA212str               db      08,'Lha 2.12'
lha212_sig              db      08,'SFX 2.12'
LHA213str               db      08,'Lha 2.13'
lha213_sig              db      08,'SFX 2.13'
ARJstr                  db      03,'Arj'
NORTstr                 db      11,'Norton File'
nort_sig                db      13,'Symantec Corp'
_WORDPstr               db      11,'WordPerfect'
DIETstr                 db      04,'Diet'
diet_sig                db      04,'diet'
diet_2_sig              db      06,'r',04h,0b4,'L',0cdh,21h
TINYPROGstr             db      08,'TinyProg'
tinyprog_sig            db      03,'tz',0c3h
window1_sig             db      13,'requires Micr'
window2_sig             db      14,'run under Micr'
WINDOWstr               db      17,'Microsoft Windows'
ARCstr                  db      03,'Arc'
arc_sig                 db      15,'Extract un-Pack'
PROTECT1str             db      21,'ProtectCM 1 Encrypted'
PROTECT2str             db      21,'ProtectCM 2 Encrypted'
BOOKEstr                db      16,'Book-E Text File'
SQUEEZEstr              db      07,'Squeeze'
gifexe_sig              db      04,'PK1',0f5h
GIFEXEstr               db      23,'Graphic File: GIF 2 EXE'
POWERBATstr             db      24,'COMPILED BATCH: PowerBat'
powerbat_sig            db      05,5ch,04h,5ch,0a4h,05h
BAT2EXEstr              db      23,'COMPILED BATCH: Bat2Exe'
bat2exe_sig             db      11,'by BAT2EXEC'
TLIFEstr                db      22,'Executable Text: TLIFE'
tlife_sig               db      04,44h,10h,44h,10h
TEXEstr                 db      21,'Executable Text: TEXE'
texe_sig                db      05,4dh,5ah,8ch,01h,1eh
BIGTEXTstr              db      24,'Executable Text: BIGTEXT'
bigtext_sig             db      04,02h,01h,0eah,01h
COMVERTstr              db      17,'COMVERT COM 2 EXE'
comvert_sig             db      09,'COMvert v'
GWSstr                  db      30,'Graphic File: GRAPHIC WORKSHOP'
gws_sig                 db      11,'GraphicWork'
GWSWINstr               db      22,'Graphic: GWS - Windows'
gwswin_sig              db      10,'GWS/Window'
GRABBERstr              db      21,'Graphic File: GRABBER'
grabber_sig             db      10,'by GRABBER'


; ====================== COM FILE SIGNATURES =================================
XEQstr                  db      16,'XEQ Library .COM'
xeq_sig                 db      07,'XEQ.COM'
SHRINKstr               db      06,'Shrink'
shrink_sig              db      06,0f6h,5bh,9dh,58h,53h,8bh
COMPACKstr              db      07,'Compack'
compack_sig             db      06,'Collis'
TURBOBATstr             db      25,'Compiled Batch: TURBO BAT'
turbobat_sig            db      08,'TurboBAT'
BATLITEstr              db      24,'Compiled Batch: BAT LITE'
batlite_sig             db      12,'Peter A. Hin'
TXT2COMstr              db      32,'Executable Text: RO-SOFT TXT2COM'
txt2com_sig             db      07,'RO-SOFT'
ASC2COMstr              db      26,'Executable Text: ASC 2 COM'
asc2com_sig             db      07,'#00A001'
LAUGHstr                db      34,'Executable ANSI: Laughing Dog ANSI'
laugh_sig               db      06,4ch,0a0h,58h,1,0cdh,21h
MAKEREADstr             db      26,'Executable Text: MAKE READ'
makeread_sig            db      13,'< Press  Home'
DOC2COMstr              db      26,'Executable Text: DOC 2 COM'
doc2com_sig             db      08,1,0e2h,0fbh,3bh,36h,58h,4,72h
TURBOTXTstr             db      26,'Executable Text: TURBO TXT'
turbotxt_sig            db      07,'PSQR',0b4h,3,'U'
TXT2COM2str             db      26,'Executable Text: TXT 2 COM'
txt2com2_sig            db      13,'TXT2COM Conve'
SHOWstr                 db      21,'Executable Text: SHOW'
show_sig                db      05,'SHOWV'
DOCMAKERstr             db      24,'Executable Text: DocMaker'
docmaker_sig            db      14,'ed by DOCMAKER'
TXTMAKERstr             db      25,'Executable Text: TXT Maker'
txtmaker_sig            db      14,'ed by TXTmaker'
COP10str                db      21,'COP 1.0 Encrypted COM'
cop10_sig               db      07,8bh,16h,18h,1,0ebh,0d1h,90h
COP14str                db      21,'COP 1.4 Encrypted COM'
cop14_sig               db      07,8eh,89h,0fdh,0beh,29h,1,81h
COMPACK2str             db      23,'COM-PACK Compressed COM'
compack2_sig            db      10,'COM-Pack v'
TSRMAKERstr             db      24,'Converted TSR: TSR MAKER'
tsrmaker_sig            db      18,'ed by TSRMAKER.COM'
COM22EXEstr             db      24,'Converted COM: COM 2 EXE'


com_                    DB      '*.COM', 0
exe_                    DB      '*.EXE', 0
finishprebuf            DB      0ah,0dh,'      EXE MASTER Enhanced Ľ',0ah,0dh,0
finish_buffer           DB      0ah,0dh,'      Number of Files Processed:     ķ',0
error_msg               DB      0ah, 0dh, '   Error in processing... aborting', 0ah, 0dh, 0
no_files_msg            db      0ah,0dh,'    No files were found!',0dh,0ah,0
advertisement1          DB      0dh, 0ah, '    Exe Master Enhanced    David Smith ķ ',0ah,0dh
                        DB                '    (c) 1993 All Rights Reserved Ľ ', 0ah, 0dh, 0ah, 0dh, 0
file_type               DW      0
file_handle             DW      0
saved_length            DB      0
dta                     DB      128 DUP (0)
display_buffer          DB      75 DUP (' '), 0
;
;---------------------------------------------------------------------------
dispatch                PROC    NEAR
        mov     si, OFFSET advertisement1
        call    display_string
        mov     dx, OFFSET dta                  ; We need a new DTA area
        mov     ah, 1ah
        int     21h
        mov     bx, OFFSET exe_                 ; Find all .EXE
        mov     file_type, bx
        call    get_filenames

        mov     bx, OFFSET com_                 ; then all .COM files
        mov     file_type, bx
        call    get_com_filenames

        cmp     number_files, 0                 ; We found nothing!
        je no_files_found

        mov     di, OFFSET finish_buffer+42
        mov     al, number_files
        call ascii_convert
        mov     si, OFFSET finish_buffer
        call    display_string
        mov     si, OFFSET finishprebuf
        call    display_string

        mov     ax, 4c00h
        int     21h

no_files_found:
        mov     si, OFFSET no_files_msg
        call    display_string
        mov     ax, 4c01h
        int     21h
dispatch                ENDP
;-----------------------------------
get_filenames           PROC    NEAR
        mov     dx, file_type
        mov     cx, 0                   ; look for normal files.
        mov     ah, 4eh
        int     21h
        jnc     store_name
        ret
store_name:                             ; looks good
        call    format_data             ; convert to proper format
find_next:
        mov     ah, 4fh
        int     21h
        jnc     ok_got
        jmp     completed
ok_got:                                 ; looks good
        call    get_char
        call    format_data             ; convert to proper format.
        jmp     SHORT find_next
completed:
        clc
        ret
get_filenames           ENDP
;-----------------------------------
get_com_filenames           PROC    NEAR
        mov     dx, file_type
        mov     cx, 0                   ; look for normal files.
        mov     ah, 4eh
        int     21h
        jnc     store_name2
        ret
store_name2:                            ; looks good
        call    format_com_file         ; convert to proper format
find_next2:
        mov     ah, 4fh
        int     21h
        jnc     ok_got2
        jmp     completed2
ok_got2:                                ; looks good
        call    get_char
        call    format_com_file         ; convert to proper format.
        jmp     SHORT find_next2
completed2:
        clc
        ret
get_com_filenames           ENDP






;Ŀ
;    Process all .COM files by searching for certain strings or      
;              sets of bytes within the file.                        
;

format_com_file           PROC    NEAR
        mov     we_printed_one, 0       ; Reset "printed" flag
        inc     number_files

; ...........................................  PKLITE  ..........
COM01:
        call    flush_name_buffer
        mov     si, OFFSET PKLITEstr
        _pre_search_
        mov     bytes_read, 50        ; Adjust so not to over-read loc of sig
        mov     si, OFFSET pklite_sig

        lodsb                               ; Load the file + search
        xor     ch, ch
        mov     cl, al
        mov     saved_length, al
        mov     file_type, si
        call    see_if_compressed

        jc COM02
        _print_file_
; ...........................................   DIET  ..........
COM02:
        call    flush_name_buffer
        mov     si, OFFSET DIETstr
        _pre_search_
        mov     bytes_read, 100       ; Adjust so not to over-read loc of sig
        mov     si, OFFSET diet_sig
        _search_file_
        jc COM03
        _print_file_
; ...........................................  more DIET  ........
COM03:
        call    flush_name_buffer
        mov     si, OFFSET DIETstr
        _pre_search_
        mov     si, OFFSET diet_2_sig
        _search_file_
        jc COM04
        _print_file_
; ...........................................  TINYPROG  .........
COM04:
        call    flush_name_buffer
        mov     si, OFFSET TINYPROGstr
        _pre_search_
        mov     si, OFFSET tinyprog_sig
        _search_file_
        jc COM05
        _print_file_
; ...........................................  XEQ.COM  ..........
COM05:
        call    flush_name_buffer
        mov     si, OFFSET XEQstr
        _pre_search_
        mov     bytes_read, 30        ; Adjust so not to over-read loc of sig
        mov     si, OFFSET xeq_sig
        _search_file_
        jc COM06
        _print_file_
; ........................................... SHRINK   ..........
COM06:
        call    flush_name_buffer
        mov     si, OFFSET SHRINKstr
        _pre_search_
        mov     bytes_read, 100       ; Adjust so not to over-read loc of sig
        mov     si, OFFSET shrink_sig
        _search_file_
        jc COM07
        _print_file_

; ...........................................  COMPACK  ..........
COM07:
        call    flush_name_buffer
        mov     si, OFFSET COMPACKstr
        _pre_search_
        mov     si, OFFSET compack_sig
        _search_file_
        jc COM08
        _print_file_

; ...........................................  BAT2EXE  ..........
COM08:
        call    flush_name_buffer
        mov     si, OFFSET BAT2EXEstr
        _pre_search_
        mov     si, OFFSET bat2exe_sig
        _search_file_
        jc COM09
        _print_file_

; ...........................................  TURBOBAT  ..........
COM09:
        call    flush_name_buffer
        mov     si, OFFSET TURBOBATstr
        _pre_search_
        mov     si, OFFSET turbobat_sig
        _search_file_
        jc COM10
        _print_file_

; ...........................................   BATLITE ..........
COM10:
        call    flush_name_buffer
        mov     si, OFFSET BATLITEstr
        _pre_search_
        mov     si, OFFSET batlite_sig
        _search_file_
        jc COM11
        _print_file_

; ...........................................  TXT2COM  ..........
COM11:
        call    flush_name_buffer
        mov     si, OFFSET TXT2COMstr
        _pre_search_
        mov     si, OFFSET txt2com_sig
        _search_file_
        jc COM12
        _print_file_

; ...........................................  ASC2COM  ..........
COM12:
        call    flush_name_buffer
        mov     si, OFFSET ASC2COMstr
        _pre_search_
        mov     si, OFFSET asc2com_sig
        _search_file_
        jc COM13
        _print_file_

; ...........................................  LAUGHING DOG  ..........
COM13:
        call    flush_name_buffer
        mov     si, OFFSET LAUGHstr
        _pre_search_
        mov     si, OFFSET laugh_sig
        _search_file_
        jc COM14
        _print_file_

; ...........................................  MAKE READ  ..........
COM14:
        call    flush_name_buffer
        mov     si, OFFSET MAKEREADstr
        _pre_search_
        mov     si, OFFSET makeread_sig
        _search_file_
        jc COM15
        _print_file_

; ...........................................  DOC 2 COM  ..........
COM15:
        call    flush_name_buffer
        mov     si, OFFSET DOC2COMstr
        _pre_search_
        mov     si, OFFSET doc2com_sig
        _search_file_
        jc COM16
        _print_file_

; ...........................................  TURBOTXT  ..........
COM16:
        call    flush_name_buffer
        mov     si, OFFSET TURBOTXTstr
        _pre_search_
        mov     si, OFFSET turbotxt_sig
        _search_file_
        jc COM17
        _print_file_

; ...........................................  TXT 2 COM  ..........
COM17:
        call    flush_name_buffer
        mov     si, OFFSET TXT2COM2str
        _pre_search_
        mov     si, OFFSET txt2com2_sig
        _search_file_
        jc COM18
        _print_file_

; ...........................................  SHOW  ..........
COM18:
        call    flush_name_buffer
        mov     si, OFFSET SHOWstr
        _pre_search_
        mov     si, OFFSET show_sig
        _search_file_
        jc COM19
        _print_file_
; ...........................................  DOCMAKER  ..........
COM19:

        call    flush_name_buffer
        mov     si, OFFSET DOCMAKERstr
        _pre_search_
        mov     si, OFFSET docmaker_sig
        _search_file_
        jc COM20
        _print_file_
; ...........................................  TXTMAKER  ..........
COM20:
        call    flush_name_buffer
        mov     si, OFFSET TXTMAKERstr
        _pre_search_
        mov     si, OFFSET txtmaker_sig
        _search_file_
        jc COM21
        _print_file_
; ...........................................  COP 1.0  ..........
COM21:
        call    flush_name_buffer
        mov     si, OFFSET COP10str
        _pre_search_
        mov     si, OFFSET cop10_sig
        _search_file_
        jc COM22
        _print_file_
; ...........................................  COP 1.4  ..........
COM22:
        call    flush_name_buffer
        mov     si, OFFSET COP14str
        _pre_search_
        mov     si, OFFSET cop14_sig
        _search_file_
        jc COM23
        _print_file_
; ...........................................  COM - PAK  ..........
COM23:
        call    flush_name_buffer
        mov     si, OFFSET COMPACK2str
        _pre_search_
        mov     si, OFFSET compack2_sig
        _search_file_
        jc COM24
        _print_file_
; ...........................................  TSR MAKER  ........
COM24:
        call    flush_name_buffer
        mov     si, OFFSET TSRMAKERstr
        _pre_search_
        mov     si, OFFSET tsrmaker_sig
        _search_file_
        jc COM25
        _print_file_

; ........................................  PROTECT EXE/COM ........
COM25:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer
        lodsb
        cmp     al, 0B8h
        jne COM26
        lodsb
        lodsb
        lodsb
        cmp     al, 'P'
        jne COM26
        lodsb
        cmp     al, 0E9h
        jne _Try_20
        mov     si, OFFSET PROTECT1str
        _pre_search_
        call search_found
        _print_file_
_Try_20:
        cmp     al, 0b8h
        jne COM26
        lodsb
        cmp     al, 'P'
        jne COM26
        mov     si, OFFSET PROTECT2str
        _pre_search_
        call search_found
        _print_file_
; ...........................................    ..........
COM26:

; ...........................................    ..........
COM27:

; ...........................................    ..........
COM28:

_isnt_valid_file_type:
        cmp      we_printed_one, 0      ; Already printed the file?
        je _print_it_blank
        ret
_print_it_blank:
        _print_file_                    ; Print the file, even if no
        ret                             ; compression was found

format_com_file         ENDP





;Ŀ
;    Process all .EXE files by searching for certain strings or      
;                sets of bytes within the file.                      
;

format_data             PROC    NEAR
        mov     we_printed_one, 0       ; Reset "printed" flag
        inc     number_files

; ...........................................  PKZIP 1.1  .......
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+2
        lodsb
        cmp     al, 0efh
        jne zip20
        lodsb
        cmp     al, 01h
        jne zip20
        mov     si, OFFSET name_buffer+43
        lodsb
        cmp     al, 39h
        jne zip20
        lodsb
        lodsb
        lodsb
        lodsb
        lodsb
        cmp     al, 30h
        jne zip20
        mov     si, OFFSET PKZIP1str
        _pre_search_
        call search_found
        _print_file_
; ...........................................  PKZIP 2.0  .......
zip20:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+2
        lodsb
        cmp     al, 0bah
        je Got_shit
        cmp     al, 09ah
        je next20_1
        cmp     al, 0f5h
        je next20_1
        jmp @01
next20_1:
        lodsb
        cmp     al, 01h
        jne @01
        mov     si, OFFSET name_buffer+46
        lodsb
        cmp     al, 30h
        jne     @01
        lodsb
        lodsb
        lodsb
        cmp     al, 32h
        jne     @01
        mov     si, OFFSET PKZIP2str
        _pre_search_
        call search_found
        _print_file_
        jmp @01
Got_shit:
        mov     si, OFFSET PKZIPjr2str
        _pre_search_
        call search_found
        _print_file_
; ...........................................  WORDPERFECT  .......
@01:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+16
        lodsb
        cmp     al, 80h
        jne @02
        lodsb
        lodsb
        lodsb
        lodsb
        cmp     al, 12h
        jne @02
        mov     si, OFFSET _WORDPstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................   DIET   .......
@02:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+28
        lodsb
        cmp     al, 'd'
        jne @03
        lodsb
        cmp     al, 'i'
        jne @03
        lodsb
        cmp     al, 'e'
        jne @03
        lodsb
        cmp     al, 't'
        jne @03
        mov     si, OFFSET DIETstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................  another DIET  .......
@03:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+67
        lodsb
        cmp     al, 0a5h
        jne @04
        lodsb
        cmp     al, 'K'
        jne @04
        lodsb
        cmp     al, 'H'
        jne @04
        lodsb
        cmp     al, 'J'
        jne @04
        lodsb
        cmp     al, 'y'
        jne @04
        mov     si, OFFSET DIETstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................  TINYPROG  .........
@04:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+28
        lodsb
        cmp     al, 't'
        jne @05
        lodsb
        cmp     al, 'z'
        jne @05
        mov     si, OFFSET name_buffer+40
        lodsb
        cmp     al, 'T'
        jne @05
        lodsb
        cmp     al, 'Z'
        jne @05
        mov     si, OFFSET TINYPROGstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................   ARJ  .......
@05:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+28
        lodsb
        cmp     al, 'R'
        jne @06
        lodsb
        cmp     al, 'J'
        jne @06
        lodsb
        cmp     al, 'S'
        jne @06
        lodsb
        cmp     al, 'X'
        jne @06
        mov     si, OFFSET ARJstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................     .......
@06:


; ...........................................   LZEXE  .......
@@01:
        call    flush_name_buffer
        mov     si, OFFSET LZEXEstr
        _pre_search_
        mov     bytes_read, 50        ; Adjust so not to over-read loc of sig
        mov     si, OFFSET lzexe_sig

        lodsb                                   ; Load file + search
        xor     ch, ch
        mov     cl, al
        mov     saved_length, al
        mov     file_type, si
        call    see_if_compressed

        jc @@04
        _print_file_
; ...........................................  LHARC 1.13 .........
@@04:
        call    flush_name_buffer
        mov     si, OFFSET LHARCstr
        _pre_search_
        mov     bytes_read, 200       ; Adjust so not to over-read loc of sig
        mov     si, OFFSET lharc_sig
        _search_file_
        jc @@05
        _print_file_
; ...........................................  LHA 2.12 .........
@@05:
        call    flush_name_buffer
        mov     si, OFFSET LHA212str
        _pre_search_
        mov     si, OFFSET lha212_sig
        _search_file_
        jc @@06
        _print_file_
; ...........................................  LHA 2.13 .........
@@06:
        call    flush_name_buffer
        mov     si, OFFSET LHA213str
        _pre_search_
        mov     si, OFFSET lha213_sig
        _search_file_
        jc @@07
        _print_file_
; ...........................................  WINDOWS  .........
@@07:
        call    flush_name_buffer
        mov     si, OFFSET WINDOWstr
        _pre_search_
        mov     bytes_read, 1000      ; Adjust so not to over-read loc of sig
        mov     si, OFFSET window1_sig
        _search_file_
        jc @@075
        _print_file_
; ...........................................  WINDOWS again .......
@@075:
        call    flush_name_buffer
        mov     si, OFFSET WINDOWstr
        _pre_search_
        mov     si, OFFSET window2_sig
        _search_file_
        jc @@076
        _print_file_
; ...........................................   ARC   .........
@@076:
        call    flush_name_buffer
        mov     si, OFFSET ARCstr
        _pre_search_
        mov     si, OFFSET arc_sig
        _search_file_
        jc @@08
        _print_file_
; ...........................................  NORTON    .........
@@08:
        call    flush_name_buffer
        mov     si, OFFSET NORTstr
        _pre_search_
        mov     bytes_read, 200       ; Adjust so not to over-read loc of sig
        mov     si, OFFSET nort_sig
        _search_file_
        jc @@10
        _print_file_

; ==========================================================================
;   AGAIN, WE START LOOKING FOR BYTES, OR STRINGS IN THE FILE.  I TRIED
;   TO OPTIMIZE THE CODE BY HAVING THE MOST "POPULAR" COMPRESSIONS UP
;   FRONT.  THAT WAY, THE STATISTICAL CHANCES OF HAVING YOUR COMPRESSION
;   APPEAR FIRST IS good!!!!
;
;   Do you have any more ideas for how to optimize this procedure?
; ==========================================================================

@@10:                    ;........................  PROTECT EXE/COM ......
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+8
        lodsb
        cmp     al, 02h
        jne @@11
        mov     si, OFFSET name_buffer+28
        lodsb
        cmp     al, 0
        jne Try_20
        lodsb
        cmp     al, 01
        jne @@11
        lodsb
        cmp     al, 02
        jne @@11
        mov     si, OFFSET PROTECT1str
        _pre_search_
        call search_found
        _print_file_
Try_20:
        mov     si, OFFSET name_buffer+29
        lodsb
        cmp     al, 0dbh
        je Got_20
        lodsb
        cmp     al, 0e8h
        je Got_20
        jmp @@11
Got_20:
        mov     si, OFFSET PROTECT2str
        _pre_search_
        call search_found
        _print_file_
; .........................................  BOOK-E TEXT  ...........
@@11:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+36
        lodsb
        cmp     al, 'S'
        jne @012
        lodsb
        cmp     al, 'H'
        jne @012
        lodsb
        cmp     al, 'E'
        jne @012
        lodsb
        cmp     al, 'L'
        jne @012
        lodsb
        cmp     al, 'L'
        jne @012
        mov     si, OFFSET BOOKEstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................  SQUEEZE sfx  ..........
@012:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+2
        lodsb
        cmp     al, 0ach
        jne @013
        lodsb
        cmp     al, 1
        jne @013
        mov     si, OFFSET name_buffer+30
        lodsb
        cmp     al, 50h
        jne @013
        lodsb
        cmp     al, 4bh
        jne @013
        mov     si, OFFSET SQUEEZEstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................  GIF 2 EXE  .........
@013:
        call    flush_name_buffer
        mov     si, OFFSET GIFEXEstr
        _pre_search_
        mov     si, OFFSET gifexe_sig
        _search_file_
        jc @014
        _print_file_

; ...........................................  POWERBAT  ..........
@014:
        call    flush_name_buffer
        mov     si, OFFSET POWERBATstr
        _pre_search_
        mov     si, OFFSET powerbat_sig
        _search_file_
        jc @015
        _print_file_
; ...........................................  BAT 2 EXE  ..........
@015:
        call    flush_name_buffer
        mov     si, OFFSET BAT2EXEstr
        _pre_search_
        mov     si, OFFSET bat2exe_sig
        _search_file_
        jc @016
        _print_file_
; ........................................... TLIFE  ...............
@016:
        call    flush_name_buffer
        mov     si, OFFSET TLIFEstr
        _pre_search_
        mov     si, OFFSET tlife_sig
        _search_file_
        jc @0165
        _print_file_
; ...........................................  TEXE  ............
@0165:
        call    flush_name_buffer
        mov     si, OFFSET TEXEstr
        _pre_search_
        mov     si, OFFSET texe_sig
        _search_file_
        jc @017
        _print_file_
; ...........................................  BIGTEXT  .............
@017:
        call    flush_name_buffer
        mov     si, OFFSET BIGTEXTstr
        _pre_search_
        mov     si, OFFSET bigtext_sig
        _search_file_
        jc @018
        _print_file_
; ...........................................  COM-VERT  ...........
@018:
        call    flush_name_buffer
        mov     si, OFFSET COMVERTstr
        _pre_search_
        mov     si, OFFSET comvert_sig
        _search_file_
        jc @019
        _print_file_
; .........................................  GRAPHIC WORKSHOP  .......
@019:
        call    flush_name_buffer
        mov     si, OFFSET GWSstr
        _pre_search_
        mov     bytes_read, 1000      ; Adjust so not to over-read loc of sig
        mov     si, OFFSET gws_sig
        _search_file_
        jc @20
        _print_file_
; ......................................   GRAPHIC WORKSHOP WINDOWS ..
@20:
        call    flush_name_buffer
        mov     si, OFFSET GWSWINstr
        _pre_search_
        mov     si, OFFSET gwswin_sig
        _search_file_
        jc @21
        _print_file_
; ...........................................  PKLITE  ..........
@21:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+1Eh
        lodsb
        cmp     al, 'P'
        jne @22
        lodsb
        cmp     al, 'K'
        jne @22
        lodsb
        cmp     al, 'L'
        jne @22
        lodsb
        cmp     al, 'I'
        jne @22
        mov     si, OFFSET PKLITEstr
        _pre_search_
        call search_found
        _print_file_
; ...........................................  COM 2 EXE  .........
@22:
        call    flush_name_buffer
        mov     si, OFFSET name_buffer+8
        lodsb
        cmp     al, 2
        jne @225
        mov     si, OFFSET name_buffer+16
        lodsb
        cmp     al, 0FEh
        jne @225
        mov     si, OFFSET name_buffer+21
        lodsb
        cmp     al, 1
        jne @225
        mov     si, OFFSET COM22EXEstr
        _pre_search_
        call search_found
        _print_file_
; .............................................   GRABBER .......
@225:
        call    flush_name_buffer
        mov     si, OFFSET GRABBERstr
        _pre_search_
        mov     si, OFFSET grabber_sig
        _search_file_
        jc @23
        _print_file_


@23:


isnt_valid_file_type:
        cmp      we_printed_one, 0      ; Already printed the file?
        je print_it_blank
        ret
print_it_blank:
        _print_file_                    ; Print the file, even if no
        ret                             ; compression was found

format_data             ENDP



;---------------------------------------------
formatting_engine       PROC    NEAR
        mov     si, OFFSET dta + 30     ; point to name field.
        mov     di, OFFSET display_buffer ; point to storage buffer.
next_store:
        lodsb
        cmp     al, 0
        je      get_file_size
        stosb
        jmp     SHORT next_store
get_file_size:
        mov     di, OFFSET display_buffer + 22 ; point to buffer.
        mov     dx, WORD PTR dta + 26
        mov     ax, WORD PTR dta + 28
        mov     bx, 10
        std
next_size:
        mov     cx, dx
        xor     dx, dx
        div     bx
        xchg    ax, cx
        div     bx
        xchg    ax, dx
        add     al, '0'
        stosb
        mov     ax, cx
        or      cx, dx
        jnz     next_size
do_date:
        cld
        mov     di, OFFSET display_buffer + 26 ; point to buffer.
date:
        mov     dx, WORD PTR dta + 24
        mov     ax, dx
        mov     cl, 5
        ror     ax, cl
        and     ax, 0fh
        mov     cl, 0ffh
        mov     ch, '-'
        call    store_word
        mov     ax, dx
        and     ax, 1fh
        mov     cl, 0
        mov     ch, '-'
        call    store_word
        mov     ax, dx
        mov     cl, 9
        ror     ax, cl
        and     ax, 7fh
        add     ax, 80
        cmp     ax, 100
        jb      finish_date
        sub     ax, 100
finish_date:
        mov     cx, 2000h
        call    store_word
        ret
formatting_engine       ENDP
;-------------------------------------------
store_word              PROC    NEAR
        div     bl
        add     ax, '00'
        cmp     cl, 0
        je      store_it
        cmp     al, '0'
        jne     store_it
        mov     al, 32
store_it:
        stosw
        mov     al, ch
        stosb
        ret
store_word              ENDP
;-------------------------------------------
see_if_compressed       PROC    NEAR
        mov     dx, OFFSET dta + 30     ; point to name field.
        xor     al, al
        mov     ah, 3dh                 ; open it for reading
        int     21h
        jc      error
        mov     file_handle, ax
        mov     ah, 3fh                 ; Read the file
        mov     bx, file_handle
        mov     cx, 1000d               ; Get 1,000 bytes
        mov     dx, OFFSET name_buffer
        int     21h
        mov     bytes_read, ax          ; actual # of bytes read
        mov     bx, file_handle
        mov     ah, 3eh                 ; close the file
        int     21h
;------------------------------------------  SEARCH FOR THE BYTES  --------
do_search:
        xor     bp, bp
        mov     cx, bytes_read
search_loop:
        call    search_engine
        je      search_found
        inc     bp
        loop    search_loop
error:
        stc
        ret
search_found:
        mov     si, comp_method
        mov     di, OFFSET display_buffer + 38
        xor     ch, ch
        mov     cl, compress_length
        repe    movsb
        clc
        ret
see_if_compressed       ENDP
;---------------------------------------
search_engine           PROC    NEAR
        push    cx
        cld
        mov     si, file_type
        mov     di, OFFSET name_buffer
        xor     ch, ch
        mov     cl, saved_length
        add     di, bp
        repe    cmpsb
        pop     cx
        ret
search_engine           ENDP
;---------------------------------------
display_data_field      PROC    NEAR
        cmp     we_printed_one, 0
        je go_ahead_print
        ret
go_ahead_print:
        mov     we_printed_one, 1
        mov     si, OFFSET display_buffer
        call    display_string
        mov     al, 0dh
        call    write_text
        mov     al, 0ah
        call    write_text
        ret
display_data_field      ENDP
;-----------------------------------------
display_string          PROC    NEAR
        lodsb
        cmp     al, 0
        je      end_text@
        call    write_text
        jmp     SHORT display_string
end_text@:
        ret
display_string          ENDP
;-----------------------------------------
write_text              PROC    NEAR
        mov     ah, 0eh
        mov     bh, 0
        int     10h
        ret
write_text              ENDP
;-----------------------------------------
flush_name_buffer       PROC    NEAR
        mov     di, OFFSET display_buffer ; point to storage buffer.
        mov     al, ' '
        mov     cx, 75
        cld
        repe    stosb
        ret
flush_name_buffer       ENDP
;-----------------------------------------
color_display_string          PROC    NEAR
        lodsb
        cmp     al, 0
        je      enda_text@
        call    write_color
        jmp     SHORT color_display_string
enda_text@:
        ret
write_color:
        mov     ah, 09h
        int     10h
        ret
color_display_string          ENDP
;-----------------------------------------
get_char    PROC    NEAR
        mov     ax, 0b00h               ; Is char waiting?
        int 21h
        cmp     al, 0ffh
        je get_that_char
        ret
get_that_char:
        mov     ax, 01000h              ; Get a character
        int 16h
        cmp     al, 01bh                ; [ESC] pressed?
        je stop_it
        cmp     al, ' '                 ; [SPACEBAR] pressed?
        je  go_back
        jmp get_that_char
go_back:
        ret
stop_it:
        mov     ax, 4c01h               ; If so, get outta here
        int 21h
get_char        ENDP



ascii_convert   proc near
;
;       -Put byte to be converted into AL
;       -Point DI to start of location to store ascii'ized AL value
;
        push    bx
        mov     bl, 100d
        div     bl              ;divide by 100
        mov     bl, al
        add     bl, 30h         ;convert to ascii
        mov     [di], bl        ;store ascii
        xchg    ah, al          ;work on remainder
        xor     ah, ah          ;zero upper byte
        mov     bl, 10d
        div     bl              ;divide by 10
        mov     bl, al
        add     bl, 30h
        mov     [di][1], bl
        xchg    bl, ah          ;store remainder directly into BL
        add     bl, 30h
        mov     [di][2], bl
        pop     bx
        ret
ascii_convert        endp




;-----------------------------------------
name_buffer:
;-----------------------------------------
code                    ENDS
END             start
