/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/**************************************************************************
 * This program displays the DOS version number and a pre-defined Free-DOS
 * release version.  You will need to recompile this program each time you
 * make a major Free-DOS release.
 *
 * NOTE: Please refer to this project as "Free-DOS", not "FreeDOS".  I like
 * to use that dash.  The reason is that there was once a dispute between
 * Free-DOS and another group called "Freedos" with different goals.
 *
 * Author: James Hall
 */

#include <stdio.h>
#include <stdlib.h>
#include "getopt.h"
#include "freedos.h"

#define SPACE "   "


void usage (void);


main (int argc, char **argv)
{
  char c;
  int iDos = 0;

  /* Scan the command line */

  while ((c = getopt (argc, argv, "dD?")) != EOF)
    {
      switch (c)
	{
	case 'd':
	case 'D':
	  /* Dos only! */
	  iDos = 1;
	  break;
	default:
	  usage ();
	  break;
	}
    }

  if ((argc - optind) > 0)
    usage ();

  /* Display the version numbers */
  /* _osmajor and _osminor from Quick-C display the version numbers
     for DOS */

  printf ("\n%sDOS version %u.%2.2u", SPACE, _osmajor, _osminor);

  if (!iDos)
    printf ("%sFree-DOS version %s", SPACE, VER_REL);

  printf ("\n");
  exit (0);
}

void 
usage (void)
{
  printp ("VER", "Prints the DOS version and the major Free-DOS release.");
  printu ("VER", "[/D]");
  printo ("/D", "Display the DOS version number only.");
  exit (1);
}
