/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/***********************************************************************
 * This program displays a file or set of files one screenful at a time.
 *
 * Author: James Hall
 */

#include <stdio.h>
#include <conio.h>
#include "getopt.h"
#include "freedos.h"


void usage (void);


main (int argc, char **argv)
{
  int i, iLines;
  char ch;
  FILE *pFile;

  /* Scan the command line */

  while ((i = getopt (argc, argv, "?")) != EOF)
    {
      switch (i)
	{
	default:
	  usage ();
	}
    }

  /* Get the screen size */

  iLines = lines () - 2;

  /* Display files */

  if ((optind - argc) == 0)
    pagef (stdin, iLines);

  for (i = optind; i < argc; i++)
    {
      if ((pFile = fopen (argv[i], "r")) != NULL)
	{
	  pagef (pFile, iLines);
	  fclose (pFile);
	}
      else
	fprintf (stderr, "Cannot read file %s\n", argv[i]);
    }

  exit (0);
}

void 
usage (void)
{
  printp ("MORE", "Displays a file or set of files one screenful at a time.");
  printu ("MORE", "[file..]");
  exit (1);
}
