/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include <stdio.h>
#include <ctype.h>
#include "freedos.h"


/**************************************************************************
 * This function displays a file from FILE *p to the standard output stream,
 * much like UNIX 'cat'.  There are a few enhancements to allow control over
 * the display of the file.
 *
 * Author: James Hall
 */

void 
fcat (FILE * p, int iNum, int iBlank, int iCtrl, int iEnds,
      int iTabs, int iUpc, int iDownc)
{
  int i, iLen, iLast = 0;
  long lLines;
  char c, sz[MAX_STR];

  /* Read the file until EOF */

  for (lLines = 1; fgets (sz, MAX_STR, p) != NULL; lLines++)
    {
      iLen = strlen (sz);

      /* Squeeze blank lines if needed */

      if ((iLast) && (iLast = blank (sz)) && (iBlank));

      /* Number the output if needed */

      else
	{

	  if (iNum)
	    {
	      printf ("%ld:", lLines);
	    }

	  /* Print specials if needed */

	  for (i = 0; i < (iLen - 1); i++)
	    {

	      /* Convert to upper or lower */

	      if (iUpc)
		{
		  sz[i] = toupper (sz[i]);
		}

	      else if (iDownc)
		{
		  sz[i] = tolower (sz[i]);
		}

	      if ((iscntrl (sz[i])) && (iCtrl))
		{
		  printf ("^%c", sz[i] + 64);
		}

	      else if ((sz[i] == '\t') && (iTabs))
		{
		  printf ("^%c", sz[i] + 64);
		}

	      else
		{
		  printf ("%c", sz[i]);
		}
	    }

	  /* Print the EOL if needed */

	  if (iEnds)
	    {
	      printf ("$");
	    }

	  printf ("\n");
	}
    }

  return;
}
