#define ANSI			/* Uncomment to use ANSI C */

/*
Here it is.  Sorry about the lack of comments in the code, but I've found
it's more useful (and often more efficient) to spend more time commenting
the function header than it is to comment the code.  But first, here is
some sample output of the test program:

Path name = "c:\private\freedos\freedos.exe"
Base name = "FREEDOS"

Path name = "c:\foo.old\foo"
Base name = "FOO"

Path name = "foo.exe"
Base name = "FOO"
*/

/*
   John Hall, <jchall@tasc.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>		/* for NULL */
#include <string.h>		/* for string functions (strrchr, strcpy, etc.) */

typedef int BOOL;
#define FALSE (0)
#define TRUE  (1)

/************************************************************************
 * Returns in szDest the program name extracted from szPathName,
assumed
 * to originate from argv[0].  The program name is extracted by stripping
 * off all leading paths as well as any extension to the file name.  The
 * program name is converted to uppercase.
 *
 * For example, after calling it like so:
 *
 * fBaseName(szBuffer, "c:\\free-dos\\beta\\_type.exe");
 *
 * 'szBuffer' would contain:
 *
 * _TYPE
 *
 * Returns: TRUE if successful, FALSE otherwise
 */
BOOL 
fBasename (char *szDest, char *szPathName)
{
  char *szBaseName, *pchDot;
  int cch;

  if ((szDest == NULL) || (szPathName == NULL))
    return FALSE;

  szBaseName = strrchr (szPathName, '\\');
  if (szBaseName == NULL)
    szBaseName = szPathName;
  else
    szBaseName++;
  pchDot = strrchr (szPathName, '.');

  if ((pchDot == NULL) || (pchDot < szBaseName))
    strcpy (szDest, szBaseName);
  else
    {
      cch = pchDot - szBaseName;

      strncpy (szDest, szBaseName, cch);
      szDest[cch] = '\0';
    }

#ifndef ANSI
  strcpy (szDest, strupr (szDest));
#endif /* ANSI */

  return TRUE;
}
