#define MAXLINES 128

#include <stdio.h>
#include <alloc.h>

/*
long history_size = 80;

long history_used = 0;
*/

void history (int dir, char *commandline)
{
   static char *history = NULL, *lines[MAXLINES];
   static long pos = 0, curline = 0, numlines = 0, maxpos = 0;
   int count, length;

   if (!history)
   {
      history = malloc (history_size * sizeof (char));

      lines[0] = history;
   }

   if (dir > 0)         // next command
   {
      if (curline < numlines - 1)
         curline++;

      strcpy (commandline, lines[curline]);
   }
   else if (dir < 0)    // prev command
   {
      if (curline > 0)
         curline--;

      strcpy (commandline, lines[curline]);
   }
   else                 // add to history
   {
      while (maxpos + strlen (commandline) + 1 > history_size ||
             numlines >= MAXLINES)
      {
         length = strlen (lines[0]) + 1;

         for (count = 0; count < maxpos &&
                      count + (lines[1] - lines[0]) < history_size; count++)
            history[count] = history[count + length];

         maxpos -= length;

         for (count = 0; count <= numlines && count < MAXLINES; count++)
            lines[count] = lines[count + 1] - length;

         numlines--;

         printf ("Reduced size:  %ld lines\n", numlines);

         for (count = 0; count < numlines; count++)
            printf ("%d: %s\n", count, lines[count]);
      }

      strcpy (lines[numlines], commandline);

      numlines++;

      lines[numlines] = lines[numlines - 1] + strlen (commandline) + 1;

      maxpos += strlen (commandline) + 1;

      curline = numlines - 1;
   }

/*
   history_used = maxpos;
*/

/*
   for (count = 0; count < numlines; count++)
      printf ("%d:  %s\n", count, lines[count]);
*/
}

/*
void main ()
{
   int ch;
   char s[128];

   do
   {
      printf (" 1.  Add string.\n");
      printf (" 2.  Back up string.\n");
      printf (" 3.  Go forward string.\n");
      printf (" 4.  Quit.\n");

      ch = getche ();
      puts ("");

      switch (ch)
      {
	 case '1':
	    printf ("Enter string: ");
	    gets (s);
	    history (0, s);
	    break;
	 case '2':
	    printf ("Prev String: ");
	    history (-1, s);
	    puts (s);
	    break;
	 case '3':
	    printf ("Next String: ");
	    history (1, s);
	    puts (s);
	    break;
	 case '4':
	    puts ("Quitting");
	    break;
	 default:
	    puts ("Invalid choice!");
      }

      printf ("%ld bytes used in buffer.\n", used);
   }
   while (ch != '4');
}
*/
